/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessCargaTabela;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.controller.ControladorAIDsGetCard;
import com.csi.ctfclient.operacoes.model.controller.ControladorMultiEC;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import java.util.Arrays;
import java.util.List;

public class MicSubProcessCargaTabela {
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String REFAZ_LEITURA = "REFAZ_LEITURA";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        ProcessManager processManager = ProcessManager.getInstance();
        ProcessCargaTabela process = new ProcessCargaTabela(dados.getProcessConstructorArguments());
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        boolean multiEC = config.isMultiEC();
        IdentTerminal identTerminal = null;
        identTerminal = multiEC ? ControladorMultiEC.criarTerminalComumMultiEC(config.getCodigoGrupoMultiEC()) : new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
        ControladorAIDsGetCard controladorAIDsGetCard = ControladorAIDsGetCard.getInstance(identTerminal);
        boolean listarAids = controladorAIDsGetCard.getMapAid() != null;
        try {
            processManager.subProcess(dados.getIdProcess(), process);
            List<Integer> operacoesValidas = Arrays.asList(OperationEnum.OP_CARGA_TABELA.getKey(), OperationEnum.OP_CONFIGURACAO_TERMINAL.getKey());
            if (entradaIntegracao == null || !operacoesValidas.contains(entradaIntegracao.getOperacao())) {
                Contexto.getContexto().setSaidaApiTefC(null);
            }
            if (saidaApiTefC != null) {
                Contexto.getContexto().setSaidaApiTefC(saidaApiTefC);
            }
            Contexto.getContexto().atualizaEntradaApiTefC(entradaApiTefC);
            if (process.getState() == 3) {
                return USERCANCEL;
            }
            if (process.getState() == 1) {
                Contexto.getContexto().resetCartao();
                return ERRO;
            }
            controladorAIDsGetCard = ControladorAIDsGetCard.getInstance(identTerminal);
            if (!listarAids && controladorAIDsGetCard.getMapAid() != null) {
                Contexto.getContexto().setNovaLeituraCartao(true);
                return REFAZ_LEITURA;
            }
            return SUCESS;
        }
        catch (Exception e) {
            logger.error("Erro generico ao processar carga de tabelas: " + e.getMessage());
            if (Contexto.getContexto().getErroIntegracao() == null) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.TENTE_NOVAMENTE, "TENTE NOVAMENTE"));
            }
            return ERRO;
        }
    }
}

