/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessLeituraPin;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.ControladorModeloPinPad;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicSubProcessConfirmaCPF {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String CAPTURA_NAO_CONFIRMADA = "CAPTURA_NAO_CONFIRMADA";
    private static final String MSG_CONFIRMA_PINPAD = "CONFIRMA?";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) {
        Boolean status;
        String cpf = Contexto.getContexto().getEntradaApiTefC().getCpf();
        String display = cpf.substring(0, 3) + "." + cpf.substring(3, 6) + "." + cpf.substring(6, 9) + "-" + cpf.substring(9);
        try {
            PinEMV pinEMV = dados.getPerifericos().getPin();
            status = this.confirmaPinpad(dados, pinEMV, display);
        }
        catch (ExcecaoPerifericos e) {
            logger.error("Erro ao confirmar dado no pin: " + e.getMessage());
            return ERROR;
        }
        if (status == null) {
            return ERROR;
        }
        if (status.booleanValue()) {
            return SUCCESS;
        }
        return CAPTURA_NAO_CONFIRMADA;
    }

    private Boolean confirmaPinpad(Process dados, PinEMV pin, String dado) throws ExcecaoPerifericos {
        Criptografia criptografia = null;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        try {
            criptografia = ControladorModeloPinPad.getInstance().getCriptografia(pin);
        }
        catch (Exception e) {
            logger.warn("Erro ao tentar definir o tipo de criptografia: " + e.getMessage());
        }
        String mensagemPin = StringUtil.completaString(dado, 16, ' ', 4) + MSG_CONFIRMA_PINPAD;
        ProcessManager processManager = ProcessManager.getInstance();
        ProcessLeituraPin processLeituraPin = new ProcessLeituraPin(dados.getProcessConstructorArguments(), criptografia, null, false, false);
        processLeituraPin.setActiveDialogUserCancel(false);
        processLeituraPin.setTituloAguardaPin(inter.getMessage("EXICONTEL_MSG_CONFIRMACAO"));
        perifericos.getPin().setMsgDisplay(mensagemPin);
        processLeituraPin.setTipoLeituraPin(3);
        try {
            processManager.subProcess(dados.getIdProcess(), processLeituraPin);
            if (dados.getPerifericos().getPin() instanceof BibliotecaPinpad) {
                BibliotecaPinpad pinpad = (BibliotecaPinpad)dados.getPerifericos().getPin();
                pinpad.desabilita(true);
            }
            if (processLeituraPin.getState() == 3 || processLeituraPin.getState() == 5) {
                logger.info("confirmacao cancelada pelo usuario.");
                return false;
            }
            if (processLeituraPin.getState() == 1) {
                logger.error("erro na confirmacao do dado capturado.");
                return null;
            }
            if (processLeituraPin.getTeclaFuncaoPressionada() != 0) {
                logger.info("usuario nao confirmou o dado capturado.");
                return false;
            }
        }
        catch (Exception e) {
            logger.error("Erro no subprocesso de leitura do pin: " + e.getMessage());
            return null;
        }
        return true;
    }
}

