/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.model.Premio;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessLeituraPin;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.ControladorModeloPinPad;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicSubProcessConfirmacaoResgatePremio
extends MicAbstractBase {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";
    public static final String MSG_CONFIRMA_PINPAD = "CONFIRMA?";
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        Criptografia criptografia = null;
        try {
            PinEMV pin = this.tryGetPin();
            if (pin != null) {
                criptografia = ControladorModeloPinPad.getInstance().getCriptografia(pin);
            }
        }
        catch (Exception e) {
            this.logger.warn("Erro ao tentar definir o tipo de criptografia: " + e.getMessage());
        }
        Premio premio = entradaApiTefC.getPremio();
        String mensagemPin = premio.getDescricao().length() > 16 ? premio.getDescricao().substring(0, 16) : StringUtil.completaString(premio.getDescricao(), 16, ' ', 4);
        mensagemPin = mensagemPin + "RESGATAR?   " + StringUtil.completaString(String.valueOf(entradaApiTefC.getQuantidadePremios()), 4, ' ', 3);
        ProcessManager processManager = ProcessManager.getInstance();
        ProcessLeituraPin processLeituraPin = new ProcessLeituraPin(dados.getProcessConstructorArguments(), criptografia, null, false, false);
        processLeituraPin.setActiveDialogUserCancel(false);
        processLeituraPin.setTituloAguardaPin(this.inter.getMessage("CONRESPRE_TITLE_TELA"));
        this.tryShowMessagePinpad(mensagemPin);
        processLeituraPin.setTipoLeituraPin(3);
        processManager.subProcess(dados.getIdProcess(), processLeituraPin);
        if (processLeituraPin.getState() == 3) {
            entradaApiTefC.setQuantidadePremios(0);
            return USER_CANCEL;
        }
        if (processLeituraPin.getState() == 5) {
            entradaApiTefC.setQuantidadePremios(0);
            return USER_CANCEL_INTERNAL;
        }
        if (processLeituraPin.getState() == 1) {
            return ERROR;
        }
        if (processLeituraPin.getTeclaFuncaoPressionada() == 0) {
            return SUCCESS;
        }
        return USER_CANCEL;
    }
}

