/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.ProcessCreditoDigital;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;

public class MicSubProcessConsultaCreditoDigital {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String FILLED_AC = "FILLED_AC";
    public static final String ERROR = "ERROR";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaApiTefC.getValorTransacao() != null) {
            return FILLED;
        }
        if (entradaIntegracao != null && entradaIntegracao.isValorTransacaoCtrl()) {
            return FILLED_AC;
        }
        logger.info("Executando o subprocesso para consulta de cr\u00e9dito digital");
        ProcessManager processManager = ProcessManager.getInstance();
        ProcessCreditoDigital processCreditoDigital = null;
        int numeroTransacao = entradaIntegracao != null ? entradaIntegracao.getNumeroTransacao() : 1;
        String tipoOperacao = Contexto.getContexto().getTipoOperacao();
        processCreditoDigital = new ProcessCreditoDigital(dados.getProcessConstructorArguments(), entradaIntegracao, numeroTransacao, OperationEnum.OP_CONSULTA_VALORES_CREDITO_DIGITAL.getDescription());
        processCreditoDigital.setActiveDialogUserCancel(false);
        Contexto.getContexto().setTelefoneConfirmado(true);
        processManager.subProcess(dados.getIdProcess(), processCreditoDigital);
        Contexto.getContexto().setTipoOperacao(tipoOperacao);
        if (processCreditoDigital.getState() == 3) {
            return USER_CANCEL;
        }
        if (processCreditoDigital.getState() == 1) {
            return ERROR;
        }
        if (processCreditoDigital.getState() == 5) {
            return USER_CANCEL_INTERNAL;
        }
        return SUCESS;
    }
}

