/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.ProcessCreditoCelular;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.emvfull.GenericPinpadController;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;

public class MicSubProcessCreditoCelular {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String USER_CANCEL = "USER_CANCEL";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        ProcessManager processManager = ProcessManager.getInstance();
        ProcessCreditoCelular processCelular = null;
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (entradaIntegracao != null) {
            if (entradaIntegracao.getOperacao() == OperationEnum.OP_CREDITO.getKey().intValue()) {
                entradaIntegracao.setOperacao(OperationEnum.OP_CREDITO_CELULAR_AVISTA.getKey());
            } else if (entradaIntegracao.getOperacao() == OperationEnum.OP_CRED_PARC_SEM_JUROS.getKey().intValue()) {
                entradaIntegracao.setOperacao(OperationEnum.OP_CREDITO_CELULAR_PARC_LOJISTA.getKey());
            } else if (entradaIntegracao.getOperacao() == OperationEnum.OP_CRED_PARC_COM_JUROS.getKey().intValue()) {
                entradaIntegracao.setOperacao(OperationEnum.OP_CREDITO_CELULAR_PARC_ADMINISTRADORA.getKey());
            }
            processCelular = new ProcessCreditoCelular(dados.getProcessConstructorArguments(), entradaIntegracao, entradaApiTefC.getNumeroTransacao());
        } else {
            processCelular = new ProcessCreditoCelular(dados.getProcessConstructorArguments(), entradaApiTefC.getNumeroTransacao(), entradaApiTefC.getValorTransacao());
        }
        boolean comunicacaoSeguraOld = GenericPinpadController.isSecureCommunication();
        ProtocoloBibliotecaCompartilhada.setSecureCommunication(false);
        processManager.subProcess(dados.getIdProcess(), processCelular);
        ProtocoloBibliotecaCompartilhada.setSecureCommunication(comunicacaoSeguraOld);
        Contexto.getContexto().setSubProcess(processCelular);
        switch (processCelular.getState()) {
            case 1: {
                return ERROR;
            }
            case 3: {
                return USER_CANCEL;
            }
            case 0: {
                return SUCCESS;
            }
            case 2: {
                return SUCCESS;
            }
        }
        return SUCCESS;
    }
}

