/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.ProcessCriptografiaDUKPT;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;

public class MicSubProcessCriptografiaDUKPT {
    public static final String SUCCESS = "SUCCESS";
    public static final String USERCANCEL_INTERNAL = "USERCANCEL_INTERNAL";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String ERROR = "ERROR";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) {
        ProcessManager processManager = ProcessManager.getInstance();
        ProcessCriptografiaDUKPT processCriptografiaDUKPT = null;
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        int numeroTransacao = 0;
        numeroTransacao = entradaIntegracao != null ? entradaIntegracao.getNumeroTransacao() : entradaApiTefC.getNumeroTransacao();
        try {
            processCriptografiaDUKPT = new ProcessCriptografiaDUKPT(dados.getProcessConstructorArguments(), Contexto.getContexto().getTipoOperacao(), entradaIntegracao, numeroTransacao, 0);
            processCriptografiaDUKPT.setActiveDialogUserCancel(false);
            processManager.subProcess(dados.getIdProcess(), processCriptografiaDUKPT);
            if (saidaApiTefC != null) {
                Contexto.getContexto().setSaidaApiTefC(saidaApiTefC);
            }
            entradaApiTefC.setIdentificadorChaveRSA(null);
            entradaApiTefC.setCertificadoCriptografico(null);
            if (processCriptografiaDUKPT.getState() == 3) {
                return USER_CANCEL;
            }
            if (processCriptografiaDUKPT.getState() == 1) {
                return ERROR;
            }
            if (processCriptografiaDUKPT.getState() == 5) {
                return USERCANCEL_INTERNAL;
            }
            return SUCCESS;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            if (Contexto.getContexto().getErroIntegracao() == null) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.TENTE_NOVAMENTE, "TENTE NOVAMENTE"));
            }
            return ERROR;
        }
    }
}

