/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessLeituraPin;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.ControladorModeloPinPad;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.text.ParseException;
import javax.swing.text.MaskFormatter;

public class MicSubProcessExibeConfirmacaoIdentificacao4All
extends MicAbstractBase {
    public static final String SUCCESS = "SUCCESS";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";
    public static final String ERROR = "ERROR";
    private static final String MSG_CONFIRMA_PINPAD = "CONFIRMA?";
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();

    private static String maskString(String value, String pattern) {
        try {
            MaskFormatter mf = new MaskFormatter(pattern);
            mf.setValueContainsLiteralCharacters(false);
            return mf.valueToString(value);
        }
        catch (ParseException ex) {
            return value;
        }
    }

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        String mensagem;
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        if (entrada.getTipoIdentificacao4all() == 1) {
            String mascara = entrada.getTelefoneMovel().length() == 10 ? "(##)####-####" : "(##)#####-####";
            mensagem = MicSubProcessExibeConfirmacaoIdentificacao4All.maskString(entrada.getTelefoneMovel(), mascara);
        } else if (entrada.getTipoIdentificacao4all() == 2) {
            mensagem = MicSubProcessExibeConfirmacaoIdentificacao4All.maskString(entrada.getCpf(), "###.###.###-##");
        } else {
            return ERROR;
        }
        return this.confirmaDado(dados, entrada, mensagem);
    }

    private String confirmaDado(Process dados, EntradaApiTefC entrada, String mensagem) throws ExcecaoNaoLocal {
        Criptografia criptografia = null;
        try {
            PinEMV pin = this.tryGetPin();
            if (pin != null) {
                criptografia = ControladorModeloPinPad.getInstance().getCriptografia(pin);
            }
        }
        catch (Exception e) {
            this.logger.warn("Erro ao tentar definir o tipo de criptografia: " + e.getMessage());
        }
        String mensagemPin = StringUtil.completaString(mensagem, 16, ' ', 4) + MSG_CONFIRMA_PINPAD;
        ProcessManager processManager = ProcessManager.getInstance();
        ProcessLeituraPin processLeituraPin = new ProcessLeituraPin(dados.getProcessConstructorArguments(), criptografia, null, false, false);
        processLeituraPin.setActiveDialogUserCancel(false);
        processLeituraPin.setTituloAguardaPin(this.inter.getMessage("EXICONTEL_MSG_CONFIRMACAO"));
        this.tryShowMessagePinpad(mensagemPin);
        processLeituraPin.setTipoLeituraPin(3);
        processManager.subProcess(dados.getIdProcess(), processLeituraPin);
        if (processLeituraPin.getState() == 3 || processLeituraPin.getState() == 5) {
            Contexto.getContexto().setErroIntegracao(null);
            entrada.setTipoIdentificacao4all(-1);
            entrada.setTelefoneMovel(null);
            entrada.setCpf(null);
            if (processLeituraPin.getState() == 3) {
                return USER_CANCEL;
            }
            return USER_CANCEL_INTERNAL;
        }
        if (processLeituraPin.getState() == 1) {
            return ERROR;
        }
        if (processLeituraPin.getTeclaFuncaoPressionada() != 0) {
            return "RERUN";
        }
        return SUCCESS;
    }
}

