/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessCargaTabelaPreemptiva;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessLeituraCartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;

public class MicSubProcessLeituraCartao
extends MicAbstractBase {
    public static final String SUCESS = "SUCESS";
    public static final String SUBPROCESS_CREDITO_CELULAR = "SUBPROCESS_CREDITO_CELULAR";
    public static final String ERRO = "ERRO";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String USERCANCEL_INTERNAL = "USERCANCEL_INTERNAL";
    public static final String FILLED = "FILLED";

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        String operacao;
        EntradaCTFClientCtrl entradaIntegracao;
        if (Contexto.getContexto().isNovaLeituraCartao()) {
            try {
                dados.getPerifericos().getLeitorCartao().getLeitorCartao().setRereading(true);
            }
            catch (ExcecaoPerifericos excecaoPerifericos) {
                this.logger.error("Erro ao tentar definir a releitura do cartao: " + excecaoPerifericos.getMessage());
                return ERRO;
            }
            Contexto.getContexto().setNovaLeituraCartao(false);
            Contexto.getContexto().resetCartao();
        }
        if (Contexto.getContexto().isTransacaoGenerica() && Contexto.getContexto().getCartao() != null) {
            return FILLED;
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null && !Contexto.getContexto().getEntradaIntegracao().isConsulta() && Contexto.getContexto().getCartao() != null) {
            return SUCESS;
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null && !Contexto.getContexto().getEntradaIntegracao().isConsulta() && Contexto.getContexto().isTransacaoSemCartao() && ((entradaIntegracao = Contexto.getContexto().getEntradaIntegracao()).getOperacao() == OperationEnum.OP_CREDITO_CELULAR_AVISTA.getKey().intValue() || entradaIntegracao.getOperacao() == OperationEnum.OP_CREDITO_CELULAR_PARC_ADMINISTRADORA.getKey().intValue() || entradaIntegracao.getOperacao() == OperationEnum.OP_CREDITO_CELULAR_PARC_LOJISTA.getKey().intValue())) {
            return SUBPROCESS_CREDITO_CELULAR;
        }
        ProcessManager processManager = ProcessManager.getInstance();
        ProcessCargaTabelaPreemptiva processCargaTabelas = new ProcessCargaTabelaPreemptiva(dados.getProcessConstructorArguments());
        processManager.subProcess(dados.getIdProcess(), processCargaTabelas);
        if (processCargaTabelas.getState() != 0) {
            this.logger.error("Erro ao realizar carga de tabelas preemptiva");
            return ERRO;
        }
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (saidaApiTefC != null && !(operacao = saidaApiTefC.getCodigoRespostaAutorizadora()).equals("F3") && !operacao.equals("0F3")) {
            Contexto.getContexto().setSaidaApiTefC(null);
        }
        ProcessLeituraCartao processLeituraCartao = new ProcessLeituraCartao(dados.getProcessConstructorArguments());
        processLeituraCartao.setActiveDialogUserCancel(false);
        try {
            processManager.subProcess(dados.getIdProcess(), processLeituraCartao);
            if (Contexto.getContexto().isNovaLeituraCartao()) {
                return "RERUN";
            }
            if (processLeituraCartao.getState() == 3) {
                return USERCANCEL;
            }
            if (processLeituraCartao.getState() == 1) {
                return ERRO;
            }
            if (processLeituraCartao.getState() == 5) {
                return USERCANCEL_INTERNAL;
            }
            if (Contexto.getContexto().isSubfluxoCreditoCelular()) {
                Contexto.getContexto().setTransacaoSemCartao(true);
                return SUBPROCESS_CREDITO_CELULAR;
            }
            return SUCESS;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            if (Contexto.getContexto().getErroIntegracao() == null) {
                this.setIntegrationError(CodigoErroIntegracaoEnum.TENTE_NOVAMENTE, "TENTE NOVAMENTE");
            }
            return ERRO;
        }
    }
}

