/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.ProcessFidelidadeMilhas;
import com.csi.ctfclient.operacoes.action.ProcessPixPayment;
import com.csi.ctfclient.operacoes.action.ProcessPreAutorizacao;
import com.csi.ctfclient.operacoes.action.ProcessQrCodeGenerico;
import com.csi.ctfclient.operacoes.action.ProcessResgateFacil;
import com.csi.ctfclient.operacoes.action.ProcessTransacoesGenericas;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import java.util.ArrayList;

public class MicTefIPOperacaoCartao {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";
    public static final String ERROR_AC = "ERROR_AC";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        ControladorPerifericos perifericos = dados.getPerifericos();
        String OP_MENU_CREDITO = "CREDITO";
        String OP_MENU_DEBITO = "DEBITO";
        String OP_QR_CODE_PAYMENT = "PAGAMENTO QR CODE";
        String OP_MENU_PRE_AUTORIZACAO = "PRE-AUTORIZACAO";
        String OP_MENU_RESGATE_FACIL = "RESGATE FACIL";
        String OP_MENU_RESGATE_FIDELIDADE_MILHAS = "RESGATE FIDELIDADE MILHAS";
        String OP_MENU_PIX_PAYMENT = "PAGAMENTO PIX";
        ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
        IdentTerminal identTerminal = new IdentTerminal(confCTFClient.getEstabelecimento(), confCTFClient.getLoja(), confCTFClient.getTerminal());
        DadosInicioDia dadosInicioDia = ControladorInicioDia.getInstance().getDadosInicioDia(identTerminal);
        boolean isResgateFacil = false;
        boolean isResgateFidelidadeMilhas = false;
        boolean enableQrCode = false;
        if (dadosInicioDia != null) {
            isResgateFacil = dadosInicioDia.isResgateFacil();
            isResgateFidelidadeMilhas = dadosInicioDia.isResgateFidelidadeMilhas();
            enableQrCode = dadosInicioDia.isQrCode();
        }
        ArrayList<String> options = new ArrayList<String>();
        options.add(OP_MENU_CREDITO);
        options.add(OP_MENU_DEBITO);
        if (enableQrCode) {
            options.add("PAGAMENTO QR CODE");
        }
        options.add(OP_MENU_PRE_AUTORIZACAO);
        if (isResgateFacil) {
            options.add(OP_MENU_RESGATE_FACIL);
        }
        if (isResgateFidelidadeMilhas) {
            options.add(OP_MENU_RESGATE_FIDELIDADE_MILHAS);
        }
        options.add("PAGAMENTO PIX");
        int opcao = perifericos.showSingleChoiceMenu(dados, "MEIO DE PAGAMENTO", options);
        if (opcao == -1) {
            return USER_CANCEL;
        }
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        ProcessManager processManager = ProcessManager.getInstance();
        int state = -1;
        String itemMenu = (String)options.get(opcao);
        if (itemMenu.equals(OP_MENU_CREDITO)) {
            int operacaoAtual = Contexto.getContexto().getEntradaIntegracao().getOperacao();
            Contexto.getContexto().getEntradaIntegracao().setOperacao(OperationEnum.OP_CREDITO_GENERICO.getKey());
            ProcessTransacoesGenericas processCredito = new ProcessTransacoesGenericas(dados.getProcessConstructorArguments(), entradaIntegracao.getNumeroTransacao(), entradaIntegracao.getValorTransacao(), entradaIntegracao.getNumeroCupom(), OperationEnum.OP_CREDITO_GENERICO.getDescription(), 0);
            processCredito.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), processCredito);
            dados.setErro(processCredito.getErro());
            Contexto.getContexto().getEntradaIntegracao().setOperacao(operacaoAtual);
            state = processCredito.getState();
        } else if (itemMenu.equals(OP_MENU_DEBITO)) {
            int operacaoAtual = Contexto.getContexto().getEntradaIntegracao().getOperacao();
            Contexto.getContexto().getEntradaIntegracao().setOperacao(OperationEnum.OP_DEBITO_GENERICO.getKey());
            ProcessTransacoesGenericas processDebito = new ProcessTransacoesGenericas(dados.getProcessConstructorArguments(), entradaIntegracao.getNumeroTransacao(), entradaIntegracao.getValorTransacao(), entradaIntegracao.getNumeroCupom(), OperationEnum.OP_DEBITO_GENERICO.getDescription(), 0);
            processDebito.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), processDebito);
            dados.setErro(processDebito.getErro());
            Contexto.getContexto().getEntradaIntegracao().setOperacao(operacaoAtual);
            state = processDebito.getState();
        } else if (itemMenu.equals("PAGAMENTO QR CODE")) {
            int currentOp = Contexto.getContexto().getEntradaIntegracao().getOperacao();
            Contexto.getContexto().getEntradaIntegracao().setOperacao(OperationEnum.OP_QR_CODE_GENERICO.getKey());
            ProcessQrCodeGenerico reroute = new ProcessQrCodeGenerico(dados.getProcessConstructorArguments(), entradaIntegracao);
            reroute.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), reroute);
            dados.setErro(reroute.getErro());
            Contexto.getContexto().getEntradaIntegracao().setOperacao(currentOp);
            state = reroute.getState();
        } else if (itemMenu.equals(OP_MENU_PRE_AUTORIZACAO)) {
            int operacaoAtual = Contexto.getContexto().getEntradaIntegracao().getOperacao();
            Contexto.getContexto().getEntradaIntegracao().setOperacao(OperationEnum.OP_PRE_AUT_CRED_GENERICO.getKey());
            ProcessPreAutorizacao processPreAutorizacao = new ProcessPreAutorizacao(dados.getProcessConstructorArguments(), entradaIntegracao);
            processPreAutorizacao.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), processPreAutorizacao);
            dados.setErro(processPreAutorizacao.getErro());
            Contexto.getContexto().getEntradaIntegracao().setOperacao(operacaoAtual);
            state = processPreAutorizacao.getState();
        } else if (itemMenu.equals(OP_MENU_RESGATE_FACIL)) {
            Contexto.getContexto().setTipoOperacao(OperationEnum.OP_RESGATE_FACIL.getDescription());
            int operacaoAtual = Contexto.getContexto().getEntradaIntegracao().getOperacao();
            Contexto.getContexto().getEntradaIntegracao().setOperacao(OperationEnum.OP_RESGATE_FACIL.getKey());
            ProcessResgateFacil processResgateFacil = new ProcessResgateFacil(dados.getProcessConstructorArguments(), entradaIntegracao.getNumeroTransacao());
            processResgateFacil.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), processResgateFacil);
            dados.setErro(processResgateFacil.getErro());
            Contexto.getContexto().getEntradaIntegracao().setOperacao(operacaoAtual);
            state = processResgateFacil.getState();
        } else if (itemMenu.equals(OP_MENU_RESGATE_FIDELIDADE_MILHAS)) {
            int operacaoAtual = Contexto.getContexto().getEntradaIntegracao().getOperacao();
            Contexto.getContexto().getEntradaIntegracao().setOperacao(OperationEnum.OP_PRECIFICACAO_FIDELIDADE_EM_MILHAS.getKey());
            ProcessFidelidadeMilhas processFidelidadeMilhas = new ProcessFidelidadeMilhas(dados.getProcessConstructorArguments(), entradaIntegracao, OperationEnum.OP_PRECIFICACAO_FIDELIDADE_EM_MILHAS.getDescription());
            processFidelidadeMilhas.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), processFidelidadeMilhas);
            dados.setErro(processFidelidadeMilhas.getErro());
            Contexto.getContexto().getEntradaIntegracao().setOperacao(operacaoAtual);
            state = processFidelidadeMilhas.getState();
        } else if (itemMenu.equals("PAGAMENTO PIX")) {
            int currentOp = Contexto.getContexto().getEntradaIntegracao().getOperacao();
            Contexto.getContexto().getEntradaIntegracao().setOperacao(OperationEnum.OP_PIX_PAYMENT.getKey());
            ProcessPixPayment reroute = new ProcessPixPayment(dados.getProcessConstructorArguments());
            reroute.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), reroute);
            dados.setErro(reroute.getErro());
            Contexto.getContexto().getEntradaIntegracao().setOperacao(currentOp);
            state = reroute.getState();
        }
        if (state == 1) {
            return ERROR;
        }
        if (state == 0) {
            return SUCCESS;
        }
        if (state == 3) {
            return USER_CANCEL_INTERNAL;
        }
        if (state == 6) {
            return ERROR_AC;
        }
        return SUCCESS;
    }
}

