/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.fusion.ControladorFusion;

public class MicTestaComunicacaoFusion {
    public static String SUCCESS_PRE_AUTORIZADO = "SUCCESS_PRE_AUTORIZADO";
    public static String SUCCESS_POS_AUTORIZADO = "SUCCESS_POS_AUTORIZADO";
    public static String USER_CANCEL = "USER_CANCEL";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        ControladorPerifericos perifericos = dados.getPerifericos();
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha("VERIFICANDO STATUS CONEXAO"));
        displayModel.addLinha(new Linha("CONCENTRADOR DE BOMBAS..."));
        perifericos.imprimeDisplay(displayModel);
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        if (conf.getIpFusion() == null || conf.getPortaFusion() == 0) {
            Contexto.getContexto().setConvenioCombustivelPosAutorizado(true);
            logger.info("Fusion n\u00e3o configurado");
            return SUCCESS_POS_AUTORIZADO;
        }
        ControladorFusion.setParametrosInicializacao(conf.getIpFusion(), conf.getPortaFusion());
        ControladorFusion fusion = ControladorFusion.getInstancia();
        boolean fusionOk = fusion.eco();
        if (fusionOk) {
            logger.info("Comunica\u00e7\u00e3o com o Fusion OK");
            if (ControladorFusion.isModoContingencia()) {
                logger.info("Comunica\u00e7\u00e3o com o Fusion restabelecida");
                displayModel = new LayoutDisplay();
                displayModel.addLinha(new Linha("COMUNICACAO RESTABELECIDA COM"));
                displayModel.addLinha(new Linha("CONCETRADOR DE BOMBAS"));
                displayModel.addLinha(new Linha(""));
                displayModel.addLinha(new Linha("SAIR DO MODO CONTINGENCIA?"));
                displayModel.addLinha(new Linha("[1] - SIM"));
                displayModel.addLinha(new Linha("[2] - NAO"));
                EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, true, ConstantesApiAc.CAP_QUESTIONAMENTO_CONTINGENCIA_FUSION);
                if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                    logger.info("Tecla VOLTA pressionada");
                    return USER_CANCEL;
                }
                String value = eventoTeclado.getStringLida();
                if (value.equals("1")) {
                    logger.info("Selecionada a op\u00e7\u00e3o para sair do modo de conting\u00eancia e voltar a comunicar normalmente com o Fusion");
                    ControladorFusion.setModoContingencia(false);
                    displayModel = new LayoutDisplay();
                    displayModel.addLinha(new Linha("COMUNICACAO RESTABELECIDA COM"));
                    displayModel.addLinha(new Linha("CONCENTRADOR DE BOMBAS"));
                    displayModel.addLinha(new Linha(""));
                    displayModel.addLinha(new Linha("APLICATIVO SAIU DA CONTINGENCIA"));
                    displayModel.setDelay(1500L);
                    perifericos.imprimeDisplay(displayModel);
                    return SUCCESS_PRE_AUTORIZADO;
                }
                if (value.equals("2")) {
                    logger.info("Op\u00e7\u00e3o N\u00c3O selecionada para sair do modo de conting\u00eancia, mesmo com o Fusion funcional");
                    Contexto.getContexto().setConvenioCombustivelPosAutorizado(true);
                    return SUCCESS_POS_AUTORIZADO;
                }
                throw new IllegalArgumentException("op\u00e7\u00e3o inv\u00e1lida");
            }
            return SUCCESS_PRE_AUTORIZADO;
        }
        logger.info("Falha na comunica\u00e7\u00e3o com o Fusion");
        if (ControladorFusion.isModoContingencia()) {
            Contexto.getContexto().setConvenioCombustivelPosAutorizado(true);
            return SUCCESS_POS_AUTORIZADO;
        }
        displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha("FALHA NA COMUNICACAO COM"));
        displayModel.addLinha(new Linha("CONCENTRADOR DE BOMBAS"));
        displayModel.addLinha(new Linha(""));
        displayModel.addLinha(new Linha("ENTRAR NO MODO CONTINGENCIA?"));
        displayModel.addLinha(new Linha("[1] - SIM"));
        displayModel.addLinha(new Linha("[2] - NAO"));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, true, ConstantesApiAc.CAP_QUESTIONAMENTO_CONTINGENCIA_FUSION);
        if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
            logger.info("Tecla VOLTA pressionada");
            return USER_CANCEL;
        }
        String value = eventoTeclado.getStringLida();
        if (value.equals("1")) {
            logger.info("Op\u00e7\u00e3o SIM selecionada para entrar no modo de conting\u00eancia");
            ControladorFusion.setModoContingencia(true);
            displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha("SEM COMUNICACAO COM"));
            displayModel.addLinha(new Linha("CONCENTRADOR DE BOMBAS"));
            displayModel.addLinha(new Linha(""));
            displayModel.addLinha(new Linha("APLICATIVO ENTROU EM"));
            displayModel.addLinha(new Linha("MODO DE CONTINGENCIA"));
            displayModel.setDelay(1500L);
            perifericos.imprimeDisplay(displayModel);
            Contexto.getContexto().setConvenioCombustivelPosAutorizado(true);
            return SUCCESS_POS_AUTORIZADO;
        }
        if (value.equals("2")) {
            logger.info("Op\u00e7\u00e3o N\u00c3O selecionada para entrar no modo de conting\u00eancia");
            return USER_CANCEL;
        }
        throw new IllegalArgumentException("op\u00e7\u00e3o inv\u00e1lida");
    }
}

