/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.tools.util.StringUtil;

public class MicTransacoesSAAUtil {
    private MicTransacoesSAAUtil() {
    }

    public static String getCodigoTransacao() {
        if (OperationEnum.OP_EMISSAO_VALE_TROCA.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "Y1";
        }
        if (OperationEnum.OP_RESGATE_VALE_TROCA.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "Y2";
        }
        if (OperationEnum.OP_CONSULTA_REIMPRESSAO_VALE_TROCA.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "9B";
        }
        if (OperationEnum.OP_REIMPRESSAO_VALE_TROCA.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "96";
        }
        if (OperationEnum.OP_CONSULTA_GARANTIA_ESTENDIDA.getDescription().equals(Contexto.getContexto().getTipoOperacao()) || OperationEnum.OP_CONSULTA_GARANTIA_ROUBO_FURTO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "7C";
        }
        if (OperationEnum.OP_PAGAMENTO_GARANTIA_EXTENDIDA.getDescription().equals(Contexto.getContexto().getTipoOperacao()) || OperationEnum.OP_PAGAMENTO_GARANTIA_ROUBO_FURTO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "9C";
        }
        if (OperationEnum.OP_CONSULTA_RESGATE_GARANTIA_NAO_MAGNETICA.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "EE";
        }
        if (OperationEnum.OP_COMPRA_RESGATE_GARANTIA_NAO_MAGNETICA.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "F1";
        }
        if (OperationEnum.OP_CONSULTA_ASSOCIADO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "6B";
        }
        if (OperationEnum.OP_COMPRA_ASSOCIADO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "B1";
        }
        if (OperationEnum.OP_CARGA_HABILITACAO_CARTAO_PRESENTE.getDescription().equals(Contexto.getContexto().getTipoOperacao()) || OperationEnum.OP_CARGA_HABILITACAO_CUPONAGEM.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "E8";
        }
        if (OperationEnum.OP_RESGATE_CARTAO_PRESENTE_SAA.getDescription().equals(Contexto.getContexto().getTipoOperacao()) || OperationEnum.OP_RESGATE_CUPONAGEM.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "EA";
        }
        if (OperationEnum.OP_CONSULTA_CARTAO_PRESENTE_SAA.getDescription().equals(Contexto.getContexto().getTipoOperacao()) || OperationEnum.OP_CONSULTA_CUPONAGEM.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return "EC";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }

    public static String formataNumeroCartao(String bit62) {
        String numeroCartao = null;
        if (OperationEnum.OP_EMISSAO_VALE_TROCA.getDescription().equals(Contexto.getContexto().getTipoOperacao()) || OperationEnum.OP_RESGATE_VALE_TROCA.getDescription().equals(Contexto.getContexto().getTipoOperacao()) || OperationEnum.OP_CONSULTA_REIMPRESSAO_VALE_TROCA.getDescription().equals(Contexto.getContexto().getTipoOperacao()) || OperationEnum.OP_REIMPRESSAO_VALE_TROCA.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            numeroCartao = "7850000000000000000";
        } else if (OperationEnum.OP_CONSULTA_GARANTIA_ESTENDIDA.getDescription().equals(Contexto.getContexto().getTipoOperacao()) || OperationEnum.OP_CONSULTA_GARANTIA_ROUBO_FURTO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            numeroCartao = "781";
        } else if (OperationEnum.OP_PAGAMENTO_GARANTIA_EXTENDIDA.getDescription().equals(Contexto.getContexto().getTipoOperacao()) || OperationEnum.OP_CONSULTA_RESGATE_GARANTIA_NAO_MAGNETICA.getDescription().equals(Contexto.getContexto().getTipoOperacao()) || OperationEnum.OP_COMPRA_RESGATE_GARANTIA_NAO_MAGNETICA.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            numeroCartao = "7810000000000000000";
        } else if (OperationEnum.OP_PAGAMENTO_GARANTIA_ROUBO_FURTO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            numeroCartao = "7820000000000000000";
        } else if (OperationEnum.OP_CONSULTA_ASSOCIADO.getDescription().equals(Contexto.getContexto().getTipoOperacao()) || OperationEnum.OP_COMPRA_ASSOCIADO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            String matriculaAssociado = MicTransacoesSAAUtil.getMatriculaAssociado(bit62);
            numeroCartao = "8888" + StringUtil.completaString(matriculaAssociado, 15, '0', 3);
        } else if (OperationEnum.OP_CARGA_HABILITACAO_CARTAO_PRESENTE.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            numeroCartao = "7770000000000000000";
        } else if (OperationEnum.OP_CARGA_HABILITACAO_CUPONAGEM.getDescription().equals(Contexto.getContexto().getTipoOperacao()) || OperationEnum.OP_CONSULTA_CUPONAGEM.getDescription().equals(Contexto.getContexto().getTipoOperacao()) || OperationEnum.OP_RESGATE_CUPONAGEM.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            String cpf = MicTransacoesSAAUtil.getCpf(bit62);
            numeroCartao = "774" + StringUtil.completaString(cpf, 14, '0', 3);
        }
        return numeroCartao;
    }

    private static String getMatriculaAssociado(String bit62) {
        int posicaoMatricula = MicTransacoesSAAUtil.calculaPosicaoMatricula();
        if (bit62 != null && bit62.length() >= posicaoMatricula + 10) {
            return bit62.substring(posicaoMatricula, posicaoMatricula + 10);
        }
        return "";
    }

    private static int calculaPosicaoMatricula() {
        if (OperationEnum.OP_CONSULTA_ASSOCIADO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return 37;
        }
        if (OperationEnum.OP_COMPRA_ASSOCIADO.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return 82;
        }
        return 0;
    }

    private static String getCpf(String bit62) {
        int posicaoCpf = MicTransacoesSAAUtil.calculaPosicaoCpf();
        if (bit62 != null && bit62.length() >= posicaoCpf + 11) {
            return bit62.substring(posicaoCpf, posicaoCpf + 11);
        }
        return "";
    }

    private static int calculaPosicaoCpf() {
        if (OperationEnum.OP_CARGA_HABILITACAO_CUPONAGEM.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return 12;
        }
        if (OperationEnum.OP_CONSULTA_CUPONAGEM.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return 8;
        }
        if (OperationEnum.OP_RESGATE_CUPONAGEM.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return 12;
        }
        return 0;
    }
}

