/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.model.ProdutoSplitPagamento;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.NetworkInterface;

public class MicValidaSplitPagamento {
    public static final String ERROR = "ERROR";
    public static final String SUCCESS = "SUCCESS";
    public static final String UNNECESSARY = "UNNECESSARY";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) {
        EntradaCTFClientCtrl entrada = Contexto.getContexto().getEntradaIntegracao();
        if (entrada.getProdutoSplitPagamentoSellerId() == null || entrada.getProdutoSplitPagamentoOrderId() == null) {
            logger.info("Sem informa\u00e7\u00f5es de split de pagamento.");
            return UNNECESSARY;
        }
        if (this.validateSplitPgto(entrada) && this.validateValorProdutos(entrada)) {
            EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
            entradaApiTefC.setProdutoSplitPagamentoSellerId(entrada.getProdutoSplitPagamentoSellerId());
            entradaApiTefC.setSplitPagamentoOrderId(entrada.getProdutoSplitPagamentoOrderId());
            entradaApiTefC.setProdutosSplitPagamento(entrada.getProdutosSplitPagamento());
            if (entrada.getProdutoSplitPagamentoMacAddress() != null) {
                entradaApiTefC.setMacAddress(entrada.getProdutoSplitPagamentoMacAddress());
            } else {
                entradaApiTefC.setMacAddress(this.getMacAddress());
            }
            return SUCCESS;
        }
        return ERROR;
    }

    protected String getMacAddress() {
        try {
            InetAddress ip = InetAddress.getLocalHost();
            logger.info("Current IP address : " + ip.getHostAddress());
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            byte[] mac = network.getHardwareAddress();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                sb.append(String.format("%02X%s", mac[i], ""));
            }
            String macAddress = sb.toString();
            logger.info("Current MAC address : " + macAddress);
            return macAddress;
        }
        catch (Exception e) {
            logger.info("Erro na captura do mac address.");
            return null;
        }
    }

    protected boolean validateValorProdutos(EntradaCTFClientCtrl entrada) {
        BigDecimal valorUnitarioProdutos = BigDecimal.ZERO;
        for (ProdutoSplitPagamento produto : entrada.getProdutosSplitPagamento()) {
            valorUnitarioProdutos = valorUnitarioProdutos.add(produto.getValorUnitario());
        }
        return true;
    }

    protected boolean validateSplitPgto(EntradaCTFClientCtrl entrada) {
        if (entrada.getProdutoSplitPagamentoSellerId() != null && (entrada.getProdutosSplitPagamento() == null || entrada.getProdutosSplitPagamento().isEmpty())) {
            logger.error("Erro na captura de produtos da transa\u00e7\u00e3o. Deve ser informado ao menos 1 ProdutoTransacao.");
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.SPLIT_PGTO_EMPTY_PRODUTOS, InternacionalizacaoUtil.getInstance().getMessage("SPLIT_PGTO_EMPTY_PRODUTOS")));
            return false;
        }
        return true;
    }
}

