/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import br.com.auttar.operation.util.TransactionOperationRules;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.DisplayFisicoCSILanguage;
import com.csi.ctfclient.tools.util.internacionalizacao.Formatter;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicVerificaComunicacaoCTF
extends MicAbstractBase {
    private static final String INTERNAL_ERROR_MESSAGE = "ERRO INTERNO";
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String ERRO_RETURN_AC = "ERRO_RETURN_AC";
    public static final String USER_CANCEL_1F = "USER_CANCEL_1F";
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String derivedExecute(Process dado) throws ExcecaoNaoLocal {
        ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
        ControladorPerifericos periferico = dado.getPerifericos();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        if (saida == null) {
            this.setIntegrationError(CodigoErroIntegracaoEnum.ERRO_20, INTERNAL_ERROR_MESSAGE);
            return ERRO;
        }
        int key = saida.getRetorno();
        String msg = "";
        if (key <= 0) return SUCESS;
        switch (key) {
            case 1: {
                msg = "TENTE DE NOVO-TO";
                break;
            }
            case 2: {
                msg = "TEF NAO INICIALIZADO";
                break;
            }
            case 3: {
                msg = "TRANSACAO EXCEDE LIMITE";
                break;
            }
            case 4: {
                msg = "ERRO NOS PARAMETROS: " + Contexto.getContexto().getSaidaApiTefC().getCodigoErro();
                break;
            }
            case 5: {
                break;
            }
            case 9: {
                msg = "AUTORIZADORA OFF-LINE";
                break;
            }
            case 10: {
                msg = "ERRO DE COMUNICACAO: " + saida.getCodigoErro();
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                msg = "ERRO NO INTERTEF: " + saida.getCodigoErro();
                break;
            }
            case 13: {
                return SUCESS;
            }
        }
        if (!msg.trim().equals("") && (Contexto.getContexto().getEntradaIntegracao() == null || Contexto.getContexto().getEntradaIntegracao() != null && !Contexto.getContexto().getEntradaIntegracao().isMultiTerminal())) {
            periferico.limpaDisplay();
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null) {
            if (msg != null && msg.length() > 0) {
                if (Contexto.getContexto().getEntradaApiTefC() != null && (Contexto.getContexto().getEntradaApiTefC().getOperacao().equals("2N") || Contexto.getContexto().getEntradaApiTefC().getOperacao().equals("1F"))) {
                    if (this.isTransacaoRetornaAC()) {
                        this.montaMsgDisplay(saida, msg);
                        return ERRO_RETURN_AC;
                    }
                    if (this.validaFallBack(Contexto.getContexto().getSaidaApiTefC())) {
                        return ERRO;
                    }
                    this.exibeMensagemDisplay(periferico, msg);
                } else {
                    this.montaMsgDisplay(saida, msg);
                }
            } else if (Contexto.getContexto().getEntradaApiTefC().getOperacao().equals("1F")) {
                String resposta;
                if (this.isTransacaoRetornaAC()) return ERRO_RETURN_AC;
                if (this.validaFallBack(Contexto.getContexto().getSaidaApiTefC())) {
                    return ERRO;
                }
                this.montaMsgDisplay(periferico, saida);
                if (this.exibeMensagemDisplay(periferico, saida.getDisplayCTF()).equals("VOLTA") && ((resposta = saida.getCodigoRespostaAutorizadora()).equals("0F0") || resposta.equals("F0"))) {
                    return USER_CANCEL_1F;
                }
            }
        } else if (Contexto.getContexto().getEntradaApiTefC().getOperacao().equals("1F") || Contexto.getContexto().getEntradaApiTefC().getOperacao().equals("2M")) {
            if (this.validaFallBack(Contexto.getContexto().getSaidaApiTefC())) {
                return ERRO;
            }
            if (msg.trim().equals("")) {
                this.montaMsgDisplay(periferico, saida);
            } else {
                this.exibeMensagemDisplay(periferico, msg);
            }
        } else {
            this.montaMsgDisplay(saida, msg);
        }
        if (TransactionOperationRules.isTypedOperation() || confCTFClient.isIntegracaoWeb() || this.tryGetPin() == null) return ERRO;
        this.montaMsgPinpad(saida);
        return ERRO;
    }

    public void montaMsgPinpad(SaidaApiTefC saida) {
        String[] mensagens = saida.getMensagemDisplayPin().split("#");
        String msgPinPad = "";
        for (int i = 0; i < mensagens.length; ++i) {
            msgPinPad = msgPinPad + StringUtil.completaString(mensagens[i], 16, ' ', false);
        }
        if (msgPinPad.trim().length() > 0) {
            this.exibePinpadComDelay(msgPinPad);
        }
    }

    private void exibePinpadComDelay(String msg) {
        this.tryShowMessagePinpad(msg);
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException e) {
            this.logger.info("Espera do pinpad foi interrompida: " + e.getMessage());
        }
        PinEMV pin = this.tryGetPin();
        if (pin != null) {
            this.tryShowMessagePinpad(pin.getMsgPrompt());
        }
    }

    public void montaMsgDisplay(ControladorPerifericos periferico, SaidaApiTefC saida) throws ExcecaoNaoLocal {
        boolean display = false;
        if (this.exibeGrupoMensagens(periferico, saida.getDisplayCTF())) {
            display = true;
        }
        if (!display && !saida.getCodigoAutorizadora().equals("00") && saida.getCodigoRespostaAutorizadora() != null) {
            this.exibeMensagemDisplay(periferico, "ERRO: " + saida.getCodigoRespostaAutorizadora());
        }
    }

    public void montaMsgDisplay(SaidaApiTefC saida, String msg) {
        if (msg != null && msg.length() > 0) {
            String tam = String.valueOf(msg.length());
            tam = StringUtil.completaString(tam, 4, '0', 3);
            msg = tam + msg;
            saida.setDisplayCTF(msg);
        }
    }

    private boolean exibeGrupoMensagens(ControladorPerifericos periferico, String[] mensagens) throws ExcecaoNaoLocal {
        boolean retorno = false;
        if (mensagens != null && mensagens.length > 0) {
            for (int i = 0; i < mensagens.length; ++i) {
                String[] msgs = this.inter.getLanguage() instanceof DisplayFisicoCSILanguage ? Formatter.formatMsgDisplayFisico(mensagens[i]) : mensagens[i].split("#");
                this.exibeMensagemComDelay(periferico, msgs);
            }
            retorno = true;
        }
        return retorno;
    }

    private void exibeMensagemComDelay(ControladorPerifericos periferico, String[] msg) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.setDelay(1500L);
        for (int i = 0; i < msg.length; ++i) {
            displayModel.addLinha(new Linha(msg[i]));
        }
        periferico.imprimeDisplay(displayModel);
    }

    private String exibeMensagemDisplay(ControladorPerifericos periferico, String msg) throws ExcecaoNaoLocal {
        String[] msgs = this.inter.getLanguage() instanceof DisplayFisicoCSILanguage ? Formatter.formatMsgDisplayFisico(msg) : new String[]{msg};
        return this.exibeMensagemDisplay(periferico, msgs);
    }

    private String exibeMensagemDisplay(ControladorPerifericos periferico, String[] msgs) throws ExcecaoNaoLocal {
        EventoTeclado evt = null;
        LayoutDisplay displayModel = new LayoutDisplay();
        if (msgs.length > 0) {
            for (int x = 0; x < msgs.length; ++x) {
                String[] msgLinha = msgs[x].split("#");
                for (int i = 0; i < msgLinha.length; ++i) {
                    displayModel.addLinha(new Linha(msgLinha[i]));
                }
            }
        }
        evt = (EventoTeclado)periferico.confirmaDado(displayModel);
        return evt.getTeclaFinalizadora();
    }

    public boolean isTransacaoRetornaAC() {
        int operacao = Contexto.getContexto().getEntradaIntegracao().getOperacao();
        if (Contexto.getContexto().getEntradaIntegracao().isMultiTerminal()) {
            return true;
        }
        if (operacao == OperationEnum.OP_CRED_DIGITADO.getKey() || operacao == OperationEnum.OP_CRED_DIGITADO_IATA.getKey() || operacao == OperationEnum.OP_CRED_DIGITADO_IATA_COM_JUROS.getKey() || operacao == OperationEnum.OP_CRED_DIGITADO_IATA_SEM_JUROS.getKey() || operacao == OperationEnum.OP_CRED_DIGITADO_PARC_COM_JUROS.getKey() || operacao == OperationEnum.OP_CRED_DIGITADO_PARC_SEM_JUROS.getKey() || operacao == OperationEnum.OP_CRED_PRIVATE_LABEL_DIGITADO.getKey() || operacao == OperationEnum.OP_AUT_IATA_DIGITADO.getKey() || operacao == OperationEnum.OP_AUT_IATA_DIGITADO_SEM_JUROS.getKey() || operacao == OperationEnum.OP_CONFIRMACAO_PRE_AUT_DIGITADO.getKey() || operacao == OperationEnum.OP_CONFIRMACAO_PRE_AUT_DIGITADO_COM_JUROS.getKey() || operacao == OperationEnum.OP_CONFIRMACAO_PRE_AUT_DIGITADO_SEM_JUROS.getKey() || operacao == OperationEnum.OP_CONSULTA_CREDITO_DIGITADO.getKey() || operacao == OperationEnum.OP_CONSULTA_PRIVATE_LABEL_DIGITADO.getKey() || operacao == OperationEnum.OP_PGTO_CONVENIO.getKey() || operacao == OperationEnum.OP_PGTO_FICHA_COMPENSACAO.getKey()) {
            return true;
        }
        return Contexto.getContexto().getEntradaIntegracao().isNumeroCartaoCtrl();
    }

    public boolean validaFallBack(SaidaApiTefC saida) {
        String operacao;
        return saida != null && saida.getCodigoRespostaAutorizadora() != null && ((operacao = saida.getCodigoRespostaAutorizadora()).equals("F3") || operacao.equals("0F3"));
    }
}

