/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;

public class MicVerificaEstatistica {
    public static final String REQUIRED = "REQUIRED";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) {
        try {
            ControladorInicioDia controladorInicioDia = ControladorInicioDia.getInstance();
            EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
            ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
            boolean multiTerminal = entradaIntegracao != null && entradaIntegracao.isMultiTerminal();
            boolean delivery = entradaIntegracao != null && entradaIntegracao.getCodigoOrigemTransacao() == 1;
            boolean multiEC = config.isMultiEC();
            IdentTerminal identTerminal = null;
            identTerminal = entradaIntegracao != null && (multiTerminal || delivery || multiEC) ? entradaIntegracao.getIdentTerminal() : new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
            DadosInicioDia dadosInicioDia = controladorInicioDia.getDadosInicioDia(identTerminal);
            if (dadosInicioDia.isEstatisticaRedecard()) {
                return REQUIRED;
            }
            return NOT_REQUIRED;
        }
        catch (ExcecaoApiAc e) {
            logger.error("Estat\u00edstica n\u00e3o realizada por erro ao ler o in\u00edcio dia");
            return NOT_REQUIRED;
        }
    }
}

