/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.TabelaCriptografia;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.util.ChavesCriptografiaUtil;
import com.csi.ctfclient.tools.util.CriptografiaUtil;
import com.csi.ctfclient.tools.util.PesquisaChavesException;

public class MicVerificacaoCriptografia3DES
extends MicAbstractBase {
    public static final String SUCCESS_3DES = "SUCCESS_3DES";
    public static final String SUCCESS = "SUCCESS";
    public static final String SUCCESS_CRIPTOGRAFIA_CONTINGENCIA = "SUCCESS_CRIPTOGRAFIA_CONTINGENCIA";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String NO_PINPAD = "NO_PINPAD";
    public static final String ERROR = "ERROR";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        PinEMV pinpad;
        ControladorPerifericos periferico = dados.getPerifericos();
        boolean multiTerminal = false;
        boolean delivery = false;
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaIntegracao != null) {
            multiTerminal = entradaIntegracao.isMultiTerminal();
            delivery = entradaIntegracao.getCodigoOrigemTransacao() == 1;
        } else {
            boolean bl = delivery = entradaApiTefC.getIdentificacaoTransacao() == 1;
        }
        if (multiTerminal || delivery) {
            return NOT_REQUIRED;
        }
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        TabelaCriptografia tabelaCriptografia = null;
        if (saida != null) {
            tabelaCriptografia = ControladorCriptografia.getTabelaCriptografia();
        }
        if ((pinpad = this.tryGetPin()) == null) {
            return NO_PINPAD;
        }
        if (tabelaCriptografia != null) {
            boolean utiliza3DESDados = false;
            boolean utiliza3DESSenha = false;
            if (tabelaCriptografia.getCriptografiaSenhaPrincipal() != null && tabelaCriptografia.getCriptografiaSenhaPrincipal().getAlgoritmo() == 1) {
                utiliza3DESSenha = true;
            }
            if (tabelaCriptografia.getCriptografiaDadosPrincipal() != null && tabelaCriptografia.getCriptografiaDadosPrincipal().getAlgoritmo() == 1) {
                utiliza3DESDados = true;
            }
            if ((utiliza3DESSenha || utiliza3DESDados) && !(pinpad instanceof BibliotecaPinpad)) {
                this.logger.info("Biblioteca compartilhada n\u00e3o utilizada, ignorando o tratamento de suporte da criptografia 3DES");
                return NO_PINPAD;
            }
            boolean tripleDESOk = false;
            if (utiliza3DESDados) {
                try {
                    ChavesCriptografiaUtil.pesquisaChavesK3(this.logger, dados.getPerifericos(), tabelaCriptografia, 2);
                    tripleDESOk = true;
                }
                catch (PesquisaChavesException e) {
                    this.logger.debug("Ocorreu erro durante a pesquisa de chaves de dados, tentando utilizar m\u00e9todo alternativo");
                    try {
                        BibliotecaPinpad pinCompartilhado = (BibliotecaPinpad)pinpad;
                        pinCompartilhado.encryptBuffer(1, tabelaCriptografia.getCriptografiaDadosPrincipal().getIndiceMasterKey(), tabelaCriptografia.getCriptografiaDadosPrincipal().getWorkingKey(), "1234567890123456");
                        tripleDESOk = true;
                    }
                    catch (ExcecaoPerifericos e1) {
                        this.logger.warn("Erro ao tentar 3DES, \u00edndice: " + tabelaCriptografia.getCriptografiaDadosPrincipal().getIndiceMasterKey() + ". Desc: " + e1.getMessage());
                    }
                }
                catch (ExcecaoApiAc excecaoApiAc) {
                    this.logger.error("Nao foi possivel abrir o periferico para pesquisar a chave K3: " + excecaoApiAc.getMessage());
                    return ERROR;
                }
                if (!tripleDESOk) {
                    CriptografiaUtil.utilizaCriptografiaContingenciaDados(tabelaCriptografia, this.logger);
                    return SUCCESS_CRIPTOGRAFIA_CONTINGENCIA;
                }
                this.logger.debug("Criptografia 3DES suportada pelo Pinpad");
            } else {
                this.logger.debug("3DES n\u00e3o utilizado para criptografia de dados");
            }
            if (utiliza3DESSenha) {
                try {
                    ChavesCriptografiaUtil.pesquisaChavesK3(this.logger, dados.getPerifericos(), tabelaCriptografia, 1);
                }
                catch (PesquisaChavesException e) {
                    this.logger.debug("Ocorreu erro durante a pesquisa de chaves de senha, a pesquisa n\u00e3o ser\u00e1 realizada");
                }
                catch (ExcecaoApiAc excecaoApiAc) {
                    this.logger.error("Nao foi possivel abrir o periferico para pesquisar a chave K3 de dados: " + excecaoApiAc.getMessage());
                    return ERROR;
                }
            } else {
                this.logger.debug("3DES n\u00e3o utilizado para criptografia de dados");
            }
            if (tripleDESOk) {
                return SUCCESS_3DES;
            }
            return SUCCESS;
        }
        if (Contexto.getContexto().getSaidaApiTefC() != null) {
            Contexto.getContexto().getSaidaApiTefC().setRetorno(20);
        }
        this.logger.error("Tabela de criptografia n\u00e3o carregada para tentativa de uso de cripto 3DES");
        return ERROR;
    }
}

