/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.TabelaCriptografia;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorBaixaTecnica;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.entrada.ICriptografiaDUKPT;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.GetInfo;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoRedecardEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.util.CriptografiaUtil;
import com.csi.ctfclient.tools.util.StringUtil;

public class MicVerificacaoCriptografiaDUKPT {
    public static final String SUCCESS = "SUCCESS";
    public static final String SUCCESS_DUKPT = "SUCCESS_DUKPT";
    public static final String SUCCESS_INJETAR_CHAVE_DUKPT = "SUCCESS_INJETAR_CHAVE_DUKPT";
    public static final String SUCCESS_CRIPTOGRAFIA_CONTINGENCIA = "SUCCESS_CRIPTOGRAFIA_CONTINGENCIA";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String NO_PINPAD = "NO_PINPAD";
    public static final String ERROR = "ERROR";
    private static final String MSG_OPERATION_NOT_ALLOWED = "OPERACAO NAO PERMITIDA";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(ICriptografiaDUKPT dados) {
        PinEMV pinpad;
        ControladorPerifericos periferico = dados.getPerifericos();
        boolean multiTerminal = false;
        boolean delivery = false;
        if (Contexto.getContexto().getEntradaIntegracao() != null) {
            multiTerminal = Contexto.getContexto().getEntradaIntegracao().isMultiTerminal();
            delivery = Contexto.getContexto().getEntradaIntegracao().getCodigoOrigemTransacao() == 1;
        } else {
            boolean bl = delivery = Contexto.getContexto().getEntradaApiTefC().getIdentificacaoTransacao() == 1;
        }
        if (multiTerminal || delivery) {
            return NOT_REQUIRED;
        }
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        TabelaCriptografia tabelaCriptografia = null;
        if (saida != null) {
            tabelaCriptografia = ControladorCriptografia.getTabelaCriptografia();
        }
        try {
            pinpad = periferico.getPin();
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            logger.warn("Nao foi possivel carregar o pin: " + excecaoPerifericos.getMessage());
            return NO_PINPAD;
        }
        if (tabelaCriptografia != null) {
            if (tabelaCriptografia.getCriptografiaSenhaPrincipal() != null && tabelaCriptografia.getCriptografiaSenhaPrincipal().getAlgoritmo() == 3 || tabelaCriptografia.getCriptografiaDadosPrincipal() != null && tabelaCriptografia.getCriptografiaDadosPrincipal().getAlgoritmo() == 3) {
                if (!(pinpad instanceof BibliotecaPinpad)) {
                    logger.info("Biblioteca compartilhada n\u00e3o utilizada, ignorando utiliza\u00e7\u00e3o da criptografia DUKPT");
                    return NO_PINPAD;
                }
                int indiceMasterKey = tabelaCriptografia.getCriptografiaSenhaPrincipal().getIndiceMasterKey();
                boolean dukptOk = false;
                try {
                    pinpad.getDUKPT(3, indiceMasterKey);
                    dukptOk = true;
                }
                catch (ExcecaoPerifericos e) {
                    logger.warn("Erro ao tentar utilizar DUKPT 3DES, \u00edndice: " + indiceMasterKey + ". Desc: " + e.getMessage());
                }
                if (dukptOk) {
                    logger.info("Criptografia DUKPT suportada pelo Pinpad");
                    if (Contexto.getContexto().getTipoOperacao() != null && Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_INJECAO_MANUAL_CHAVE_DUKPT.getDescription())) {
                        String msg = "INJECAO CHAVES#CHAVE DUKPT JA EXISTENTE";
                        saida.setDisplayCTF(StringUtil.completaString(String.valueOf(msg.length()), 4, '0', 3) + msg);
                    }
                    return SUCCESS_DUKPT;
                }
                if (Contexto.getContexto().getDadosGetInfo() == null) {
                    try {
                        SaidaGetInfoEMV getInfoEMV = pinpad.getInfo();
                        GetInfo dadosGetInfo = new GetInfo();
                        dadosGetInfo.setCodigoRetorno(getInfoEMV.getRetorno());
                        dadosGetInfo.setFabricante(getInfoEMV.getFabricante());
                        dadosGetInfo.setModeloHardware(getInfoEMV.getModeloHardware());
                        dadosGetInfo.setNumeroSerie(getInfoEMV.getNumSeriePinpad());
                        dadosGetInfo.setVersaoEspecificao(getInfoEMV.getVersaoEspecificacao());
                        dadosGetInfo.setVersaoAplicacao(getInfoEMV.getVersaoAplBasica());
                        dadosGetInfo.setVersaoFirmware(getInfoEMV.getVersaoFirmware());
                        if (saida.getCodigoVan() == 0 || saida.getCodigoVan() == 68 || saida.getCodigoVan() == 90 || saida.getCodigoVan() == 37 || saida.getCodigoVanAlfa() != null && saida.getCodigoVanAlfa().equals("AA")) {
                            SaidaGetInfoRedecardEMV infoRedecardEMV = pinpad.getInfoRedecard();
                            dadosGetInfo.setVersaoRedeAdquirente(infoRedecardEMV.getInformacaoProprietaria());
                        }
                        Contexto.getContexto().setDadosGetInfo(dadosGetInfo);
                    }
                    catch (ExcecaoPerifericos e) {
                        logger.warn("Nao foi possivel carregar as informacoes do pin: " + e.getMessage());
                    }
                } else if (Contexto.getContexto().getDadosGetInfo().getVersaoRedeAdquirente() == null && (saida.getCodigoVan() == 0 || saida.getCodigoVan() == 68 || saida.getCodigoVan() == 90 || saida.getCodigoVan() == 37)) {
                    try {
                        SaidaGetInfoRedecardEMV infoRedecardEMV = pinpad.getInfoRedecard();
                        Contexto.getContexto().getDadosGetInfo().setVersaoRedeAdquirente(infoRedecardEMV.getInformacaoProprietaria());
                    }
                    catch (ExcecaoPerifericos excecaoPerifericos) {
                        logger.warn("Nao foi possivel carregar as informacoes da redecard: " + excecaoPerifericos);
                    }
                }
                boolean baixaTecnicaSolicitada = false;
                try {
                    ControladorBaixaTecnica conBaixaTecnica = ControladorBaixaTecnica.getInstance();
                    baixaTecnicaSolicitada = conBaixaTecnica.isBaixaTecnicaSolicitada();
                }
                catch (ExcecaoApiAc e) {
                    baixaTecnicaSolicitada = false;
                    logger.warn("Erro ao recuperar os dados da baixa t\u00e9cnica, a tentativa de uso de chave DUKPT n\u00e3o ser\u00e1 realizada: " + e.getMessage());
                }
                if (Contexto.getContexto().getTipoOperacao() != null && Contexto.getContexto().getTipoOperacao().equals(OperationEnum.OP_INJECAO_MANUAL_CHAVE_DUKPT.getDescription())) {
                    if (CriptografiaUtil.verificaVersaoInjecaoChaves(Contexto.getContexto().getDadosGetInfo().getVersaoRedeAdquirente())) {
                        logger.info("Opera\u00e7\u00e3o de inje\u00e7\u00e3o manual da chaves, a chave ser\u00e1 injetada");
                        return SUCCESS_INJETAR_CHAVE_DUKPT;
                    }
                    logger.error("A opera\u00e7\u00e3o de inje\u00e7\u00e3o manual da chaves n\u00e3o \u00e9 suportada pela vers\u00e3o do Pinpad. Vers\u00e3o da Rede adquirente: " + Contexto.getContexto().getDadosGetInfo().getVersaoRedeAdquirente());
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.OPERACAO_NAO_PERMITIDA, MSG_OPERATION_NOT_ALLOWED));
                    return ERROR;
                }
                if (baixaTecnicaSolicitada || dados.getTentativaInjecao() > 1) {
                    if (Contexto.getContexto().getDadosGetInfo().getVersaoRedeAdquirente() != null && CriptografiaUtil.verificaVersaoInjecaoChaves(Contexto.getContexto().getDadosGetInfo().getVersaoRedeAdquirente())) {
                        logger.info("Chave DUKPT ausente, a chave ser\u00e1 injetada");
                        return SUCCESS_INJETAR_CHAVE_DUKPT;
                    }
                    logger.info("Chave DUKPT ausente. A vers\u00e3o do Pinpad n\u00e3o suporta a inje\u00e7\u00e3o de chaves. Vers\u00e3o da Rede Adquirente: " + Contexto.getContexto().getDadosGetInfo().getVersaoRedeAdquirente());
                } else {
                    logger.info("Chave DUKPT ausente.");
                }
                CriptografiaUtil.utilizaCriptografiaContingenciaDUKPT(tabelaCriptografia, logger);
                return SUCCESS_CRIPTOGRAFIA_CONTINGENCIA;
            }
            logger.debug("DUKPT n\u00e3o utilizado para criptografia de senha ou dados");
            return SUCCESS;
        }
        logger.error("Tabela de criptografia n\u00e3o carregada para tentativa de inje\u00e7\u00e3o de chaves");
        return ERROR;
    }
}

