/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.model.DadosCMOSPinpad;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.util.PersistenciaObjetos;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CMOSPinPad {
    private static final String NAME = "CMOS_PinPad.dat";
    private static final String KEY_DADOS_CMOS = "KEY_DADOS_CMOS";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);
    private static String PATH_APP = null;
    private static CMOSPinPad instance;
    private PersistenciaObjetos persistenciaObjetos;
    private Map<String, DadosCMOSPinpad> dadosCMOS;
    private int qtdErroConexao = 0;

    private CMOSPinPad() throws ExcecaoNaoLocal {
        String path = "";
        path = PATH_APP == null ? "./CMOS_PinPad.dat" : PATH_APP + NAME;
        this.persistenciaObjetos = new PersistenciaObjetos(path);
        try {
            this.dadosCMOS = this.getDadosCMOS();
        }
        catch (Exception e) {
            logger.info("Problema ao recuperar a CMOS do Pinpad, criando uma nova");
        }
        if (this.dadosCMOS == null) {
            logger.info("Problema ao recuperar a CMOS do Pinpad, criando uma nova");
            this.dadosCMOS = new HashMap<String, DadosCMOSPinpad>();
        }
    }

    public static void setPathApp(String path) {
        PATH_APP = path;
    }

    public static CMOSPinPad getInstance() throws ExcecaoNaoLocal {
        if (instance == null) {
            instance = new CMOSPinPad();
        }
        return instance;
    }

    private Map<String, DadosCMOSPinpad> getDadosCMOS() {
        try {
            return (Map)this.persistenciaObjetos.get(KEY_DADOS_CMOS);
        }
        catch (Exception e) {
            logger.error("N\u00e3o foi poss\u00edvel realizar o cast do objeto para um Filter: " + e.getMessage());
            return null;
        }
    }

    private void inicializaDadosRede(String rede) {
        if (!this.dadosCMOS.containsKey(rede)) {
            this.dadosCMOS.put(rede + "", new DadosCMOSPinpad());
        }
    }

    public void solicitarCargaTabelas(int rede) {
        this.inicializaDadosRede(rede + "");
        DadosCMOSPinpad dadosPinpad = this.dadosCMOS.get(rede + "");
        dadosPinpad.setTimestamp(this.gerarTimeStamp(rede + ""));
        try {
            dadosPinpad.setCargaTabelasSolicitada(true);
            dadosPinpad.setCacheCargaTabelas(null);
            this.persistirDados();
        }
        catch (ExcecaoNaoLocal e) {
            logger.error("Erro durante a solicitacao da carga de tabelas: " + e.getMessage());
        }
    }

    public boolean isCargaTabelasSolicitada(int rede) {
        try {
            if (this.dadosCMOS.containsKey(rede + "")) {
                return this.dadosCMOS.get(rede + "").isCargaTabelasSolicitada();
            }
        }
        catch (Exception e) {
            logger.warn("Erro durante a verificacao da carga de tabelas solicitada: " + e.getMessage());
            return false;
        }
        return false;
    }

    private String gerarTimeStamp(String rede) {
        int sequencial = 1;
        this.inicializaDadosRede(rede);
        DadosCMOSPinpad dadosPinpad = this.dadosCMOS.get(rede);
        String timeStamp = dadosPinpad.getTimestamp();
        Date nowDate = new Date();
        Date dateTimeStamp = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyy");
        if (timeStamp != null) {
            try {
                if (timeStamp.substring(0, 8).equals(dateFormat.format(nowDate))) {
                    int tentativas = Integer.parseInt(timeStamp.substring(8));
                    sequencial = tentativas == 99 ? 1 : tentativas + 1;
                    dateTimeStamp = dateFormat.parse(timeStamp.substring(0, 8));
                } else {
                    dateTimeStamp = nowDate;
                    sequencial = 1;
                }
            }
            catch (ParseException e) {
                dateTimeStamp = nowDate;
                sequencial = 1;
            }
        }
        DecimalFormat decimalFormat = new DecimalFormat("00");
        return dateFormat.format(dateTimeStamp) + decimalFormat.format(sequencial);
    }

    public String getTimeStamp(int rede) {
        this.inicializaDadosRede(rede + "");
        DadosCMOSPinpad dadosPinpad = this.dadosCMOS.get(rede + "");
        if (dadosPinpad.getTimestamp() == null || dadosPinpad.isRefazCargaTabelas()) {
            dadosPinpad.setTimestamp(this.gerarTimeStamp(rede + ""));
            if (this.isRefazCargaTabelas(rede)) {
                this.refazerCargaTabelas(rede, false);
            }
            try {
                this.persistirDados();
            }
            catch (ExcecaoNaoLocal e) {
                logger.error("Erro durante a persistencia dos dados do timestamp: " + e.getMessage());
            }
        }
        return dadosPinpad.getTimestamp();
    }

    private void persistirDados() throws ExcecaoNaoLocal {
        this.persistenciaObjetos.save(KEY_DADOS_CMOS, this.dadosCMOS);
        this.persistenciaObjetos.persist(true);
    }

    public void habilitaCargaTabelas(int rede) {
        this.inicializaDadosRede(rede + "");
        DadosCMOSPinpad dadosPinpad = this.dadosCMOS.get(rede + "");
        dadosPinpad.setCargaTabelasSolicitada(false);
        try {
            this.persistirDados();
        }
        catch (ExcecaoNaoLocal e) {
            logger.error("Erro durante a persistencia dos dados da carga: " + e.getMessage());
        }
    }

    public void refazerCargaTabelas(int rede) {
        this.refazerCargaTabelas(rede, true);
    }

    private void refazerCargaTabelas(int rede, boolean value) {
        this.inicializaDadosRede(rede + "");
        DadosCMOSPinpad dadosPinpad = this.dadosCMOS.get(rede + "");
        dadosPinpad.setRefazCargaTabelas(value);
        try {
            this.persistirDados();
        }
        catch (ExcecaoNaoLocal e) {
            logger.error("Erro durante a persistencia dos dados da nova carga de tabelas: " + e.getMessage());
        }
    }

    public boolean isRefazCargaTabelas(int rede) {
        this.inicializaDadosRede(rede + "");
        DadosCMOSPinpad dadosPinpad = this.dadosCMOS.get(rede + "");
        return dadosPinpad.isRefazCargaTabelas();
    }

    public void setCacheCargaTabelas(int rede, Map<String, List<String>> cargaTabelas) {
        this.inicializaDadosRede(rede + "");
        DadosCMOSPinpad dadosPinpad = this.dadosCMOS.get(rede + "");
        dadosPinpad.setCacheCargaTabelas(cargaTabelas);
        try {
            this.persistirDados();
        }
        catch (ExcecaoNaoLocal e) {
            logger.error("Erro durante a persistencia do cache da carga de tabelas: " + e.getMessage());
        }
    }

    public Map<String, List<String>> getCacheCargaTabelas(int rede) {
        this.inicializaDadosRede(rede + "");
        DadosCMOSPinpad dadosPinpad = this.dadosCMOS.get(rede + "");
        return dadosPinpad.getCacheCargaTabelas();
    }

    public int novaTentativaConexao() {
        ++this.qtdErroConexao;
        return this.qtdErroConexao;
    }

    public void limpaTentativaConexoes() {
        this.qtdErroConexao = 0;
    }
}

