/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.servicos.IdentTerminal;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ControladorInicioDia {
    private static ControladorInicioDia controladorInicioDia;
    private static String PATH_APP;
    private static int VERSAO_PATH_TERMINAL;
    private final String PERSISTENCE_FILE = "InicioDia.dat";

    private ControladorInicioDia() {
    }

    public static void setPathApp(String path, int versaoPathTerminal) {
        PATH_APP = path;
        VERSAO_PATH_TERMINAL = versaoPathTerminal;
    }

    public static synchronized ControladorInicioDia getInstance() {
        if (controladorInicioDia == null) {
            controladorInicioDia = new ControladorInicioDia();
        }
        return controladorInicioDia;
    }

    private String formatPathName(IdentTerminal identTerminal) {
        String path = "";
        int idxEmpresa = VERSAO_PATH_TERMINAL == 1 ? 0 : 1;
        path = PATH_APP == null ? "./" + identTerminal.getEstabelecimento().substring(idxEmpresa) + identTerminal.getLoja() + "." + identTerminal.getTerminal() + "/" : PATH_APP + identTerminal.getEstabelecimento().substring(idxEmpresa) + identTerminal.getLoja() + "." + identTerminal.getTerminal() + "/";
        return path;
    }

    private String formatPath(IdentTerminal identTerminal) {
        return this.formatPathName(identTerminal) + File.separator + "InicioDia.dat";
    }

    public synchronized void persistirDadosInicioDia(IdentTerminal identTerminal, Object obj) throws ExcecaoNaoLocal {
        String path = this.formatPath(identTerminal);
        this.createPath(path);
        try {
            ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(path));
            output.writeObject(obj);
            output.close();
        }
        catch (Exception e) {
            throw new ExcecaoNaoLocal(e, "CID01", "Erro ao gravar arquivo de inicio-dia");
        }
    }

    public DadosInicioDia getDadosInicioDia(IdentTerminal identTerminal) throws ExcecaoNaoLocal {
        String name = this.formatPath(identTerminal);
        DadosInicioDia obj = null;
        try {
            FileInputStream fileInput = new FileInputStream(name);
            ObjectInputStream input = new ObjectInputStream(fileInput);
            try {
                obj = (DadosInicioDia)input.readObject();
            }
            catch (ClassNotFoundException e) {
                throw e;
            }
            finally {
                input.close();
                fileInput.close();
            }
        }
        catch (Exception e) {
            throw new ExcecaoNaoLocal(e, "CID04", "Erro ao carregar os dados de inicio-dia");
        }
        return obj;
    }

    public void remove(IdentTerminal key) {
        String name = this.formatPath(key);
        File file = new File(name);
        file.delete();
    }

    private void createPath(String path) {
        File arquivo;
        if (path.lastIndexOf(File.separator) != -1 && !(arquivo = new File(path.substring(0, path.lastIndexOf(File.separator)))).exists()) {
            arquivo.mkdirs();
        }
    }

    static {
        PATH_APP = null;
        VERSAO_PATH_TERMINAL = 0;
    }
}

