/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoEMV;
import com.csi.ctfclient.tools.devices.generic.Ansi98Crypto;
import com.csi.ctfclient.tools.devices.generic.Des;
import com.csi.ctfclient.tools.services.exceptions.ExcecaoLocal;
import java.util.HashMap;
import java.util.Map;

public class ControladorModeloPinPad {
    public static String VERIFONE = "VERIFONE";
    public static String INGENICO = "INGENICO";
    public static String GERTEC = "GERTEC";
    public static String DIONE = "DIONE";
    public static String PAX = "PAX";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);
    private static Map<String, Criptografia> pinpad = null;
    private static ControladorModeloPinPad controladorModeloPinPad = null;

    private ControladorModeloPinPad() throws ExcecaoNaoLocal {
        try {
            pinpad = new HashMap<String, Criptografia>();
            pinpad.put(VERIFONE, this.createCriptografia("109DD7F3A6F44DE4;0"));
            pinpad.put(INGENICO, this.createCriptografia("109DD7F3A6F44DE4;0"));
            pinpad.put(GERTEC, this.createCriptografia("109DD7F3A6F44DE4;0"));
            pinpad.put(DIONE, this.createCriptografia("843A52AC147DD4E2;14"));
            pinpad.put(PAX, this.createCriptografia("109DD7F3A6F44DE4;0"));
        }
        catch (Exception e) {
            logger.error("Erro ao ler arquivo PinPad.properties");
            throw new ExcecaoNaoLocal(e, "CMPP01", "Erro ao ler arquivo PinPad.properties");
        }
    }

    public static ControladorModeloPinPad getInstance() throws ExcecaoNaoLocal {
        if (controladorModeloPinPad == null) {
            controladorModeloPinPad = new ControladorModeloPinPad();
        }
        return controladorModeloPinPad;
    }

    private static String decriptografa(String workingKey) {
        String workingKeyDecriptografada = "";
        byte[] workingKeyBytes = Ansi98Crypto.chaveStrHex2Bin(workingKey);
        byte[] chaveBytes = Ansi98Crypto.chaveStrHex2Bin("9212470633610598");
        workingKeyDecriptografada = Ansi98Crypto.chaveBin2StrHex(Des.decrypt(chaveBytes, workingKeyBytes), 8);
        return workingKeyDecriptografada;
    }

    public Criptografia getCriptografia(PinEMV pinEMV) throws ExcecaoLocal {
        Criptografia value = null;
        String fabricante = "";
        try {
            SaidaGetInfoEMV info = pinEMV.getInfo();
            if (info != null) {
                fabricante = info.getFabricante().toUpperCase();
            }
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            logger.warn("Nao foi possivel ler as informacoes do pinpad: " + excecaoPerifericos.getMessage());
        }
        logger.debug("fabricante pinpad em ppvisa.ini - > " + fabricante);
        if (fabricante.indexOf(DIONE) != -1 || fabricante.indexOf("DIO") != -1) {
            value = pinpad.get(DIONE);
        } else if (fabricante.indexOf(GERTEC) != -1 || fabricante.indexOf("GER") != -1) {
            value = pinpad.get(GERTEC);
        } else if (fabricante.indexOf(VERIFONE) != -1 || fabricante.indexOf("VFN") != -1) {
            value = pinpad.get(VERIFONE);
        } else if (fabricante.indexOf(INGENICO) != -1 || fabricante.indexOf("ING") != -1) {
            value = pinpad.get(INGENICO);
        } else if (fabricante.indexOf(PAX) != -1 || fabricante.indexOf("PAX") != -1) {
            value = pinpad.get(PAX);
        }
        if (value != null) {
            return value;
        }
        logger.error("Fabricante ou modelo de PinPad n\u00e3o compativel com CTFClient");
        throw new ExcecaoLocal("CMPP02", "Erro ao localizar configura\u00e7\u00f5es do fabricante do PinPad", "valor = null");
    }

    private Criptografia createCriptografia(String value) {
        String[] info = value.split(";");
        Criptografia criptografia = new Criptografia(0, Integer.parseInt(info[1]), ControladorModeloPinPad.decriptografa(info[0]), true);
        return criptografia;
    }
}

