/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model;

import com.csi.ctfclient.apitef.Apitef;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.operacoes.model.TerminalSeguro;
import com.csi.ctfclient.operacoes.model.controller.ControladorApitefC;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.emvfull.KeyFactory;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.StringUtil;
import java.util.Date;

public class ControladorTransacaoInicioDia {
    private static final String OPERACAO_INICIO_DIA = "2N";
    private SaidaApiTefC saida;
    private EntradaApiTefC entrada;

    public void executaInicioDia() throws ExcecaoApiAc {
        this.executaInicioDia(null);
    }

    public void executaInicioDia(EntradaCTFClientCtrl entradaIntegracao) throws ExcecaoApiAc {
        EntradaApiTefC entrada = new EntradaApiTefC();
        entrada.setOperacao(OPERACAO_INICIO_DIA);
        IdentTerminal identTerminal = null;
        Date today = null;
        Apitef apiTef = ControladorApitefC.newInstancia();
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        if (entradaIntegracao != null) {
            identTerminal = entradaIntegracao.getIdentTerminal();
            today = entradaIntegracao.getDataAbertura();
        } else {
            identTerminal = new IdentTerminal(conf.getEstabelecimento(), conf.getLoja(), conf.getTerminal());
            today = new Date();
        }
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(identTerminal.getEstabelecimento());
        ident.setNumeroLoja(identTerminal.getLoja());
        ident.setNumeroPdv(identTerminal.getTerminal());
        entrada.setDataCliente(today);
        if (conf.isIntegracaoAndroid() && conf.getTimeOutDefault() > 0) {
            entrada.setTimeoutCtf(conf.getTimeOutDefault());
        } else {
            entrada.setTimeoutCtf(15);
        }
        entrada.setTimestamp(today);
        String cnpj = conf.getCnpj();
        if (cnpj == null) {
            cnpj = "";
        }
        cnpj = StringUtil.completaString(cnpj, 14, ' ', 4);
        entrada.setCnpj(cnpj);
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        SaidaApiTefC saida = apiTef.solicitacao(ident, entrada);
        if (saida.getRetorno() == 0) {
            DadosInicioDia inicioDiaNovo = new DadosInicioDia();
            Date dataAutorizadora = null;
            dataAutorizadora = saida.getDataAutorizadora() != null ? saida.getDataAutorizadora() : new Date();
            inicioDiaNovo.setDataInicioDia(dataAutorizadora);
            inicioDiaNovo.setPermiteCancelamentoSemCartao(saida.isCancelamentoSemCartao());
            inicioDiaNovo.setEstatisticaRedecard(saida.isEstatisticaRedeCard());
            inicioDiaNovo.setTipoBibliotecaPinpad(saida.getTipoBibliotecaPinpad());
            inicioDiaNovo.setCargaTabelaGetCard(saida.getCargaTabelaGetCard());
            inicioDiaNovo.setErrosCargaTabelaGetcard(saida.getErrosCargaTabelaGetCard());
            inicioDiaNovo.setConsultaOperadorasCD(saida.isConsultaOperadosRecarga());
            inicioDiaNovo.setWkAuttarHabilitada(saida.isWkAuttarHabilitado());
            inicioDiaNovo.setHabilitaPreConsutaCartao(saida.isHabilitaPreConsultaCartao());
            inicioDiaNovo.setHabilitaContactless(saida.isHabilitaContactless());
            inicioDiaNovo.setResgateFacil(saida.isResgateFacil());
            inicioDiaNovo.setResgateFidelidadeMilhas(saida.isSmilesHabilitado());
            inicioDiaNovo.setIgnorarAusenciaDadosCodigoBarras(saida.isIgnorarAusenciaDadosCodigoBarras());
            inicioDiaNovo.setParametrosLtmCampanha(saida.getParametrosLtmCampanha());
            inicioDiaNovo.setHabilitaQrCode(saida.isQrCode());
            TerminalSeguro terminalSeguro = null;
            if (saida.getIndiceChaveTerminal() != null && saida.getModuloChaveTerminal() != null && saida.getExpoenteChaveTerminal() != null) {
                terminalSeguro = new TerminalSeguro(saida.getIndiceChaveTerminal(), saida.getModuloChaveTerminal(), saida.getExpoenteChaveTerminal());
                inicioDiaNovo.setTerminalSeguro(terminalSeguro);
            } else {
                inicioDiaNovo.setTerminalSeguro(null);
            }
            if (!conf.isIntegracaoWeb()) {
                ProtocoloBibliotecaCompartilhada.setBcType(saida.getTipoBibliotecaPinpad());
                if (terminalSeguro != null) {
                    KeyFactory.configureKey(terminalSeguro.getIndiceChave(), terminalSeguro.getModuloChave(), terminalSeguro.getExponenteChave());
                } else {
                    KeyFactory.reset();
                }
            }
            ControladorInicioDia controladorInicioDia = ControladorInicioDia.getInstance();
            controladorInicioDia.persistirDadosInicioDia(identTerminal, inicioDiaNovo);
        }
        this.entrada = entrada;
        this.saida = saida;
    }

    public EntradaApiTefC getEntrada() {
        return this.entrada;
    }

    public void setEntrada(EntradaApiTefC entrada) {
        this.entrada = entrada;
    }

    public SaidaApiTefC getSaida() {
        return this.saida;
    }

    public void setSaida(SaidaApiTefC saida) {
        this.saida = saida;
    }
}

