/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericosHandler;
import com.csi.ctfclient.operacoes.model.ControladorEstatistica;
import com.csi.ctfclient.operacoes.model.DadosEstatistica;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoMensagem;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.devices.PerifericoEntradaDadosListener;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.EventoLeitorCartao;

public class PerifericoEventHandler
implements PerifericoEntradaDadosListener {
    public static final int CARTAO_MAGNETICO = 0;
    public static final int CARTAO_EMV = 3;
    public static final int CARTAO_EASY_ENTRY = 4;
    private static boolean active;
    private AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(Periferico.class);
    private ControladorPerifericosHandler perifericosHandler;

    public PerifericoEventHandler(ControladorPerifericosHandler perifericosHandler) {
        this.perifericosHandler = perifericosHandler;
    }

    public static synchronized void setActive(boolean a) {
        active = a;
    }

    @Override
    public void eventoOcorrido(EventoDispositivoEntrada evt) {
        if (evt instanceof EventoMensagem && active) {
            EventoMensagem eventoMensagem = (EventoMensagem)evt;
            try {
                LayoutDisplay displayModel = new LayoutDisplay(eventoMensagem.getMensagem());
                this.perifericosHandler.imprimeDisplay(displayModel);
            }
            catch (Exception displayModel) {}
        } else if (evt instanceof EventoLeitorCartao) {
            EventoLeitorCartao evento = (EventoLeitorCartao)evt;
            try {
                boolean persistirDados = false;
                ControladorEstatistica controladorEstatistica = ControladorEstatistica.getInstance();
                DadosEstatistica dadosEstatistica = controladorEstatistica.getDadosEstatistica();
                if (!evento.getCartaoComErro() && evento.getErroCodigo() == 0) {
                    if (evento.getTipoCartao() == 0) {
                        this.logger.debug("Cartao magnetico");
                        dadosEstatistica.addLeituraMagnetico();
                        persistirDados = true;
                    } else if (evento.getTipoCartao() == 3) {
                        this.logger.debug("Cartao chip EMV");
                        dadosEstatistica.addLeituraSmart();
                        persistirDados = true;
                    } else if (evento.getTipoCartao() == 4) {
                        this.logger.debug("Cartao Easy Entry (Smart)");
                        dadosEstatistica.addLeituraSmart();
                        persistirDados = true;
                    }
                } else {
                    switch (evento.getErroCodigo()) {
                        case 41: {
                            dadosEstatistica.addErroLeituraMagnetico();
                            persistirDados = true;
                            break;
                        }
                        case 60: {
                            break;
                        }
                    }
                }
                if (persistirDados) {
                    controladorEstatistica.persistirDados(dadosEstatistica);
                }
            }
            catch (ExcecaoApiAc e) {
                this.logger.error("Erro ao contabilizar estat\u00edstica em PerifericoEventHandler: " + e.getMessage());
            }
        }
    }
}

