/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model.controller;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.CardApplicationTypeEnum;
import com.csi.ctfclient.apitef.model.Aid;
import com.csi.ctfclient.servicos.CTFClientCore;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ControladorAIDs {
    private static final String TABELA_PARAMETROS_X_AID = "1";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);
    private List<String> redesPPNoApplication;
    private Map<String, List<Aid>> mapListAIDs = new HashMap<String, List<Aid>>();

    public ControladorAIDs(List<String> redesPPNoApplication) {
        this.redesPPNoApplication = redesPPNoApplication;
    }

    public static String getRedeTabela(String tabela) {
        if (tabela != null && tabela.length() > 42 && tabela.substring(3, 4).equals(TABELA_PARAMETROS_X_AID)) {
            return tabela.substring(4, 6);
        }
        return null;
    }

    public void addLinhaCargaTabelas(String linhaCarga, boolean prioritario) {
        if (linhaCarga != null && linhaCarga.length() > 175 && linhaCarga.substring(3, 4).equals(TABELA_PARAMETROS_X_AID)) {
            Aid aid = new Aid();
            aid.setPrioritario(prioritario);
            aid.setRede(linhaCarga.substring(4, 6));
            aid.setIndice(linhaCarga.substring(6, 8));
            aid.setApplicationId(linhaCarga.substring(10, 10 + Integer.parseInt(linhaCarga.substring(8, 10)) * 2));
            aid.setTipoAplicacao(linhaCarga.substring(42, 44));
            aid.setContactless(!linhaCarga.substring(166, 167).equals("0"));
            aid.setLimiteTransacionalContactless(new BigDecimal(0));
            aid.setLimiteTransacionalContactlessMobile(new BigDecimal(0));
            if (aid.isContactless()) {
                String contactlessTransactionLimitMobile;
                String contactlessTransactionLimit = linhaCarga.substring(167, 175);
                if (!contactlessTransactionLimit.contains(" ")) {
                    aid.setLimiteTransacionalContactless(new BigDecimal(Long.parseLong(contactlessTransactionLimit, 16)));
                }
                if (linhaCarga.length() == 340 && !(contactlessTransactionLimitMobile = linhaCarga.substring(331, 339)).contains(" ")) {
                    aid.setLimiteTransacionalContactlessMobile(new BigDecimal(Long.parseLong(contactlessTransactionLimitMobile, 16)));
                }
            }
            if (aid.getTipoAplicacao().equals(CardApplicationTypeEnum.PRIVATE_LABEL.getCode())) {
                logger.debug("Substituindo AID tipo: " + aid.getTipoAplicacao() + " pelo tipo: " + CardApplicationTypeEnum.CREDIT.getCode());
                aid.setTipoAplicacao(CardApplicationTypeEnum.CREDIT.getCode());
            } else if (aid.getTipoAplicacao().equals(CardApplicationTypeEnum.COIN_ACCEPTOR_OR_CDC.getCode()) || aid.getTipoAplicacao().equals(CardApplicationTypeEnum.PURCHASE_AND_WITHDRAWAL.getCode())) {
                logger.debug("Substituindo AID tipo: " + aid.getTipoAplicacao() + " pelo tipo: " + CardApplicationTypeEnum.DEBIT_OR_VOUCHER.getCode());
                aid.setTipoAplicacao(CardApplicationTypeEnum.DEBIT_OR_VOUCHER.getCode());
            }
            List<Aid> listTipoAplicacao = this.mapListAIDs.get(aid.getTipoAplicacao());
            if (listTipoAplicacao == null) {
                listTipoAplicacao = new LinkedList<Aid>();
                this.mapListAIDs.put(aid.getTipoAplicacao(), listTipoAplicacao);
            }
            if (!listTipoAplicacao.contains(aid)) {
                if (!this.redesPPNoApplication.contains(aid.getRede())) {
                    listTipoAplicacao.add(aid);
                    logger.info("AID adicionado: " + aid.getApplicationId() + " do tipo: " + (Object)((Object)CardApplicationTypeEnum.getEnumByCode(aid.getTipoAplicacao())));
                } else {
                    logger.info("AID nao suportado pelo pinpad:   " + aid.getApplicationId());
                }
            } else {
                logger.info("AID ignorado:   " + aid.getApplicationId());
            }
        }
    }

    public Map<String, List<Aid>> getMapAIDs() {
        return this.mapListAIDs;
    }
}

