/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model.controller;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.TabelaCriptografia;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.model.ControladorModeloPinPad;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.operacoes.model.RegistroCriptografia;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.util.StringUtil;

public class ControladorCriptografia {
    private static TabelaCriptografia tabelaCriptografia = null;

    public static TabelaCriptografia getTabelaCriptografia() {
        return tabelaCriptografia;
    }

    public static void setTabelaCriptografia(TabelaCriptografia tabelaCriptografia) {
        ControladorCriptografia.tabelaCriptografia = tabelaCriptografia;
    }

    public static void limparTabelaCriptografia() {
        tabelaCriptografia = null;
    }

    public static TabelaCriptografia getTabelaCriptografia(PinEMV pinEMV, SaidaApiTefC saidaApiTefC) {
        AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);
        String bufferCriptografia = saidaApiTefC.getTabelaCriptografia();
        logger.debug("Tabela de criptografia: " + bufferCriptografia);
        if (bufferCriptografia != null && bufferCriptografia.trim().length() > 0) {
            int TAMANHO_REGISTRO = 67;
            int qtdeRegistros = bufferCriptografia.length() / TAMANHO_REGISTRO;
            tabelaCriptografia = new TabelaCriptografia();
            try {
                block16: for (int i = 0; i < qtdeRegistros; ++i) {
                    int offset = i * TAMANHO_REGISTRO;
                    String bufferItem = bufferCriptografia.substring(offset, offset + TAMANHO_REGISTRO);
                    RegistroCriptografia registroCriptografia = RegistroCriptografia.parse(bufferItem);
                    switch (registroCriptografia.getUsoChave()) {
                        case 0: {
                            switch (registroCriptografia.getTipoChave()) {
                                case 1: {
                                    if (tabelaCriptografia.getCriptografiaSenhaPrincipal() == null) {
                                        tabelaCriptografia.setCriptografiaSenhaPrincipal(registroCriptografia);
                                        continue block16;
                                    }
                                    logger.info("Registro de criptografia Principal para Senha j\u00e1 utilizado, descartando registro");
                                    continue block16;
                                }
                                case 2: {
                                    if (tabelaCriptografia.getCriptografiaDadosPrincipal() == null) {
                                        tabelaCriptografia.setCriptografiaDadosPrincipal(registroCriptografia);
                                        continue block16;
                                    }
                                    logger.info("Registro de criptografia Principal para Dados j\u00e1 utilizado, descartando registro");
                                    continue block16;
                                }
                            }
                            continue block16;
                        }
                        case 1: {
                            switch (registroCriptografia.getTipoChave()) {
                                case 1: {
                                    if (tabelaCriptografia.getCriptografiaSenhaContingencia() == null) {
                                        tabelaCriptografia.setCriptografiaSenhaContingencia(registroCriptografia);
                                        continue block16;
                                    }
                                    logger.info("Registro de criptografia Contig\u00eancia para Senha j\u00e1 utilizado, descartando registro");
                                    continue block16;
                                }
                                case 2: {
                                    if (tabelaCriptografia.getCriptografiaDadosContingencia() == null) {
                                        tabelaCriptografia.setCriptografiaDadosContingencia(registroCriptografia);
                                        continue block16;
                                    }
                                    logger.info("Registro de criptografia Contig\u00eancia para Dados j\u00e1 utilizado, descartando registro");
                                    continue block16;
                                }
                            }
                            continue block16;
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.warn("Erro ao definir a tabela de criptografia: " + e.getMessage());
                return null;
            }
            return tabelaCriptografia;
        }
        logger.debug("M\u00f3dulo n\u00e3o utiliza tabela de criptografia, utilizando forma tradicional");
        RegistroCriptografia registroCriptografia = new RegistroCriptografia();
        int modoCriptografia = saidaApiTefC.getModoCriptografiaSenha();
        String workingKey = StringUtil.completaString(saidaApiTefC.getWorkingkey().trim(), 32, '0', false);
        int indiceCriptografia = saidaApiTefC.getIndiceMasterKey() == '*' ? 0 : ControladorCriptografia.trataIndiceMasterKeyByte(saidaApiTefC.getIndiceMasterKey());
        int indiceWorkingKey = saidaApiTefC.getIndiceWorkingKey();
        if (saidaApiTefC.getIndiceMasterKey() == '0' && saidaApiTefC.getMasterKeyIndex() != null) {
            indiceCriptografia = saidaApiTefC.getMasterKeyIndex().length == 1 ? saidaApiTefC.getMasterKeyIndex()[0] : Integer.parseInt(new String(saidaApiTefC.getMasterKeyIndex()));
        }
        Criptografia criptografia = null;
        if (saidaApiTefC.getIndiceMasterKey() == '*' || saidaApiTefC.getIndiceMasterKey() == '0' && saidaApiTefC.getMasterKeyIndex() != null && saidaApiTefC.getMasterKeyIndex()[0] == '*') {
            try {
                ControladorModeloPinPad controlador = ControladorModeloPinPad.getInstance();
                criptografia = controlador.getCriptografia(pinEMV);
                if (!saidaApiTefC.isChaveAuttarWkAutorizadora()) {
                    workingKey = criptografia.getWorkingKey();
                }
                indiceCriptografia = criptografia.getIndiceMasterKey();
                modoCriptografia = criptografia.getModoCriptografia();
                registroCriptografia.setIndiceAuttar(true);
            }
            catch (ExcecaoApiAc e) {
                logger.error("\u00cdndice da Master key do Auttar, por\u00e9m ocorreu erro na captura do Pinpad: " + e.getMessage());
                return null;
            }
        }
        registroCriptografia.setAlgoritmo(modoCriptografia);
        registroCriptografia.setIndiceMasterKey(indiceCriptografia);
        registroCriptografia.setWorkingKey(workingKey);
        registroCriptografia.setIndiceWorkingKey(indiceWorkingKey);
        TabelaCriptografia tabelaCriptografiaLegado = new TabelaCriptografia();
        tabelaCriptografiaLegado.setCriptografiaSenhaPrincipal(registroCriptografia);
        tabelaCriptografiaLegado.setCriptografiaSenhaContingencia(registroCriptografia);
        if (saidaApiTefC.getMasterKeyIndex() != null) {
            RegistroCriptografia registroCriptografiaEncryptBuffer = (RegistroCriptografia)registroCriptografia.clone();
            if (saidaApiTefC.getMasterKeyIndex().length == 1) {
                registroCriptografiaEncryptBuffer.setIndiceMasterKey(saidaApiTefC.getMasterKeyIndex()[0]);
            } else {
                registroCriptografiaEncryptBuffer.setIndiceMasterKey(Integer.parseInt(new String(saidaApiTefC.getMasterKeyIndex())));
            }
            tabelaCriptografiaLegado.setCriptografiaDadosPrincipal(registroCriptografiaEncryptBuffer);
            tabelaCriptografiaLegado.setCriptografiaDadosContingencia(registroCriptografiaEncryptBuffer);
        } else {
            tabelaCriptografiaLegado.setCriptografiaDadosPrincipal(registroCriptografia);
            tabelaCriptografiaLegado.setCriptografiaDadosContingencia(registroCriptografia);
        }
        tabelaCriptografia = tabelaCriptografiaLegado;
        return tabelaCriptografiaLegado;
    }

    private static int trataIndiceMasterKeyByte(char c) {
        return Integer.parseInt("" + (c - 48));
    }
}

