/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model.controller;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.RandomString;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.model.DadosPersistencia;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import org.apache.commons.io.FileUtils;

public class ControladorPersistencia {
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);
    private static ControladorPersistencia controladorPersistencia;
    private static String PATH_APP;
    private static int VERSAO_PATH_TERMINAL;
    private final String DEFAULT_PERSISTENCE_FILE = "Controles.dat";
    private String qrCodeImagePath;

    public static synchronized ControladorPersistencia getInstance() {
        if (controladorPersistencia == null) {
            controladorPersistencia = new ControladorPersistencia();
        }
        return controladorPersistencia;
    }

    public static void setPathApp(String path, int versaoPathTerminal) {
        PATH_APP = path;
        VERSAO_PATH_TERMINAL = versaoPathTerminal;
    }

    private String formatPathName(IdentTerminal identTerminal) {
        int idxEmpresa = VERSAO_PATH_TERMINAL == 1 ? 0 : 1;
        String path = PATH_APP == null ? "./" + identTerminal.getEstabelecimento().substring(idxEmpresa) + identTerminal.getLoja() + "." + identTerminal.getTerminal() : PATH_APP + identTerminal.getEstabelecimento().substring(idxEmpresa) + identTerminal.getLoja() + "." + identTerminal.getTerminal();
        return path + "/";
    }

    protected String formatPath(IdentTerminal identTerminal) {
        return this.formatPathName(identTerminal) + this.getPersistenceFile();
    }

    protected String getPersistenceFile() {
        return "Controles.dat";
    }

    public synchronized void persistirDados(IdentTerminal identTerminal, DadosPersistencia obj) throws ExcecaoNaoLocal {
        String path = this.formatPath(identTerminal);
        this.createPath(path);
        try {
            ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(path));
            output.writeObject(obj);
            output.close();
        }
        catch (Exception e) {
            throw new ExcecaoNaoLocal(e, "CP07", "Erro ao gravar arquivo");
        }
    }

    public DadosPersistencia getDadosPersistencia(IdentTerminal identTerminal) throws ExcecaoNaoLocal {
        DadosPersistencia obj;
        String name = this.formatPath(identTerminal);
        try {
            ObjectInputStream input;
            FileInputStream fileInput = null;
            try {
                fileInput = new FileInputStream(name);
                input = new ObjectInputStream(fileInput);
            }
            catch (StreamCorruptedException e) {
                logger.warn("O arquivo " + name + " est\u00e1 corrompido e ser\u00e1 deletado");
                fileInput.close();
                File file = new File(name);
                if (file.exists()) {
                    logger.warn(name + " deletado " + file.delete());
                }
                throw new ExcecaoNaoLocal(e, "CP08", "Erro ao ler dados de persistencia");
            }
            try {
                obj = (DadosPersistencia)input.readObject();
            }
            catch (ClassNotFoundException e) {
                input.close();
                fileInput.close();
                throw new ExcecaoNaoLocal(e, "CP09", "Erro ao ler classe de dados de persistencia");
            }
            input.close();
            fileInput.close();
        }
        catch (IOException e) {
            throw new ExcecaoNaoLocal(e, "CP10", "Erro de IO ao ler arquivo de persistencia");
        }
        return obj;
    }

    public void remove(IdentTerminal identTerminal) throws ExcecaoApiAc {
        String name = this.formatPath(identTerminal);
        File file = new File(name);
        if (!file.delete()) {
            logger.warn("N\u00e3o foi poss\u00edvel remover o arquivo de identidade do terminal: " + name);
        }
    }

    private void createPath(String path) {
        File arquivo;
        if (path.lastIndexOf("/") != -1 && !(arquivo = new File(path.substring(0, path.lastIndexOf("/")))).exists() && !arquivo.mkdirs()) {
            logger.warn("N\u00e3o foi poss\u00edvel criar as pastas: " + arquivo.getAbsolutePath());
        }
    }

    public void saveQrCodeImage(IdentTerminal terminalId, byte[] qrCodeImageBuffer) throws ExcecaoApiAc {
        if (!StringUtil.isEmpty(this.qrCodeImagePath)) {
            this.removeQrCodeImage();
        }
        try {
            this.qrCodeImagePath = String.format("%s/%s.png", this.formatPath(terminalId), new RandomString().nextString());
            FileUtils.writeByteArrayToFile((File)new File(this.qrCodeImagePath), (byte[])qrCodeImageBuffer);
        }
        catch (Exception e) {
            throw new ExcecaoApiAc("CP11", "N\u00e3o foi poss\u00edvel salvar a imagem QR Code", e.getMessage());
        }
        logger.debug("Caminho para o QR Code = " + this.qrCodeImagePath);
    }

    public void removeQrCodeImage() throws ExcecaoNaoLocal {
        if (StringUtil.isEmpty(this.qrCodeImagePath)) {
            logger.debug("N\u00e3o h\u00e1 imagem QR Code persistida para remo\u00e7\u00e3o");
            return;
        }
        logger.debug("Removendo imagem QR Code = " + this.qrCodeImagePath);
        File qrCodeImage = new File(this.qrCodeImagePath);
        if (qrCodeImage.exists() && !qrCodeImage.delete()) {
            throw new ExcecaoNaoLocal("CP12", "Nao foi poss\u00edvel remover a imagem QR Code", this.qrCodeImagePath);
        }
    }

    public String getQrCodeImagePath() {
        return this.qrCodeImagePath;
    }

    static {
        PATH_APP = null;
        VERSAO_PATH_TERMINAL = 0;
    }
}

