/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model.controller;

import com.csi.ctfclient.apitef.Apitef;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.Operadora;
import com.csi.ctfclient.apitef.model.OperadoraTelefonia;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.model.DadoPersistencia;
import com.csi.ctfclient.operacoes.model.DadosPersistencia;
import com.csi.ctfclient.operacoes.model.controller.ControladorApitefC;
import com.csi.ctfclient.operacoes.model.controller.ControladorPersistencia;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import java.util.Date;
import java.util.List;

public class ControladorTransacaoPersistencia {
    private static final String OPERACAO_CONSULTA_OPERADORAS = "4S";
    private SaidaApiTefC saida;
    private EntradaApiTefC entrada;

    public void executaConsultaOperadoras(EntradaCTFClientCtrl entradaIntegracao, String tipoOperadora) throws ExcecaoNaoLocal {
        EntradaApiTefC entrada = new EntradaApiTefC();
        entrada.setOperacao(OPERACAO_CONSULTA_OPERADORAS);
        IdentTerminal identTerminal = null;
        Date today = null;
        Apitef apiTef = ControladorApitefC.newInstancia();
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        if (entradaIntegracao != null) {
            identTerminal = entradaIntegracao.getIdentTerminal();
            today = entradaIntegracao.getDataAbertura();
        } else {
            identTerminal = new IdentTerminal(conf.getEstabelecimento(), conf.getLoja(), conf.getTerminal());
            today = new Date();
        }
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(identTerminal.getEstabelecimento());
        ident.setNumeroLoja(identTerminal.getLoja());
        ident.setNumeroPdv(identTerminal.getTerminal());
        entrada.setDataCliente(today);
        entrada.setTimeoutCtf(15);
        entrada.setTimestamp(today);
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        entrada.setTipoAutorizadora(tipoOperadora);
        SaidaApiTefC saida = apiTef.solicitacao(ident, entrada);
        if (saida.getRetorno() == 0) {
            DadosPersistencia persistenciaNova;
            ControladorPersistencia controladorPersistencia = ControladorPersistencia.getInstance();
            try {
                persistenciaNova = controladorPersistencia.getDadosPersistencia(identTerminal);
            }
            catch (ExcecaoApiAc e) {
                persistenciaNova = new DadosPersistencia();
            }
            Date dataAutorizadora = saida.getDataAutorizadora();
            if (dataAutorizadora == null) {
                dataAutorizadora = new Date();
            }
            if ("3".equals(tipoOperadora)) {
                persistenciaNova.setListOperadorasValeGas(new DadoPersistencia<List<Operadora>>(saida.getOperadoras(), dataAutorizadora));
            } else if ("4".equals(tipoOperadora)) {
                persistenciaNova.setListOperadorasTelefonia(new DadoPersistencia<List<Operadora>>(saida.getOperadoras(), dataAutorizadora));
            } else if ("8".equals(tipoOperadora)) {
                persistenciaNova.setListaOperadorasRecarga(new DadoPersistencia<List<OperadoraTelefonia>>(saida.getOperadorasRecarga(), dataAutorizadora));
            } else if ("A".equals(tipoOperadora)) {
                persistenciaNova.setListOperadorasPrepagoDigital(new DadoPersistencia<List<Operadora>>(saida.getOperadoras(), dataAutorizadora));
            }
            controladorPersistencia.persistirDados(identTerminal, persistenciaNova);
        }
        this.entrada = entrada;
        this.saida = saida;
    }

    public SaidaApiTefC getSaida() {
        return this.saida;
    }

    public void setSaida(SaidaApiTefC saida) {
        this.saida = saida;
    }

    public EntradaApiTefC getEntrada() {
        return this.entrada;
    }

    public void setEntrada(EntradaApiTefC entrada) {
        this.entrada = entrada;
    }
}

