/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.util;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.TabelaCriptografia;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.RegistroCriptografia;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.LeitorCartao;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.devices.emvfull.KeyFactory;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.HexaUtil;
import com.csi.ctfclient.tools.util.StringUtil;

public class CriptografiaCartaoEnvio1F {
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public void montaCriptografiaDados(Process dados) throws ExcecaoPerifericos {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        boolean rev3DES = false;
        if (Contexto.getContexto().getCartao() == Cartao.DIGITADO) {
            String panEB = entradaApiTefC.getPAN();
            if (KeyFactory.isChaveLocal()) {
                if (ProtocoloBibliotecaCompartilhada.isSecureCommunication() && entradaApiTefC.getPAN().length() > 12) {
                    logger.debug("Comunica\u00e7\u00e3o segura: utilizando o PAN 3 DES Reverso do cart\u00e3o digitado");
                    rev3DES = true;
                }
            } else if (saidaApiTefC.getPanSeguroCriptDados() != null) {
                panEB = saidaApiTefC.getPanSeguroCriptDados();
                int idx = Integer.parseInt(saidaApiTefC.getPanSeguroCriptDados().substring(0, 2));
                int tam = Integer.parseInt(saidaApiTefC.getPanSeguroCriptDados().substring(2, 4));
                panEB = saidaApiTefC.getTrilha2SeguraCriptDados().substring(--idx + 4, idx + tam + 4);
            }
            String cartaoDigitadoCripto = this.criptografaBuffer(dados, panEB, rev3DES);
            entradaApiTefC.setCartaoCriptografado(cartaoDigitadoCripto);
        } else {
            String trilha1Cripto;
            String cript;
            if (KeyFactory.isChaveLocal()) {
                if (entradaApiTefC.getTrilha1() != null && !entradaApiTefC.getTrilha1().trim().equals("")) {
                    String digitos = entradaApiTefC.getTrilha1().substring(3, 11);
                    String digHexa = HexaUtil.toEBCDICHex(digitos);
                    cript = this.criptografaDadoEncryptBuffer(dados, digHexa, true).substring(0, 16);
                    trilha1Cripto = entradaApiTefC.getTrilha1().substring(0, 3) + cript + entradaApiTefC.getTrilha1().substring(11);
                    entradaApiTefC.setTrilha1Criptografada(trilha1Cripto);
                }
            } else if (saidaApiTefC.getTrilha1SeguraCriptDados() != null) {
                int idx = Integer.parseInt(saidaApiTefC.getTrilha1SeguraCriptDados().substring(0, 2));
                int tam = Integer.parseInt(saidaApiTefC.getTrilha1SeguraCriptDados().substring(2, 4));
                cript = saidaApiTefC.getTrilha1SeguraCriptDados().substring(--idx + 4, idx + tam + 4);
                cript = this.criptografaDadoEncryptBuffer(dados, cript, false);
                trilha1Cripto = saidaApiTefC.getTrilha1SeguraCriptDados().substring(4, idx + 4) + cript + saidaApiTefC.getTrilha1SeguraCriptDados().substring(idx + tam + 4);
                entradaApiTefC.setTrilha1Criptografada(trilha1Cripto);
            }
            if (KeyFactory.isChaveLocal()) {
                if (entradaApiTefC.getInfo() != null && !entradaApiTefC.getInfo().trim().equals("")) {
                    String panTrilha2;
                    String panTrilha2Substituir = panTrilha2 = entradaApiTefC.getPAN();
                    if (panTrilha2.length() < 16) {
                        panTrilha2Substituir = entradaApiTefC.getInfo().substring(0, 16);
                        panTrilha2 = panTrilha2Substituir.replace('=', 'D');
                    } else if (panTrilha2.length() > 16) {
                        panTrilha2Substituir = panTrilha2 = panTrilha2.substring(0, 16);
                    }
                    cript = this.criptografaDadoEncryptBuffer(dados, panTrilha2, true).substring(0, 16);
                    entradaApiTefC.setTrilha2Criptografada(LeitorCartao.atualizaTrilha(entradaApiTefC.getInfo(), panTrilha2Substituir, cript));
                }
            } else if (saidaApiTefC.getTrilha2SeguraCriptDados() != null) {
                int idx = Integer.parseInt(saidaApiTefC.getTrilha2SeguraCriptDados().substring(0, 2));
                int tam = Integer.parseInt(saidaApiTefC.getTrilha2SeguraCriptDados().substring(2, 4));
                cript = saidaApiTefC.getTrilha2SeguraCriptDados().substring(--idx + 4, idx + tam + 4);
                cript = this.criptografaDadoEncryptBuffer(dados, cript, false);
                String trilha2Cripto = saidaApiTefC.getTrilha2SeguraCriptDados().substring(4, idx + 4) + cript + saidaApiTefC.getTrilha2SeguraCriptDados().substring(idx + tam + 4);
                entradaApiTefC.setTrilha2Criptografada(trilha2Cripto);
            }
            String panEB = entradaApiTefC.getPAN();
            if (KeyFactory.isChaveLocal()) {
                if (ProtocoloBibliotecaCompartilhada.isSecureCommunication() && entradaApiTefC.getPAN().length() > 12) {
                    logger.debug("Comunica\u00e7\u00e3o segura: Criptografando o PAN");
                    panEB = entradaApiTefC.getPANCripto();
                }
            } else if (saidaApiTefC.getPanSeguroCriptDados() != null) {
                panEB = saidaApiTefC.getPanSeguroCriptDados();
                int idx = Integer.parseInt(saidaApiTefC.getPanSeguroCriptDados().substring(0, 2));
                int tam = Integer.parseInt(saidaApiTefC.getPanSeguroCriptDados().substring(2, 4));
                panEB = saidaApiTefC.getTrilha2SeguraCriptDados().substring(--idx + 4, idx + tam + 4);
            }
            if (panEB != null) {
                String cartaoDigitadoCripto = this.criptografaBuffer(dados, panEB, false);
                entradaApiTefC.setCartaoCriptografado(cartaoDigitadoCripto);
            }
        }
    }

    private String criptografaBuffer(Process dados, String bufferAberto, boolean rev3DES) throws ExcecaoPerifericos {
        String bufferCriptografado;
        if (bufferAberto.length() < 16) {
            bufferCriptografado = StringUtil.completaString(bufferAberto, 16, 'F', 4);
            bufferCriptografado = this.criptografaDadoEncryptBuffer(dados, bufferCriptografado, rev3DES).substring(0, 16);
        } else {
            bufferCriptografado = this.criptografaDadoEncryptBuffer(dados, bufferAberto.substring(0, 16), rev3DES).substring(0, 16);
            bufferCriptografado = bufferCriptografado + bufferAberto.substring(16);
        }
        return bufferCriptografado;
    }

    private String criptografaDadoEncryptBuffer(Process dados, String value, Boolean rev3DES) throws ExcecaoPerifericos {
        ControladorPerifericos periferico = dados.getPerifericos();
        PinEMV pin = periferico.getPin();
        if (pin instanceof BibliotecaPinpad) {
            BibliotecaPinpad pinCompartilhado = (BibliotecaPinpad)pin;
            TabelaCriptografia tabelaCriptografia = ControladorCriptografia.getTabelaCriptografia();
            RegistroCriptografia registroCriptografia = tabelaCriptografia.getCriptografiaDadosPrincipal();
            int modoCriptografia = registroCriptografia.getAlgoritmo();
            String workingKey = StringUtil.completaString(registroCriptografia.getWorkingKey().trim(), 32, '0', false);
            int indiceCriptografia = registroCriptografia.getIndiceMasterKey() == 42 ? 0 : registroCriptografia.getIndiceMasterKey();
            logger.debug("Criptografia: Indice: " + indiceCriptografia + ", Modo: " + modoCriptografia + ", Working Key: " + workingKey);
            if (modoCriptografia == 0) {
                workingKey = StringUtil.completaString(workingKey, 32, '0', 4);
            }
            if (ProtocoloBibliotecaCompartilhada.isSecureCommunication() && rev3DES.booleanValue()) {
                logger.debug("Comunica\u00e7\u00e3o segura: Aplicando criptografia reversa no buffer para uso na EncryptBuffer");
                try {
                    value = LeitorCartao.descriptografaPAN(value, false);
                }
                catch (Exception e) {
                    logger.error("Erro ao descriptografar PAN: " + e.getMessage());
                }
            }
            return pinCompartilhado.encryptBuffer(modoCriptografia, indiceCriptografia, workingKey, value);
        }
        throw new ExcecaoPerifericos("CCE01", "Erro na criptografia do cart\u00e3o");
    }
}

