/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.communication;

import com.csi.ctfclient.excecoes.ExcecaoParametroInvalido;
import com.csi.ctfclient.tools.communication.Host;
import java.io.Serializable;
import java.util.StringTokenizer;

public class Servico
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Host host;
    private String identifServico;

    private Servico() {
    }

    public Servico(Host host, String identificador) throws ExcecaoParametroInvalido {
        this.setHost(host);
        this.setIdentificadorServico(identificador);
    }

    public Servico(String servico) throws ExcecaoParametroInvalido {
        StringTokenizer token = new StringTokenizer(servico, ":");
        if (token.countTokens() != 2) {
            throw new ExcecaoParametroInvalido("COM013");
        }
        this.setHost(new Host(token.nextToken()));
        this.setIdentificadorServico(token.nextToken());
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) throws ExcecaoParametroInvalido {
        if (host == null) {
            throw new ExcecaoParametroInvalido("COM007");
        }
        this.host = host;
    }

    public String getIdentificadorServico() {
        return this.identifServico;
    }

    public void setIdentificadorServico(String identificador) throws ExcecaoParametroInvalido {
        if (identificador == null) {
            throw new ExcecaoParametroInvalido("COM008");
        }
        this.identifServico = identificador.trim();
    }

    public String toString() {
        return this.host.toString() + ":" + this.identifServico;
    }

    public boolean equals(Servico servico) {
        if (servico == null) {
            return false;
        }
        boolean retorno = this.host.equals(servico.getHost());
        return retorno &= this.identifServico.equals(servico.getIdentificadorServico());
    }
}

