/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.communication.access;

import com.csi.ctfclient.excecoes.ExcecaoParametroInvalido;
import com.csi.ctfclient.tools.communication.Servico;
import com.csi.ctfclient.tools.communication.access.Conector;
import com.csi.ctfclient.tools.communication.access.ConectorTCPIP;
import com.csi.ctfclient.tools.communication.access.ExcecaoErroInstanciacaoConector;
import com.csi.ctfclient.tools.communication.access.ExcecaoErroInstanciacaoNetUtil;
import com.csi.ctfclient.tools.communication.access.ExcecaoErroInstanciacaoServidor;
import com.csi.ctfclient.tools.communication.access.NetUtil;
import com.csi.ctfclient.tools.communication.access.NetUtilTCPIP;
import com.csi.ctfclient.tools.communication.access.Servidor;
import com.csi.ctfclient.tools.communication.access.ServidorTCPIP;
import com.csi.ctfclient.tools.communication.access.TipoDeAcesso;
import com.csi.ctfclient.tools.communication.access.TratadorDeConexoesDeEntrada;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public final class GerenciadorDeAcesso {
    public static final String ACESSO_TCPIP = "TCP/IP";
    private static final TipoDeAcesso TIPO_ACESSO_TCPIP = new TipoDeAcesso("TCP/IP", ServidorTCPIP.class, ConectorTCPIP.class, NetUtilTCPIP.class);
    private static final TipoDeAcesso[] TIPOS_DE_ACESSO = new TipoDeAcesso[]{TIPO_ACESSO_TCPIP};

    public static final synchronized Conector getInstanciaConector(String tipoAcesso, Servico remoto) throws ExcecaoParametroInvalido, ExcecaoErroInstanciacaoConector {
        if (tipoAcesso == null) {
            throw new ExcecaoParametroInvalido("COM010");
        }
        if (remoto == null) {
            throw new ExcecaoParametroInvalido("COM009");
        }
        Conector conector = null;
        TipoDeAcesso acesso = GerenciadorDeAcesso.getTipoDeAcesso(tipoAcesso);
        if (acesso == null) {
            throw new ExcecaoParametroInvalido("COM006");
        }
        try {
            Constructor<?> construtor = acesso.getClasseConector().getConstructor(Servico.class);
            conector = (Conector)construtor.newInstance(remoto);
        }
        catch (Exception e) {
            throw new ExcecaoErroInstanciacaoConector(e);
        }
        return conector;
    }

    public static final synchronized Conector getInstanciaConector(String tipoAcesso, Servico local, Servico remoto) throws ExcecaoParametroInvalido, ExcecaoErroInstanciacaoConector {
        if (tipoAcesso == null) {
            throw new ExcecaoParametroInvalido("COM010");
        }
        if (local == null || remoto == null) {
            throw new ExcecaoParametroInvalido("COM009");
        }
        Conector conector = null;
        TipoDeAcesso acesso = GerenciadorDeAcesso.getTipoDeAcesso(tipoAcesso);
        if (acesso == null) {
            throw new ExcecaoParametroInvalido("COM006");
        }
        try {
            Constructor<?> construtor = acesso.getClasseConector().getConstructor(Servico.class, Servico.class);
            conector = (Conector)construtor.newInstance(local, remoto);
        }
        catch (Exception e) {
            throw new ExcecaoErroInstanciacaoConector(e);
        }
        return conector;
    }

    private static final TipoDeAcesso getTipoDeAcesso(String tipoAcesso) {
        if (tipoAcesso == null) {
            return null;
        }
        TipoDeAcesso tipo = null;
        for (int i = 0; i < TIPOS_DE_ACESSO.length; ++i) {
            if (!TIPOS_DE_ACESSO[i].getNome().equals(tipoAcesso)) continue;
            tipo = TIPOS_DE_ACESSO[i];
        }
        return tipo;
    }

    public static final String[] getTiposDeAcesso() {
        String[] lista = new String[TIPOS_DE_ACESSO.length];
        for (int i = 0; i < TIPOS_DE_ACESSO.length; ++i) {
            lista[i] = TIPOS_DE_ACESSO[i].getNome();
        }
        return lista;
    }

    public static final synchronized Servidor getInstanciaServidor(String tipoAcesso, Servico local, TratadorDeConexoesDeEntrada tratadorConexoes, int maxConexoes) throws ExcecaoParametroInvalido, ExcecaoErroInstanciacaoServidor {
        if (tipoAcesso == null) {
            throw new ExcecaoParametroInvalido("COM010");
        }
        if (local == null) {
            throw new ExcecaoParametroInvalido("COM009");
        }
        if (tratadorConexoes == null) {
            throw new ExcecaoParametroInvalido("COM031");
        }
        if (maxConexoes < 1) {
            throw new ExcecaoParametroInvalido("COM037");
        }
        Servidor servidor = null;
        TipoDeAcesso acesso = GerenciadorDeAcesso.getTipoDeAcesso(tipoAcesso);
        if (acesso == null) {
            throw new ExcecaoParametroInvalido("COM006");
        }
        try {
            Constructor<?> construtor = acesso.getClasseServidor().getConstructor(Servico.class, TratadorDeConexoesDeEntrada.class, Integer.TYPE);
            try {
                servidor = (Servidor)construtor.newInstance(local, tratadorConexoes, new Integer(maxConexoes));
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof ExcecaoParametroInvalido) {
                    throw (ExcecaoParametroInvalido)t;
                }
                if (t instanceof ExcecaoErroInstanciacaoServidor) {
                    throw (ExcecaoErroInstanciacaoServidor)t;
                }
                throw new ExcecaoErroInstanciacaoServidor(t);
            }
        }
        catch (Exception e) {
            throw new ExcecaoErroInstanciacaoServidor(e);
        }
        return servidor;
    }

    public static final NetUtil getInstanciaNetUtil(String tipoAcesso) throws ExcecaoParametroInvalido, ExcecaoErroInstanciacaoNetUtil {
        if (tipoAcesso == null) {
            throw new ExcecaoParametroInvalido("COM010");
        }
        NetUtil retorno = null;
        TipoDeAcesso acesso = GerenciadorDeAcesso.getTipoDeAcesso(tipoAcesso);
        if (acesso == null) {
            throw new ExcecaoParametroInvalido("COM006");
        }
        try {
            Constructor<?> construtor = acesso.getClasseNetUtil().getConstructor(new Class[0]);
            retorno = (NetUtil)construtor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ExcecaoErroInstanciacaoNetUtil(e);
        }
        return retorno;
    }
}

