/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.communication.access;

import com.csi.ctfclient.excecoes.ExcecaoParametroInvalido;
import com.csi.ctfclient.tools.communication.Host;
import com.csi.ctfclient.tools.communication.Servico;
import com.csi.ctfclient.tools.communication.access.ConectorTCPIP;
import com.csi.ctfclient.tools.communication.access.ExcecaoConexaoNaoEstabelecida;
import com.csi.ctfclient.tools.communication.access.ExcecaoImpossivelEncontrarHost;
import com.csi.ctfclient.tools.communication.access.NetUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;

class NetUtilTCPIP
extends NetUtil {
    @Override
    public Host getHostUnico(Host host) throws ExcecaoImpossivelEncontrarHost {
        String endereco = host.getEndereco();
        if (endereco.equals("127.0.0.1") || endereco.equalsIgnoreCase("localhost")) {
            try {
                endereco = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                endereco = "127.0.0.1";
            }
        } else {
            try {
                endereco = InetAddress.getByName(endereco).getHostAddress();
            }
            catch (UnknownHostException e) {
                throw new ExcecaoImpossivelEncontrarHost("COM032", endereco, "", e);
            }
        }
        Host retorno = null;
        try {
            retorno = new Host(endereco);
        }
        catch (ExcecaoParametroInvalido excecaoParametroInvalido) {
            // empty catch block
        }
        return retorno;
    }

    @Override
    public Servico getServicoUnico(Servico servico) throws ExcecaoImpossivelEncontrarHost {
        Servico retorno = null;
        try {
            retorno = new Servico(this.getHostUnico(servico.getHost()), servico.getIdentificadorServico());
        }
        catch (ExcecaoParametroInvalido e) {
            throw new ExcecaoImpossivelEncontrarHost("COM032", servico.getHost().getEndereco(), "", e);
        }
        return retorno;
    }

    @Override
    public boolean servicoAtivo(Servico servico) throws ExcecaoParametroInvalido {
        ConectorTCPIP conector = new ConectorTCPIP(servico);
        boolean ativo = true;
        try {
            conector.abreConexao();
        }
        catch (Exception e) {
            ativo = false;
        }
        if (ativo) {
            try {
                conector.fechaConexao();
            }
            catch (ExcecaoConexaoNaoEstabelecida e) {
                ativo = false;
            }
        }
        return ativo;
    }
}

