/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices;

import com.csi.ctfclient.tools.devices.Display;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.Periferico;

public abstract class DisplayFisico
extends Periferico
implements Display {
    protected int numLinhas;
    protected int numColunas;
    protected int linhaAtual;
    protected int colunaAtual;
    private StringBuffer buffer;
    private int tamBuffer = 0;

    @Override
    public int getColunaAtual() {
        return this.colunaAtual;
    }

    @Override
    public int getLinhaAtual() {
        return this.linhaAtual;
    }

    @Override
    public int getNumColunas() {
        return this.numColunas;
    }

    @Override
    public int getNumLinhas() {
        return this.numLinhas;
    }

    @Override
    public String getTexto() throws ExcecaoPerifericos {
        return this.buffer.toString();
    }

    @Override
    public void imprimeBackSpace() throws ExcecaoPerifericos {
        if (this.colunaAtual != 0) {
            this.imprimeEm(this.linhaAtual, this.colunaAtual - 1, " ");
            this.posicionaCursor(this.linhaAtual, this.colunaAtual - 1);
        }
    }

    @Override
    public void limpaEImprime(String texto) throws ExcecaoPerifericos {
        this.limpa();
        this.imprime(texto);
    }

    @Override
    public void limpaEImprimeEm(int linha, int coluna, String texto) throws ExcecaoPerifericos {
        this.limpa();
        this.imprimeEm(linha, coluna, texto);
    }

    protected void limpaTexto() {
        if (this.buffer == null) {
            this.tamBuffer = this.numLinhas * this.numColunas;
            this.buffer = new StringBuffer(this.tamBuffer);
            for (int i = 0; i < this.tamBuffer; ++i) {
                this.buffer.append(' ');
            }
        } else {
            for (int i = 0; i < this.tamBuffer; ++i) {
                this.buffer.setCharAt(i, ' ');
            }
        }
    }

    protected void reposiciona(String texto) {
        int tamTexto = texto.length();
        int inicio = this.linhaAtual * this.numColunas + this.colunaAtual;
        int fim = inicio + tamTexto;
        this.buffer.replace(inicio, fim, texto);
        this.colunaAtual = fim % this.numColunas;
        this.linhaAtual = fim / this.numColunas % this.numLinhas;
    }

    @Override
    public long getTipoPeriferico() {
        return 1024L;
    }
}

