/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.excecoes.ExcecaoValorInvalido;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoGenericoEntradaDados;
import com.csi.ctfclient.tools.devices.EventoLeitorDocumento;
import com.csi.ctfclient.tools.devices.EventoPin;
import com.csi.ctfclient.tools.devices.EventoScanner;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.ILeitorCartaoHandler;
import com.csi.ctfclient.tools.devices.LeitorDocumento;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.devices.PerifericoEntradaDadosListener;
import com.csi.ctfclient.tools.devices.Pin;
import com.csi.ctfclient.tools.devices.Scanner;
import com.csi.ctfclient.tools.devices.Teclado;
import com.csi.ctfclient.tools.devices.constants.TiposPerifericos;
import com.csi.ctfclient.tools.devices.emv.EventoLeitorCartao;
import com.csi.ctfclient.tools.devices.postef.EventoPOSTef;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

public class EntradaDeDados
implements TiposPerifericos,
PerifericoEntradaDadosListener {
    private final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(Periferico.class);
    private Pin pin;
    private boolean pinHabilitado;
    private Teclado teclado;
    private boolean tecladoHabilitado;
    private Scanner scanner;
    private boolean scannerHabilitado;
    private ILeitorCartaoHandler leitorCartao;
    private boolean leitorCartaoHabilitado;
    private FilaEntradaDeDados filaEventos = new FilaEntradaDeDados();
    private ConjuntoListener ouvintesTeclado = new ConjuntoListener();
    private ConjuntoListener ouvintesScanner = new ConjuntoListener();
    private ConjuntoListener ouvintesLeitorCartao = new ConjuntoListener();
    private ConjuntoListener ouvintesPin = new ConjuntoListener();
    private ConjuntoListener ouvintesBalanca = new ConjuntoListener();
    private boolean balancaSincrona;
    private EventoDispositivoEntrada evtLeValor;
    private boolean leitorCartaoSincrono;
    private boolean leitorDocumentoSincrono;
    private ConjuntoListener ouvintesGenerico = new ConjuntoListener();
    private boolean pinSincrono;
    private boolean scannerSincrono;
    private boolean tecladoSincrono;
    private LeitorDocumento leitorDocumento;
    private boolean leitorDocumentoHabilitado;
    private ConjuntoListener ouvintesLeitorDocumento = new ConjuntoListener();
    private ThreadDisparaEventos threadEventos = new ThreadDisparaEventos();

    public EntradaDeDados() {
        this(null, null, null, null);
    }

    public EntradaDeDados(Teclado teclado) {
        this(teclado, null, null, null);
    }

    public EntradaDeDados(Teclado teclado, Scanner scanner, ILeitorCartaoHandler leitor, Pin pin) {
        this.setTeclado(teclado);
        this.setScanner(scanner);
        this.setLeitorCartao(leitor);
        this.setPin(pin);
    }

    public void desabilitaLeitorCartao() {
        this.logger.debug("Desabilitando ouvinte do leitor de cart\u00f5es");
        this.leitorCartaoHabilitado = false;
        this.limpaFilaEventosLeitorCartao();
    }

    public void desabilitaPin() {
        this.logger.debug("Desabilitando ouvinte do pin");
        this.pinHabilitado = false;
        this.limpaFilaEventosPin();
    }

    public void desabilitaScanner() {
        this.logger.debug("Desabilitando ouvinte do scanner de cart\u00f5es");
        this.scannerHabilitado = false;
        this.limpaFilaEventosScanner();
    }

    public void desabilitaTeclado() {
        this.logger.debug("Desabilitando ouvinte do teclado");
        this.tecladoHabilitado = false;
        this.limpaFilaEventosTeclado();
    }

    public synchronized ILeitorCartaoHandler getLeitorCartao() {
        return this.leitorCartao;
    }

    public synchronized void setLeitorCartao(ILeitorCartaoHandler leitorCartao) {
        this.logger.debug(MessageFormat.format("Definindo leitor de cart\u00f5es {0}", leitorCartao));
        if (this.leitorCartao != null) {
            this.leitorCartao.removeListener(this);
        }
        this.leitorCartao = leitorCartao;
        this.leitorCartaoHabilitado = false;
        if (leitorCartao != null) {
            leitorCartao.addListener(this, false);
        }
        this.limpaFilaEventosLeitorCartao();
    }

    public synchronized Pin getPin() {
        return this.pin;
    }

    public synchronized void setPin(Pin pin) {
        this.logger.debug(MessageFormat.format("Definindo pin para {0}", pin));
        if (this.pin != null) {
            this.pin.removeListener(this);
        }
        this.pin = pin;
        this.pinHabilitado = false;
        if (pin != null) {
            pin.addListener(this, false);
        }
        this.limpaFilaEventosPin();
    }

    public synchronized Scanner getScanner() {
        return this.scanner;
    }

    public synchronized void setScanner(Scanner scanner) {
        this.logger.debug(MessageFormat.format("Definindo scanner para {0}", scanner));
        if (this.scanner != null) {
            this.scanner.removeListener(this);
        }
        this.scanner = scanner;
        this.scannerHabilitado = false;
        if (scanner != null) {
            scanner.addListener(this, false);
        }
        this.limpaFilaEventosScanner();
    }

    public synchronized Teclado getTeclado() {
        return this.teclado;
    }

    public synchronized void setTeclado(Teclado teclado) {
        this.logger.debug(MessageFormat.format("Definindo teclado para {0}", teclado));
        if (this.teclado != null) {
            this.teclado.removeListener(this);
        }
        this.teclado = teclado;
        this.tecladoHabilitado = false;
        if (teclado != null) {
            teclado.addListener(this, false);
        }
        this.limpaFilaEventosTeclado();
    }

    public void habilitaLeitorCartao() {
        this.logger.debug("Habilitando ouvinte do leitor de cart\u00f5es");
        this.leitorCartaoHabilitado = true;
        this.limpaFilaEventosLeitorCartao();
    }

    public void habilitaPin() {
        this.logger.debug("Habilitando ouvinte do pin");
        this.pinHabilitado = true;
        this.limpaFilaEventosPin();
    }

    public void habilitaScanner() {
        this.logger.debug("Habilitando ouvinte do scanner");
        this.scannerHabilitado = true;
        this.limpaFilaEventosScanner();
    }

    public void habilitaTeclado() {
        this.logger.debug("Habilitando ouvinte do teclado");
        this.tecladoHabilitado = true;
        this.limpaFilaEventosTeclado();
    }

    public synchronized EventoDispositivoEntrada leValor(long[] perifericos) throws ExcecaoValorInvalido {
        long aux = 0L;
        for (long periferico : perifericos) {
            if (periferico != 1L && periferico != 2L && periferico != 8L && periferico != 32L && periferico != 16L && periferico != 4L) {
                this.logger.warn(MessageFormat.format("Tentativa de ler um valor de um perif\u00e9rico {0} inv\u00e1lido", periferico));
                throw new ExcecaoValorInvalido();
            }
            this.logger.debug(MessageFormat.format("Adicionando o perif\u00e9rico {0} para leitura", periferico));
            aux |= periferico;
        }
        return this.leValor(aux);
    }

    public synchronized EventoDispositivoEntrada leValor(long perifericos) {
        boolean isTeclado = (perifericos & 1L) != 0L;
        boolean isScanner = (perifericos & 2L) != 0L;
        boolean isLeitorCartao = perifericos != 0L;
        boolean isPin = (perifericos & 4L) != 0L;
        boolean isLeitorDocumento = (perifericos & 0x10L) != 0L;
        this.logger.debug(MessageFormat.format("Lendo valor, teclado = {0}, scanner = {1}, leitorCartoes = {2}, pin = {3}, leitorDocumento = {4}", isTeclado, isScanner, isLeitorCartao, isPin, isLeitorCartao));
        EventoDispositivoEntrada evt = this.filaEventos.proximoEvento(isTeclado, isScanner, isLeitorCartao, isPin, isLeitorDocumento, false);
        this.logger.debug(MessageFormat.format("Leu o evento {0} da fila", evt));
        if (evt == null) {
            evt = this.leValorDireto(perifericos, true);
        }
        if (this.tecladoHabilitado) {
            this.logger.debug("Desabilitando edi\u00e7\u00e3o no teclado");
            this.teclado.getParametros().setEmEdicao(false);
        }
        return evt;
    }

    public synchronized void limpaFilaEventosLeitorCartao() {
        this.logger.debug("Limpando filas de eventos do leitor de cart\u00f5es");
        this.filaEventos.limpaEventosLeitorCartao();
        this.notifyAll();
    }

    public synchronized void limpaFilaEventosPin() {
        this.logger.debug("Limpando filas de eventos do pin");
        this.filaEventos.limpaEventosPin();
        this.notifyAll();
    }

    public synchronized void limpaFilaEventosScanner() {
        this.logger.debug("Limpando filas de eventos do scanner");
        this.filaEventos.limpaEventosScanner();
        this.notifyAll();
    }

    public synchronized void limpaFilaEventosTeclado() {
        this.logger.debug("Limpando filas de eventos do teclado");
        this.filaEventos.limpaEventosTeclado();
        this.notifyAll();
    }

    public void desabilitaLeitorDocumento() {
        this.logger.debug("Desabilitando ouvinte do leitor de documentos");
        this.leitorDocumentoHabilitado = false;
        this.limpaFilaEventosLeitorDocumento();
    }

    public void habilitaLeitorDocumento() {
        this.logger.debug("Habilitando ouvinte do leitor de documentos");
        this.leitorDocumentoHabilitado = true;
        this.limpaFilaEventosLeitorDocumento();
    }

    public synchronized void limpaFilaEventosLeitorDocumento() {
        this.logger.debug("Limpando fila de eventos do leitor de documentos");
        this.filaEventos.limpaEventosLeitorDocumento();
        this.notifyAll();
    }

    public synchronized void limpaTodasFilasEventos() {
        this.logger.debug("Limpando todas as filas de eventos");
        this.filaEventos.limpaEventosLeitorCartao();
        this.filaEventos.limpaEventosLeitorDocumento();
        this.filaEventos.limpaEventosPin();
        this.filaEventos.limpaEventosScanner();
        this.filaEventos.limpaEventosTeclado();
        this.notifyAll();
    }

    public void addBalancaListener(PerifericoEntradaDadosListener ouvinte) {
        this.logger.debug(MessageFormat.format("Adicionando ouvinte da balan\u00e7a {0}", ouvinte));
        this.ouvintesBalanca.inclui(ouvinte);
    }

    public void addLeitorCartaoListener(PerifericoEntradaDadosListener ouvinte) {
        this.logger.debug(MessageFormat.format("Adicionando ouvinte do leitor de cart\u00f5es {0}", ouvinte));
        this.ouvintesLeitorCartao.inclui(ouvinte);
    }

    public void addLeitorDocumentoListener(PerifericoEntradaDadosListener ouvinte) {
        this.logger.debug(MessageFormat.format("Adicionando ouvinte do leitor de documentos {0}", ouvinte));
        this.ouvintesLeitorDocumento.inclui(ouvinte);
    }

    public void addPinListener(PerifericoEntradaDadosListener ouvinte) {
        this.logger.debug(MessageFormat.format("Adicionando ouvinte do pin {0}", ouvinte));
        this.ouvintesPin.inclui(ouvinte);
    }

    public void addScannerListener(PerifericoEntradaDadosListener ouvinte) {
        this.logger.debug(MessageFormat.format("Adicionando ouvinte do scanner {0}", ouvinte));
        this.ouvintesScanner.inclui(ouvinte);
    }

    public void addTecladoListener(PerifericoEntradaDadosListener ouvinte) {
        this.logger.debug(MessageFormat.format("Adicionando ouvinte do teclado {0}", ouvinte));
        this.ouvintesTeclado.inclui(ouvinte);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventoOcorrido(EventoDispositivoEntrada evt) {
        this.logger.debug(MessageFormat.format("Ocorrido evento {0}", evt));
        boolean eventConsumed = false;
        int retries = 0;
        while (!eventConsumed && retries <= 3) {
            EntradaDeDados entradaDeDados = this;
            synchronized (entradaDeDados) {
                if (evt instanceof EventoScanner) {
                    if (this.scannerSincrono) {
                        this.logger.debug("Evento s\u00edncrono de scanner, notificando");
                        this.evtLeValor = evt;
                        this.notifyAll();
                        eventConsumed = true;
                    } else if (this.scannerHabilitado && this.ouvintesScanner.tamanho() > 0) {
                        this.logger.debug("Evento ass\u00edncrono de scanner, colocando na fila de eventos");
                        this.filaEventos.inclui(evt);
                        this.threadEventos.prossegue();
                        eventConsumed = true;
                    } else {
                        this.logger.info("Evento ass\u00edncrono de scanner, por\u00e9m sem ouvintes!");
                    }
                } else if (evt instanceof EventoTeclado) {
                    if (this.tecladoSincrono) {
                        this.logger.debug("Evento s\u00edncrono de teclado, notificando");
                        this.evtLeValor = evt;
                        this.notifyAll();
                        eventConsumed = true;
                    } else if (this.tecladoHabilitado && this.ouvintesTeclado.tamanho() > 0) {
                        this.logger.debug("Evento ass\u00edncrono de teclado, colocando na fila de eventos");
                        this.filaEventos.inclui(evt);
                        this.threadEventos.prossegue();
                        eventConsumed = true;
                    } else {
                        this.logger.info("Evento ass\u00edncrono de teclado, por\u00e9m sem ouvintes!");
                    }
                } else if (evt instanceof EventoLeitorCartao) {
                    if (this.leitorCartaoSincrono) {
                        this.logger.debug("Evento s\u00edncrono de leitor de cart\u00f5es, notificando");
                        this.evtLeValor = evt;
                        this.notifyAll();
                        eventConsumed = true;
                    } else if (this.leitorCartaoHabilitado && this.ouvintesLeitorCartao.tamanho() > 0) {
                        this.logger.debug("Evento ass\u00edncrono de leitor de cart\u00f5es, colocando na fila de eventos");
                        this.filaEventos.inclui(evt);
                        this.threadEventos.prossegue();
                        eventConsumed = true;
                    } else {
                        this.logger.info("Evento ass\u00edncrono de leitor de cart\u00f5es, por\u00e9m sem ouvintes!");
                    }
                } else if (evt instanceof EventoPin) {
                    if (this.pinSincrono) {
                        this.logger.debug("Evento s\u00edncrono de pin, notificando");
                        this.evtLeValor = evt;
                        this.notifyAll();
                        eventConsumed = true;
                    } else if (this.pinHabilitado && this.ouvintesPin.tamanho() > 0) {
                        this.logger.debug("Evento ass\u00edncrono de pin, colocando na fila de eventos");
                        this.filaEventos.inclui(evt);
                        this.threadEventos.prossegue();
                        eventConsumed = true;
                    } else {
                        this.logger.info("Evento ass\u00edncrono de pin, por\u00e9m sem ouvintes!");
                    }
                } else if (evt instanceof EventoLeitorDocumento) {
                    if (this.leitorDocumentoSincrono) {
                        this.logger.debug("Evento s\u00edncrono de leitor de documentos, notificando");
                        this.evtLeValor = evt;
                        this.notifyAll();
                        eventConsumed = true;
                    } else if (this.leitorDocumentoHabilitado && this.ouvintesLeitorDocumento.tamanho() > 0) {
                        this.logger.debug("Evento ass\u00edncrono de leitor de documentos, colocando na fila de eventos");
                        this.filaEventos.inclui(evt);
                        this.threadEventos.prossegue();
                        eventConsumed = true;
                    } else {
                        this.logger.info("Evento ass\u00edncrono de leitor de documentos, por\u00e9m sem ouvintes!");
                    }
                } else if (evt instanceof EventoPOSTef) {
                    this.evtLeValor = evt;
                    this.notifyAll();
                    eventConsumed = true;
                }
            }
            if (eventConsumed || ++retries > 3) continue;
            try {
                this.logger.debug("Esperando 100ms para a pr\u00f3xima tentativa de envio do evento");
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                this.logger.warn(MessageFormat.format("Erro {0} ao agendar a pr\u00f3xima retentativa de envio do evento", e));
            }
        }
        if (!eventConsumed) {
            this.logger.warn(MessageFormat.format("O evento {0} n\u00e3o foi consumido!", evt));
        }
    }

    public void removeBalancaListener(PerifericoEntradaDadosListener ouvinte) {
        this.logger.debug(MessageFormat.format("Removendo ouvinte {0} da escuta dos eventos da balan\u00e7a", ouvinte));
        this.ouvintesBalanca.deleta(ouvinte);
    }

    public void removeLeitorCartaoListener(PerifericoEntradaDadosListener ouvinte) {
        this.logger.debug(MessageFormat.format("Removendo ouvinte {0} da escuta dos eventos do leitor de cart\u00f5es", ouvinte));
        this.ouvintesLeitorCartao.deleta(ouvinte);
    }

    public void removeLeitorDocumentoListener(PerifericoEntradaDadosListener ouvinte) {
        this.logger.debug(MessageFormat.format("Removendo ouvinte {0} da escuta dos eventos do leitor de documentos", ouvinte));
        this.ouvintesLeitorDocumento.deleta(ouvinte);
    }

    public void removePinListener(PerifericoEntradaDadosListener ouvinte) {
        this.logger.debug(MessageFormat.format("Removendo ouvinte {0} da escuta dos eventos do pin", ouvinte));
        this.ouvintesPin.deleta(ouvinte);
    }

    public void removeScannerListener(PerifericoEntradaDadosListener ouvinte) {
        this.logger.debug(MessageFormat.format("Removendo ouvinte {0} da escuta dos eventos do scanner", ouvinte));
        this.ouvintesScanner.deleta(ouvinte);
    }

    public void removeTecladoListener(PerifericoEntradaDadosListener ouvinte) {
        this.logger.debug(MessageFormat.format("Removendo ouvinte {0} da escuta dos eventos do teclado", ouvinte));
        this.ouvintesTeclado.deleta(ouvinte);
    }

    public void addEventoGenericoListener(PerifericoEntradaDadosListener ouvinte) {
        this.logger.debug(MessageFormat.format("Adicionando ouvinte gen\u00e9rico {0}", ouvinte));
        this.ouvintesGenerico.inclui(ouvinte);
    }

    public synchronized LeitorDocumento getLeitorDocumento() {
        return this.leitorDocumento;
    }

    public synchronized void setLeitorDocumento(LeitorDocumento leitorDocumento) {
        this.logger.debug(MessageFormat.format("Definindo leitor de documentos {0}", leitorDocumento));
        if (this.leitorDocumento != null) {
            this.leitorDocumento.removeListener(this);
        }
        this.leitorDocumento = leitorDocumento;
        this.leitorDocumentoHabilitado = false;
        if (leitorDocumento != null) {
            leitorDocumento.addListener(this, false);
        }
        this.limpaFilaEventosLeitorDocumento();
    }

    public int getNumEventosLeitorCartao() {
        return this.filaEventos.getNumEventosLeitorCartao();
    }

    public int getNumEventosLeitorDocumento() {
        return this.filaEventos.getNumEventosLeitorDocumento();
    }

    public int getNumEventosPin() {
        return this.filaEventos.getNumEventosPin();
    }

    public int getNumEventosScanner() {
        return this.filaEventos.getNumEventosScanner();
    }

    public int getNumEventosTeclado() {
        return this.filaEventos.getNumEventosTeclado();
    }

    public void insereEventoComoGenerico(EventoDispositivoEntrada ev, String id) {
        this.logger.debug(MessageFormat.format("Adicionando evento {0} como gen\u00e9rico", ev));
        EventoGenericoEntradaDados evt = new EventoGenericoEntradaDados(this, id, ev);
        evt.modificaInstanteCriacao(ev.getInstanteCriacao());
        this.filaEventos.inclui(evt);
        this.threadEventos.prossegue();
    }

    public boolean isListenerBalanca(PerifericoEntradaDadosListener ouvinte) {
        return this.ouvintesBalanca.contem(ouvinte);
    }

    public boolean isListenerLeitorCartao(PerifericoEntradaDadosListener ouvinte) {
        return this.ouvintesLeitorCartao.contem(ouvinte);
    }

    public boolean isListenerLeitorDocumento(PerifericoEntradaDadosListener ouvinte) {
        return this.ouvintesLeitorDocumento.contem(ouvinte);
    }

    public boolean isListenerPin(PerifericoEntradaDadosListener ouvinte) {
        return this.ouvintesPin.contem(ouvinte);
    }

    public boolean isListenerScanner(PerifericoEntradaDadosListener ouvinte) {
        return this.ouvintesScanner.contem(ouvinte);
    }

    public boolean isListenerTeclado(PerifericoEntradaDadosListener ouvinte) {
        return this.ouvintesTeclado.contem(ouvinte);
    }

    public synchronized EventoDispositivoEntrada leValorDireto(long[] perifericos) throws ExcecaoPerifericos, ExcecaoValorInvalido {
        long aux = 0L;
        for (long periferico : perifericos) {
            if (periferico != 1L && periferico != 2L && periferico != 8L && periferico != 32L && periferico != 16L && periferico != 4L) {
                this.logger.warn(MessageFormat.format("Tentativa de ler diretamente um valor de um perif\u00e9rico {0} inv\u00e1lido", periferico));
                throw new ExcecaoValorInvalido();
            }
            this.logger.debug(MessageFormat.format("Adicionando o perif\u00e9rico {0} na leitura", periferico));
            aux |= periferico;
        }
        return this.leValorDireto(aux);
    }

    public synchronized EventoDispositivoEntrada leValorDireto(long[] perifericos, boolean paralisaFila) throws ExcecaoValorInvalido {
        long aux = 0L;
        for (long periferico : perifericos) {
            if (periferico != 1L && periferico != 2L && periferico != 8L && periferico != 32L && periferico != 16L && periferico != 4L) {
                this.logger.warn(MessageFormat.format("Tentativa de ler diretamente um valor de um perif\u00e9rico {0} inv\u00e1lido", periferico));
                throw new ExcecaoValorInvalido();
            }
            this.logger.debug(MessageFormat.format("Adicionando o perif\u00e9rico {0} na leitura", periferico));
            aux |= periferico;
        }
        return this.leValorDireto(aux, paralisaFila);
    }

    public synchronized EventoDispositivoEntrada leValorDireto(long perifericos) {
        return this.leValorDireto(perifericos, true);
    }

    public synchronized EventoDispositivoEntrada leValorDireto(long perifericos, boolean paralisaFila) {
        this.tecladoSincrono = (perifericos & 1L) != 0L;
        this.scannerSincrono = (perifericos & 2L) != 0L;
        this.leitorCartaoSincrono = (perifericos & 0x28L) != 0L;
        this.pinSincrono = (perifericos & 4L) != 0L;
        boolean bl = this.leitorDocumentoSincrono = (perifericos & 0x10L) != 0L;
        if (!(this.tecladoSincrono || this.scannerSincrono || this.leitorCartaoSincrono || this.pinSincrono || this.balancaSincrona || this.leitorDocumentoSincrono)) {
            return null;
        }
        if (paralisaFila) {
            this.threadEventos.pausa();
        }
        EventoDispositivoEntrada retorno = this.evtLeValor;
        this.logger.debug(MessageFormat.format("Lido o evento {0} do cache", retorno));
        while (retorno == null) {
            try {
                this.logger.debug("Esperando novo evento");
                this.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
            retorno = this.evtLeValor;
        }
        this.logger.debug(MessageFormat.format("Retornando o evento {0}", retorno));
        this.evtLeValor = null;
        this.tecladoSincrono = false;
        this.scannerSincrono = false;
        this.leitorCartaoSincrono = false;
        this.pinSincrono = false;
        this.balancaSincrona = false;
        this.leitorDocumentoSincrono = false;
        if (paralisaFila) {
            this.threadEventos.prossegue();
        }
        return retorno;
    }

    public synchronized void limpaFilaEventosGenericos() {
        this.logger.debug("Limpando fila de eventos gen\u00e9ricos");
        this.filaEventos.limpaEventosGenericos();
        this.notifyAll();
    }

    public void removeEventoGenericoListener(PerifericoEntradaDadosListener ouvinte) {
        this.logger.debug(MessageFormat.format("Removendo ouvinte gen\u00e9rico {0}", ouvinte));
        this.ouvintesGenerico.deleta(ouvinte);
    }

    public class FilaEntradaDeDados {
        private SortedSet<EventoDispositivoEntrada> elementos = Collections.synchronizedSortedSet(new TreeSet());

        public synchronized int getNumEventosLeitorCartao() {
            int retorno = 0;
            for (EventoDispositivoEntrada aux : this.elementos) {
                if (!(aux instanceof EventoLeitorCartao)) continue;
                ++retorno;
            }
            return retorno;
        }

        public synchronized int getNumEventosPin() {
            int retorno = 0;
            for (EventoDispositivoEntrada aux : this.elementos) {
                if (!(aux instanceof EventoPin)) continue;
                ++retorno;
            }
            return retorno;
        }

        public synchronized int getNumEventosScanner() {
            int retorno = 0;
            for (EventoDispositivoEntrada aux : this.elementos) {
                if (!(aux instanceof EventoScanner)) continue;
                ++retorno;
            }
            return retorno;
        }

        public synchronized int getNumEventosTeclado() {
            int retorno = 0;
            for (EventoDispositivoEntrada aux : this.elementos) {
                if (!(aux instanceof EventoTeclado)) continue;
                ++retorno;
            }
            return retorno;
        }

        public synchronized void inclui(EventoDispositivoEntrada elemento) {
            this.elementos.add(elemento);
        }

        public synchronized void limpaEventosGenericos() {
            Iterator set = this.elementos.iterator();
            Vector<EventoDispositivoEntrada> v = new Vector<EventoDispositivoEntrada>();
            while (set.hasNext()) {
                EventoDispositivoEntrada evt = (EventoDispositivoEntrada)set.next();
                if (!(evt instanceof EventoGenericoEntradaDados)) continue;
                v.add(evt);
            }
            this.elementos.removeAll(v);
        }

        public synchronized void limpaEventosLeitorCartao() {
            Iterator set = this.elementos.iterator();
            Vector<EventoDispositivoEntrada> v = new Vector<EventoDispositivoEntrada>();
            while (set.hasNext()) {
                EventoDispositivoEntrada evt = (EventoDispositivoEntrada)set.next();
                if (!(evt instanceof EventoLeitorCartao)) continue;
                v.add(evt);
            }
            this.elementos.removeAll(v);
        }

        public synchronized void limpaEventosPin() {
            Iterator set = this.elementos.iterator();
            Vector<EventoDispositivoEntrada> v = new Vector<EventoDispositivoEntrada>();
            while (set.hasNext()) {
                EventoDispositivoEntrada evt = (EventoDispositivoEntrada)set.next();
                if (!(evt instanceof EventoPin)) continue;
                v.add(evt);
            }
            this.elementos.removeAll(v);
        }

        public synchronized void limpaEventosScanner() {
            Iterator set = this.elementos.iterator();
            Vector<EventoDispositivoEntrada> v = new Vector<EventoDispositivoEntrada>();
            while (set.hasNext()) {
                EventoDispositivoEntrada evt = (EventoDispositivoEntrada)set.next();
                if (!(evt instanceof EventoScanner)) continue;
                v.add(evt);
            }
            this.elementos.removeAll(v);
        }

        public synchronized void limpaEventosTeclado() {
            Iterator set = this.elementos.iterator();
            Vector<EventoDispositivoEntrada> v = new Vector<EventoDispositivoEntrada>();
            while (set.hasNext()) {
                EventoDispositivoEntrada evt = (EventoDispositivoEntrada)set.next();
                if (!(evt instanceof EventoTeclado)) continue;
                v.add(evt);
            }
            this.elementos.removeAll(v);
        }

        public synchronized EventoDispositivoEntrada proximoEvento() {
            if (this.vazia()) {
                return null;
            }
            EventoDispositivoEntrada result = this.elementos.first();
            if (result != null) {
                this.removeEvento(result);
            }
            return result;
        }

        public synchronized void removeEvento(EventoDispositivoEntrada ev) {
            try {
                this.elementos.remove(ev);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }

        public int tamanho() {
            return this.elementos.size();
        }

        public boolean vazia() {
            return this.elementos.size() == 0;
        }

        public synchronized int getNumEventosLeitorDocumento() {
            int retorno = 0;
            for (EventoDispositivoEntrada aux : this.elementos) {
                if (!(aux instanceof EventoLeitorDocumento)) continue;
                ++retorno;
            }
            return retorno;
        }

        public synchronized void limpaEventosLeitorDocumento() {
            Iterator set = this.elementos.iterator();
            Vector<EventoDispositivoEntrada> v = new Vector<EventoDispositivoEntrada>();
            while (set.hasNext()) {
                EventoDispositivoEntrada evt = (EventoDispositivoEntrada)set.next();
                if (!(evt instanceof EventoLeitorDocumento)) continue;
                v.add(evt);
            }
            this.elementos.removeAll(v);
        }

        public synchronized EventoDispositivoEntrada proximoEvento(boolean teclado, boolean scanner, boolean leitorCartao, boolean pin, boolean leitorDocumento, boolean generico) {
            EventoDispositivoEntrada result = null;
            Iterator set = this.elementos.iterator();
            while (set.hasNext() && result == null) {
                EventoDispositivoEntrada aux = (EventoDispositivoEntrada)set.next();
                if (teclado && aux instanceof EventoTeclado) {
                    result = aux;
                    break;
                }
                if (scanner && aux instanceof EventoScanner) {
                    result = aux;
                    break;
                }
                if (leitorCartao && aux instanceof EventoLeitorCartao) {
                    result = aux;
                    break;
                }
                if (pin && aux instanceof EventoPin) {
                    result = aux;
                    break;
                }
                if (leitorDocumento && aux instanceof EventoLeitorDocumento) {
                    result = aux;
                    break;
                }
                if (!generico || !(aux instanceof EventoGenericoEntradaDados)) continue;
                result = aux;
                break;
            }
            if (result != null) {
                this.removeEvento(result);
            }
            return result;
        }
    }

    public class ConjuntoListener {
        private Vector<PerifericoEntradaDadosListener> elementos = new Vector();

        public Enumeration<PerifericoEntradaDadosListener> elementos() {
            return this.elementos.elements();
        }

        public boolean contem(Object o) {
            return this.elementos.contains(o);
        }

        public int tamanho() {
            return this.elementos.size();
        }

        public boolean consulta(PerifericoEntradaDadosListener elemento) {
            return this.elementos.contains(elemento);
        }

        public void deleta(PerifericoEntradaDadosListener elemento) {
            this.elementos.removeElement(elemento);
        }

        public void inclui(PerifericoEntradaDadosListener elemento) {
            if (!this.elementos.contains(elemento)) {
                this.elementos.addElement(elemento);
            }
        }
    }

    private class ThreadDisparaEventos
    extends Thread {
        private boolean finalizada = false;
        private boolean pausada = false;

        public ThreadDisparaEventos() {
            this.start();
        }

        public void pausa() {
            this.pausada = true;
        }

        private void distribuiEventoOuvintes(EventoDispositivoEntrada evt) {
            ConjuntoListener c = null;
            if (evt instanceof EventoScanner) {
                c = EntradaDeDados.this.ouvintesScanner;
            } else if (evt instanceof EventoTeclado) {
                c = EntradaDeDados.this.ouvintesTeclado;
            } else if (evt instanceof EventoLeitorCartao) {
                c = EntradaDeDados.this.ouvintesLeitorCartao;
            } else if (evt instanceof EventoPin) {
                c = EntradaDeDados.this.ouvintesPin;
            } else if (evt instanceof EventoLeitorDocumento) {
                c = EntradaDeDados.this.ouvintesLeitorDocumento;
            } else if (evt instanceof EventoGenericoEntradaDados) {
                c = EntradaDeDados.this.ouvintesGenerico;
            }
            if (c != null && c.tamanho() > 0) {
                Enumeration<PerifericoEntradaDadosListener> e = c.elementos();
                while (e.hasMoreElements()) {
                    e.nextElement().eventoOcorrido(evt);
                }
            }
        }

        public synchronized void prossegue() {
            this.pausada = false;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.finalizada) {
                EventoDispositivoEntrada evt;
                do {
                    if ((evt = EntradaDeDados.this.filaEventos.proximoEvento()) == null) continue;
                    this.distribuiEventoOuvintes(evt);
                } while (!this.finalizada && !this.pausada && evt != null);
                if (this.finalizada) continue;
                ThreadDisparaEventos threadDisparaEventos = this;
                synchronized (threadDisparaEventos) {
                    try {
                        this.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.pausada = false;
            }
        }
    }
}

