/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class Periferico {
    protected final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(Periferico.class);
    private boolean habilitado = false;

    public Periferico() {
        try {
            Method m = Runtime.class.getMethod("addShutdownHook", Thread.class);
            Thread t = new Thread(() -> {
                try {
                    this.liberaRecursos();
                }
                catch (ExcecaoPerifericos e) {
                    this.logger.warn("N\u00e3o foi poss\u00edvel liberar recursos do perif\u00e9rico: " + e.getMessage());
                }
            });
            m.invoke((Object)Runtime.getRuntime(), t);
        }
        catch (NoSuchMethodException e) {
            this.logger.warn("Erro de m\u00e9todo ao tentar carregar addShutdownHook: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.warn("Erro de acesso ao tentar carregar addShutdownHook: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            this.logger.warn("Erro de invoca\u00e7\u00e3o ao tentar carregar addShutdownHook: " + e.getMessage());
        }
    }

    public abstract void desabilita() throws ExcecaoPerifericos;

    public boolean getHabilitado() {
        return this.habilitado;
    }

    protected final void setHabilitado(boolean hab) {
        this.habilitado = hab;
    }

    public abstract void habilita() throws ExcecaoPerifericos;

    public abstract void liberaRecursos() throws ExcecaoPerifericos;

    public abstract long getTipoPeriferico();
}

