/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices;

import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.devices.PerifericoEntradaDadosListener;
import java.text.MessageFormat;
import java.util.Vector;

public abstract class PerifericoEntradaDados
extends Periferico {
    FilaEventos filaEventos = new FilaEventos();
    ThreadDisparaEventos threadEventos = new ThreadDisparaEventos();
    boolean emLeituraSincrona = false;
    EventoDispositivoEntrada evtLeValor = null;
    private final Vector<PerifericoEntradaDadosListener> ouvintesBuf = new Vector();
    private final Vector<PerifericoEntradaDadosListener> ouvintesNaoBuf = new Vector();

    public synchronized void addListener(PerifericoEntradaDadosListener ouvinte) {
        this.addListener(ouvinte, true);
    }

    public synchronized void addListener(PerifericoEntradaDadosListener ouvinte, boolean utilizarBuffer) {
        if (utilizarBuffer) {
            this.ouvintesBuf.add(ouvinte);
        } else {
            this.ouvintesNaoBuf.add(ouvinte);
        }
    }

    protected synchronized void eventoOcorrido(EventoDispositivoEntrada evt) {
        this.logger.debug(MessageFormat.format("Ocorrido o evento {0}", evt));
        if (this.emLeituraSincrona) {
            this.logger.debug("Notificando ouvintes para leitura s\u00edncrona");
            this.evtLeValor = evt;
            this.notifyAll();
            return;
        }
        if (this.ouvintesBuf.size() > 0) {
            this.logger.debug("Notificando ouvintes buferizados");
            this.filaEventos.inserirEvento(evt);
            this.threadEventos.prossegue();
        }
        if (this.ouvintesNaoBuf.size() > 0) {
            for (PerifericoEntradaDadosListener listener : this.ouvintesNaoBuf) {
                this.logger.debug(MessageFormat.format("Notificando ouvinte n\u00e3o-buferizado: {0}", listener));
                listener.eventoOcorrido(evt);
            }
        }
    }

    public synchronized EventoDispositivoEntrada leValor() throws ExcecaoPerifericos {
        EventoDispositivoEntrada evt = this.filaEventos.obterProximoEvento();
        if (evt == null) {
            this.logger.debug("Roteando para leitura de valor direto");
            evt = this.leValorDireto(true);
        } else {
            this.logger.debug("Evento fornecido das filas de evento");
        }
        return evt;
    }

    public synchronized void limpaFilaEventos() {
        this.filaEventos.limparEventos();
    }

    @Override
    public synchronized void desabilita() throws ExcecaoPerifericos {
        this.limpaFilaEventos();
    }

    @Override
    public synchronized void liberaRecursos() throws ExcecaoPerifericos {
        this.logger.debug("Encerrando threads de eventos");
        if (this.getHabilitado()) {
            this.desabilita();
        } else {
            this.logger.info(String.format("Periferico %s ja estava desabilitado", this.getClass().getName()));
        }
        this.threadEventos.finaliza();
    }

    public synchronized void removeListener(PerifericoEntradaDadosListener ouvinte) {
        this.logger.debug(MessageFormat.format("Removendo ouvinte {0}", ouvinte));
        this.ouvintesBuf.remove(ouvinte);
        this.ouvintesNaoBuf.remove(ouvinte);
    }

    public synchronized EventoDispositivoEntrada leValorDireto(boolean paralisaFila) throws ExcecaoPerifericos {
        this.logger.debug(MessageFormat.format("Lendo valor diretamente, paralisaFile = {0}", paralisaFila));
        if (!this.getHabilitado()) {
            this.logger.warn("Perif\u00e9rico de eventos n\u00e3o est\u00e1 habilitado");
            throw new ExcecaoPerifericos("PED01", "Periferico de entrada de dados nao esta habilitado");
        }
        this.emLeituraSincrona = true;
        if (paralisaFila) {
            this.threadEventos.pausa();
        }
        EventoDispositivoEntrada retorno = this.evtLeValor;
        while (retorno == null) {
            try {
                this.logger.debug("Esperando uma notifica\u00e7\u00e3o de evento de captura de dado");
                this.wait();
            }
            catch (Exception e) {
                this.logger.info("N\u00e3o foi poss\u00edvel esperar evento de leitura direta: " + e.getMessage());
            }
            this.logger.debug("Notifica\u00e7\u00e3o de evento de captura de dado recebida");
            retorno = this.evtLeValor;
        }
        if (paralisaFila) {
            this.threadEventos.prossegue();
        }
        this.emLeituraSincrona = false;
        this.evtLeValor = null;
        return retorno;
    }

    private class ThreadDisparaEventos
    extends Thread {
        private boolean finalizada = false;
        private boolean pausada = false;

        public ThreadDisparaEventos() {
            this.setName("Periferico");
            this.start();
        }

        public synchronized void finaliza() {
            this.finalizada = true;
            this.notifyAll();
        }

        public void pausa() {
            this.pausada = true;
        }

        public synchronized void prossegue() {
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.finalizada) {
                EventoDispositivoEntrada evt;
                do {
                    if ((evt = PerifericoEntradaDados.this.filaEventos.obterProximoEvento()) == null || PerifericoEntradaDados.this.ouvintesBuf.size() <= 0) continue;
                    for (PerifericoEntradaDadosListener perifericoEntradaDadosListener : PerifericoEntradaDados.this.ouvintesBuf) {
                        perifericoEntradaDadosListener.eventoOcorrido(evt);
                    }
                } while (!this.finalizada && !this.pausada && evt != null);
                if (this.finalizada) continue;
                ThreadDisparaEventos threadDisparaEventos = this;
                synchronized (threadDisparaEventos) {
                    try {
                        this.wait();
                    }
                    catch (Exception e) {
                        PerifericoEntradaDados.this.logger.info("N\u00e3o foi poss\u00edvel esperar a thread finalizar-se: " + e.getMessage());
                    }
                }
                this.pausada = false;
            }
        }
    }

    private class FilaEventos {
        private final Vector<EventoDispositivoEntrada> fila = new Vector();

        private FilaEventos() {
        }

        public void inserirEvento(EventoDispositivoEntrada evt) {
            this.fila.add(evt);
        }

        public void limparEventos() {
            this.fila.clear();
        }

        public EventoDispositivoEntrada obterProximoEvento() {
            if (this.fila.isEmpty()) {
                PerifericoEntradaDados.this.logger.debug("Sem eventos na fila de eventos");
                return null;
            }
            EventoDispositivoEntrada event = this.fila.remove(0);
            PerifericoEntradaDados.this.logger.debug(MessageFormat.format("Obtendo pr\u00f3ximo evento da fila de eventos = {0}", event));
            return event;
        }

        public int tamanho() {
            return this.fila.size();
        }
    }
}

