/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices;

import com.csi.ctfclient.excecoes.ExcecaoMascaraInvalida;
import com.csi.ctfclient.excecoes.ExcecaoMascaraNaoAplicavel;
import com.csi.ctfclient.tools.devices.Display;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.ParametrosEdicaoTeclado;
import com.csi.ctfclient.tools.devices.PerifericoEntradaDados;
import com.csi.ctfclient.tools.devices.config.ConfiguracaoTeclado;
import com.csi.ctfclient.tools.devices.config.ConjuntoTecla;
import com.csi.ctfclient.tools.devices.config.Tecla;
import com.csi.ctfclient.tools.services.exceptions.ExcecaoLocal;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public abstract class Teclado
extends PerifericoEntradaDados {
    private Frame frame;
    private int numCasasDecimais;
    private ParametrosEdicaoTeclado paramsEdicao = null;
    private ParametrosEdicaoTeclado paramsEdicaoRef = null;
    private char[] buffer = null;
    private Tecla[] teclas;
    private ConjuntoTecla finalizadoras = new ConjuntoTecla();
    private int cursor = -1;
    private boolean nasCasasDecimais = false;
    private Tecla auxTecla = new Tecla(0);
    private List<Tecla> auxList = new ArrayList<Tecla>();
    private boolean ignorarTeclasBufferizadas = false;
    private int numTeclaBuff;
    private int[] teclaBufferizada;
    private ConjuntoDisplay displaysEco = new ConjuntoDisplay();

    public Teclado() throws ExcecaoPerifericos {
        try {
            this.teclas = ConfiguracaoTeclado.getTeclas();
        }
        catch (ExcecaoLocal e) {
            throw new ExcecaoPerifericos("TEC01", "Erro na configuracao de teclas", e.getDetalhe());
        }
        this.teclaBufferizada = new int[500];
        this.numTeclaBuff = 0;
        Arrays.sort(this.teclas);
        try {
            this.paramsEdicao = new ParametrosEdicaoTeclado(false, false, true, "", 1, 1, ",", ".", false, "", 0, 0, null, new String[]{"ENTRA"}, true);
        }
        catch (ExcecaoMascaraInvalida excecaoMascaraInvalida) {
            // empty catch block
        }
    }

    public Teclado(ConfiguracaoTeclado configuracaoTeclas, Frame frameAplicacao) throws ExcecaoPerifericos {
        this.teclas = configuracaoTeclas.getArrayTeclas();
        this.teclaBufferizada = new int[500];
        this.numTeclaBuff = 0;
        Arrays.sort(this.teclas);
        try {
            this.paramsEdicao = new ParametrosEdicaoTeclado(false, false, true, "", 1, 1, ",", ".", false, "", 0, 0, null, new String[]{"ENTRA"}, true);
        }
        catch (ExcecaoMascaraInvalida excecaoMascaraInvalida) {
            // empty catch block
        }
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public void adicionaDisplayEco(Display display) {
        this.displaysEco.inclui(display);
    }

    public void carregaConfiguracao(ConfiguracaoTeclado conf) {
        this.teclas = conf.getArrayTeclas();
        Arrays.sort(this.teclas);
    }

    public synchronized void defineParametros(ParametrosEdicaoTeclado params, boolean ignorarTeclasBufferizadas) throws ExcecaoPerifericos {
        this.ignorarTeclasBufferizadas = ignorarTeclasBufferizadas;
        this.defineParametros(params);
        this.ignorarTeclasBufferizadas = false;
    }

    public synchronized void defineParametros(ParametrosEdicaoTeclado params) throws ExcecaoPerifericos {
        int i;
        this.paramsEdicaoRef = params;
        try {
            this.paramsEdicao.setParametros(params.getAceitaZerosEsquerda(), params.getSeparadorDecimalObrigatorio(), params.getModoNumerico(), params.getMascara(), params.getLinhaEdicao(), params.getColunaEdicao(), params.getSeparadorDecimal(), params.getSeparadorMilhares(), params.getAutoSkip(), params.getMensagemPrompt(), params.getLinhaMensagem(), params.getColunaMensagem(), params.getValorDefaultString(), params.getTeclasFinalizadoras(), params.getNumFinalizadoras(), params.getLimparDisplayAoDefinir());
            this.paramsEdicao.ativeSenha(params.getCaractereSenha());
        }
        catch (ExcecaoMascaraInvalida excecaoMascaraInvalida) {
            // empty catch block
        }
        this.finalizadoras.limpa();
        String[] teclasFinalizadoras = this.paramsEdicao.getTeclasFinalizadoras();
        int sz = this.paramsEdicao.getNumFinalizadoras();
        for (i = 0; i < sz; ++i) {
            List<Tecla> aux = this.encontraTecla(teclasFinalizadoras[i]);
            for (int j = 0; j < aux.size(); ++j) {
                this.finalizadoras.inclui(aux.get(j));
            }
        }
        if (this.getModoNumerico()) {
            this.numCasasDecimais = this.paramsEdicao.getNumCasasDecimais();
        }
        this.inicializarComDefault();
        if (this.paramsEdicao.getPossuiCampoEditavel() && !this.ignorarTeclasBufferizadas) {
            for (i = 0; i < this.numTeclaBuff; ++i) {
                this.teclaRecebida(this.teclaBufferizada[i]);
            }
            this.numTeclaBuff = 0;
        }
        try {
            Enumeration<Display> e = this.displaysEco.elementos();
            while (e.hasMoreElements()) {
                Display d = e.nextElement();
                if (this.paramsEdicao.getLimparDisplayAoDefinir()) {
                    d.limpa();
                }
                d.imprimeEm(this.paramsEdicao.getLinhaMensagem(), this.paramsEdicao.getColunaMensagem(), this.paramsEdicao.getMensagemPrompt());
                d.imprimeEm(this.paramsEdicao.getLinhaEdicao(), this.paramsEdicao.getColunaEdicao(), this.paramsEdicao.apliqueMascara(this.buffer));
            }
        }
        catch (ExcecaoMascaraNaoAplicavel excecaoMascaraNaoAplicavel) {
            // empty catch block
        }
    }

    private void deslocaBufferPraDireita(int pos) {
        if (pos >= 0 && pos < this.buffer.length) {
            int cont;
            for (cont = pos; cont > 0 && this.buffer[cont - 1] != '\u00ad'; --cont) {
                this.buffer[cont] = this.buffer[cont - 1];
            }
            this.buffer[cont] = this.paramsEdicao.getPosicaoValorInicial(cont);
        }
    }

    private void deslocaBufferPraEsquerda(int pos) {
        if (pos > 0 && pos < this.buffer.length && (this.buffer[0] == '\u00ad' || this.buffer[0] == '\u00ac' || this.buffer[0] == '\u00aa' || this.buffer[0] == '\u00ab')) {
            for (int cont = 0; cont < pos; ++cont) {
                this.buffer[cont] = this.buffer[cont + 1] != '\u00ad' && this.buffer[cont + 1] != '\u00ac' && this.buffer[cont + 1] != '\u00ab' && this.buffer[cont + 1] != '\u00aa' ? this.buffer[cont + 1] : this.paramsEdicao.getPosicaoValorInicial(cont);
            }
            this.buffer[pos] = this.paramsEdicao.getPosicaoValorInicial(pos);
        }
    }

    private Tecla encontraTecla(int codigo) {
        this.auxTecla.setCodigo(codigo);
        int indice = Arrays.binarySearch(this.teclas, this.auxTecla);
        Tecla result = null;
        if (indice >= 0) {
            result = this.teclas[indice];
        }
        return result;
    }

    private List<Tecla> encontraTecla(String codigo) {
        this.auxList.clear();
        if (this.getModoNumerico()) {
            for (int i = 0; i < this.teclas.length; ++i) {
                if (!codigo.equals(this.teclas[i].getCodigoNumerico())) continue;
                this.auxList.add(this.teclas[i]);
            }
        } else {
            for (int i = 0; i < this.teclas.length; ++i) {
                if (!codigo.equals(this.teclas[i].getCodigoAlfanumerico())) continue;
                this.auxList.add(this.teclas[i]);
            }
        }
        return this.auxList;
    }

    public boolean getModoNumerico() {
        boolean ret = true;
        if (this.paramsEdicao != null) {
            ret = this.paramsEdicao.getModoNumerico();
        }
        return ret;
    }

    public ParametrosEdicaoTeclado getParametros() {
        return this.paramsEdicaoRef;
    }

    public void inicializar() {
        if (this.paramsEdicao != null) {
            this.buffer = this.paramsEdicao.monteValorVazio();
            this.cursor = -1;
            this.nasCasasDecimais = false;
        }
    }

    public void inicializarComDefault() {
        if (this.paramsEdicao != null) {
            this.buffer = this.paramsEdicao.monteValorDefault();
            this.cursor = -1;
            this.nasCasasDecimais = false;
            if (this.paramsEdicao.getPossuiCampoEditavel()) {
                if (!this.getModoNumerico()) {
                    for (int cont = 0; cont < this.buffer.length; ++cont) {
                        if (this.buffer[cont] != '\u00ad' && this.buffer[cont] != '\u00ac' && this.buffer[cont] != '\u00ab') continue;
                        this.cursor = cont == 0 ? -1 : cont - 1;
                        break;
                    }
                } else if (this.paramsEdicao.getSeparadorDecimalObrigatorio()) {
                    if (this.buffer[this.buffer.length - 1] != '\u00ad' && this.buffer[this.buffer.length - 1] != '\u00ac' && this.buffer[this.buffer.length - 1] != '\u00ab') {
                        if (this.numCasasDecimais > 0) {
                            this.nasCasasDecimais = true;
                        }
                        this.cursor = this.buffer.length - 1;
                    }
                } else if (this.buffer[this.buffer.length - 1] != '\u00ad' && this.buffer[this.buffer.length - 1] != '\u00ac' && this.buffer[this.buffer.length - 1] != '\u00ab') {
                    this.cursor = this.buffer.length - 1;
                }
            }
        }
    }

    private boolean posicionaCursorEdicao(char car) {
        boolean ret = false;
        int cursor_bak = this.cursor;
        if (this.paramsEdicao != null && this.paramsEdicao.getPossuiCampoEditavel()) {
            if (!this.getModoNumerico()) {
                if (this.cursor < this.buffer.length - 1) {
                    ++this.cursor;
                    ret = this.paramsEdicao.testePosicaoMascara(this.cursor, car);
                }
            } else if (this.paramsEdicao.getSeparadorDecimalObrigatorio()) {
                if (this.cursor < 0) {
                    if (this.nasCasasDecimais) {
                        this.cursor = this.buffer.length - this.numCasasDecimais;
                        ret = this.paramsEdicao.testePosicaoMascara(this.cursor, car);
                    } else if (this.paramsEdicao.getAceitaZerosEsquerda() || car != '0') {
                        this.cursor = this.buffer.length - 1 - this.numCasasDecimais;
                        ret = this.paramsEdicao.testePosicaoMascara(this.cursor, car);
                    }
                } else if (this.nasCasasDecimais) {
                    if (this.cursor < this.buffer.length - 1) {
                        ++this.cursor;
                        ret = this.paramsEdicao.testePosicaoMascara(this.cursor, car);
                    }
                } else if (this.buffer[0] == '\u00ad' && (ret = this.paramsEdicao.testePosicaoMascara(this.cursor, car))) {
                    this.deslocaBufferPraEsquerda(this.cursor);
                }
            } else if (this.cursor > 0 || this.paramsEdicao.getAceitaZerosEsquerda() || car != '0') {
                if (this.cursor < 0) {
                    this.cursor = this.buffer.length - 1;
                }
                if ((this.buffer[0] == '\u00ad' || this.buffer[0] == '\u00ac' || this.buffer[0] == '\u00ab' || this.buffer[0] == '\u00aa') && (ret = this.paramsEdicao.testePosicaoMascara(this.cursor, car))) {
                    this.deslocaBufferPraEsquerda(this.cursor);
                }
            }
        }
        if (!ret) {
            this.cursor = cursor_bak;
        }
        return ret;
    }

    private void processaBackSpace() {
        if (this.paramsEdicao != null && this.paramsEdicao.getPossuiCampoEditavel()) {
            if (!this.getModoNumerico()) {
                if (this.cursor >= 0) {
                    this.buffer[this.cursor] = this.paramsEdicao.getPosicaoValorInicial(this.cursor);
                    --this.cursor;
                }
            } else if (this.paramsEdicao.getSeparadorDecimalObrigatorio()) {
                if (this.cursor < 0) {
                    if (this.nasCasasDecimais) {
                        this.nasCasasDecimais = false;
                        if (this.numCasasDecimais < this.buffer.length) {
                            this.cursor = this.buffer.length - 1 - this.numCasasDecimais;
                            this.deslocaBufferPraDireita(this.cursor);
                            if (this.buffer[this.cursor] == '\u00ad') {
                                this.cursor = -1;
                            }
                        }
                    }
                } else if (this.nasCasasDecimais) {
                    this.buffer[this.cursor] = this.paramsEdicao.getPosicaoValorInicial(this.cursor);
                    --this.cursor;
                    if (this.cursor < this.buffer.length - this.numCasasDecimais) {
                        this.cursor = -1;
                    }
                } else {
                    this.deslocaBufferPraDireita(this.cursor);
                    if (this.buffer[this.cursor] == '\u00ad') {
                        this.cursor = -1;
                    }
                }
            } else if (this.cursor >= 0) {
                this.deslocaBufferPraDireita(this.cursor);
                if (this.buffer[this.cursor] == '\u00ad') {
                    this.cursor = -1;
                }
            }
        }
    }

    public void removeDisplayEco(Display display) {
        this.displaysEco.deleta(display);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void teclaRecebida(int codTecla) {
        block20: {
            if (this.paramsEdicao == null) {
                return;
            }
            try {
                String codTeclaModoAtual;
                boolean flag_ocorreuAutoSkip = false;
                Tecla tecla = this.encontraTecla(codTecla);
                if (tecla == null) break block20;
                boolean ehFinalizadora = this.getModoNumerico() ? tecla.getFinalizadoraNumerico() : tecla.getFinalizadoraAlfanumerico();
                String string = codTeclaModoAtual = this.getModoNumerico() ? tecla.getCodigoNumerico() : tecla.getCodigoAlfanumerico();
                if (!(ehFinalizadora || this.paramsEdicao.getPossuiCampoEditavel() || this.ignorarTeclasBufferizadas)) {
                    this.teclaBufferizada[this.numTeclaBuff] = codTecla;
                    ++this.numTeclaBuff;
                }
                if (!ehFinalizadora && this.paramsEdicao.getPossuiCampoEditavel()) {
                    if (this.cursor == -1) {
                        this.getParametros().setEmEdicao(true);
                    }
                    if (codTeclaModoAtual.equalsIgnoreCase("BS")) {
                        this.processaBackSpace();
                        this.visualizaEdicao();
                    } else if (codTeclaModoAtual.equalsIgnoreCase("LIMPA")) {
                        this.inicializar();
                        this.visualizaEdicao();
                    } else if (codTeclaModoAtual.equalsIgnoreCase("SDECIMAL")) {
                        if (this.paramsEdicao.getSeparadorDecimalObrigatorio() && !this.nasCasasDecimais && this.numCasasDecimais > 0) {
                            this.nasCasasDecimais = true;
                            this.cursor = -1;
                        }
                    } else {
                        char[] temp = codTeclaModoAtual.toCharArray();
                        for (int cont = 0; cont < temp.length; ++cont) {
                            char c = temp[cont];
                            if (this.posicionaCursorEdicao(c)) {
                                this.buffer[this.cursor] = c;
                                this.visualizaEdicao();
                            }
                            if (!this.paramsEdicao.getAutoSkip()) continue;
                            flag_ocorreuAutoSkip = !this.getModoNumerico() ? this.cursor >= this.buffer.length - 1 : (this.paramsEdicao.getSeparadorDecimalObrigatorio() ? this.cursor >= this.buffer.length - 1 : this.buffer[0] != '\u00ad');
                        }
                    }
                }
                if (!ehFinalizadora && !flag_ocorreuAutoSkip) break block20;
                this.numTeclaBuff = 0;
                if (!this.finalizadoras.consulta(tecla) && !flag_ocorreuAutoSkip) break block20;
                if (flag_ocorreuAutoSkip) {
                    codTeclaModoAtual = "AUTOSKIP";
                }
                EventoTeclado ev = new EventoTeclado(this, new String(this.paramsEdicao.removaDefaults(this.buffer, true)), codTeclaModoAtual, this.paramsEdicao.getNumCaracteresDigitados(this.buffer));
                this.eventoOcorrido(ev);
                this.inicializar();
                this.paramsEdicao.ativeSenha('\u00aa');
                ParametrosEdicaoTeclado parametrosEdicaoTeclado = this.getParametros();
                synchronized (parametrosEdicaoTeclado) {
                    this.getParametros().setEmEdicao(false);
                    this.getParametros().notifyAll();
                }
            }
            catch (ExcecaoMascaraNaoAplicavel excecaoMascaraNaoAplicavel) {
            }
            catch (ExcecaoPerifericos excecaoPerifericos) {
                // empty catch block
            }
        }
    }

    private void visualizaEdicao() throws ExcecaoMascaraNaoAplicavel, ExcecaoPerifericos {
        String str = this.paramsEdicao.apliqueMascara(this.buffer);
        int tamStr = str.length();
        Enumeration<Display> e = this.displaysEco.elementos();
        while (e.hasMoreElements()) {
            Display d = e.nextElement();
            int tamMax = d.getNumColunas() - this.paramsEdicao.getColunaEdicao();
            if (tamStr > tamMax) {
                int tamDigitado;
                str = this.getModoNumerico() ? str.substring(tamStr - tamMax, tamStr) : ((tamDigitado = this.cursor + 1) <= tamMax ? str.substring(0, tamMax) : str.substring(tamDigitado - tamMax, tamDigitado));
            }
            d.imprimeEm(this.paramsEdicao.getLinhaEdicao(), this.paramsEdicao.getColunaEdicao(), str);
        }
    }

    public Tecla[] getTeclas() {
        return this.teclas;
    }

    @Override
    public long getTipoPeriferico() {
        return 1L;
    }

    @Override
    public synchronized EventoDispositivoEntrada leValor() throws ExcecaoPerifericos {
        return this.leValor(this.paramsEdicao.getLinhaEdicao(), this.paramsEdicao.getColunaEdicao());
    }

    public synchronized EventoDispositivoEntrada leValor(int linha, int coluna) throws ExcecaoPerifericos {
        this.inicializarComDefault();
        Enumeration<Display> e = this.displaysEco.elementos();
        while (e.hasMoreElements()) {
            e.nextElement().posicionaCursor(linha, coluna);
        }
        return super.leValor();
    }

    public String getBuffer() {
        return new String(this.buffer);
    }

    public class ConjuntoDisplay {
        private Vector<Display> elementos = new Vector();

        public boolean consulta(Display elemento) {
            return this.elementos.contains(elemento);
        }

        public void deleta(Display elemento) {
            this.elementos.removeElement(elemento);
        }

        public Enumeration<Display> elementos() {
            return this.elementos.elements();
        }

        public void inclui(Display elemento) {
            if (!this.elementos.contains(elemento)) {
                this.elementos.addElement(elemento);
            }
        }

        public int tamanho() {
            return this.elementos.size();
        }
    }
}

