/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.config;

import com.csi.ctfclient.excecoes.ExcecaoConjuntoInvalido;
import com.csi.ctfclient.excecoes.ExcecaoObjetoInexistente;
import com.csi.ctfclient.info.tiposgerais.Chave;
import com.csi.ctfclient.info.tiposgerais.ChaveInteira;
import com.csi.ctfclient.tools.devices.config.Tecla;
import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;

public class ConjuntoTecla
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Vector<Tecla> teclas;

    public ConjuntoTecla() {
        this.teclas = new Vector();
    }

    public ConjuntoTecla(Collection<Tecla> teclas) {
        this.teclas = teclas != null ? new Vector<Tecla>(teclas) : new Vector();
    }

    public ConjuntoTecla(ConjuntoTecla conjuntoTecla) throws ExcecaoConjuntoInvalido {
        if (conjuntoTecla == null) {
            throw new ExcecaoConjuntoInvalido();
        }
        this.teclas = conjuntoTecla.teclas;
    }

    public Tecla busca(ChaveInteira codigo) throws ExcecaoObjetoInexistente {
        if (null != codigo && null != this.teclas && !this.teclas.isEmpty()) {
            for (Tecla tecla : this.teclas) {
                if (!tecla.getChave().equals(codigo)) continue;
                return tecla;
            }
        }
        throw new ExcecaoObjetoInexistente();
    }

    public boolean consulta(int codigo) {
        return this.consulta(new ChaveInteira(codigo));
    }

    public boolean consulta(Tecla tecla) {
        return this.teclas.contains(tecla);
    }

    public boolean consulta(Chave chave) {
        if (null != chave && null != this.teclas && !this.teclas.isEmpty()) {
            for (Tecla tecla : this.teclas) {
                if (!tecla.getChave().equals(chave)) continue;
                return true;
            }
        }
        return false;
    }

    public void deleta(int codigo) throws ExcecaoObjetoInexistente {
        this.deleta(new ChaveInteira(codigo));
    }

    public void deleta(Tecla tecla) throws ExcecaoObjetoInexistente {
        this.deleta((ChaveInteira)tecla.getChave());
    }

    public void deleta(ChaveInteira chave) throws ExcecaoObjetoInexistente {
        if (!this.consulta(chave)) {
            throw new ExcecaoObjetoInexistente();
        }
        this.teclas.remove(this.busca(chave));
    }

    public Vector<Tecla> getTeclas() {
        return this.teclas;
    }

    public void inclui(Tecla tecla) {
        if (!this.consulta(tecla.getChave())) {
            this.teclas.add(tecla);
        }
    }

    public void limpa() {
        this.teclas.clear();
    }

    public int tamanho() {
        return this.teclas.size();
    }
}

