/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.emv;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.LeituraCartaoEnum;
import com.csi.ctfclient.apitef.model.Aid;
import com.csi.ctfclient.excecoes.ExcecaoInteiroInvalido;
import com.csi.ctfclient.operacoes.constantes.AidListType;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.DadosLeitorCartao;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.devices.PerifericoEntradaDados;
import com.csi.ctfclient.tools.devices.emv.CardTechnologyType;
import com.csi.ctfclient.tools.devices.emv.ConstantesEMV;
import com.csi.ctfclient.tools.devices.emv.EventoLeitorCartao;
import com.csi.ctfclient.tools.devices.emv.PinpadKeyboardEventType;
import com.csi.ctfclient.tools.devices.emv.SaidaCheckEventEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGenericCmdEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetCardEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetCardQualidade;
import com.csi.ctfclient.tools.devices.emvfull.GenericPinpadController;
import com.csi.ctfclient.tools.devices.emvfull.KeyFactory;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.devices.events.EventBuilder;
import com.csi.ctfclient.tools.util.AuttarSecurity;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.DisplayFisicoCSILanguage;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Objects;

public class LeitorCartao
extends PerifericoEntradaDados
implements DadosLeitorCartao,
Runnable,
ConstantesEMV {
    private static final int CHECK_EVENT_SUCCESS = 0;
    private static final int CHECK_EVENT_REDO = 1;
    private static final int CHECK_EVENT_CANCEL = 2;
    public static int CARGA_TABELA_OK = 0;
    public static int CARGA_TABELA_TABEXP = 1;
    public static int CARGA_TABELA_SOLICITADA = 2;
    public static int ERRO_SOLICITA_CARGA_TABELA = 3;
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(Periferico.class);
    private final GenericPinpadController protocolo;
    protected boolean trilha1Habilitada = true;
    protected boolean trilha2Habilitada = true;
    protected boolean trilha3Habilitada = true;
    protected String trilha1 = "";
    protected String trilha2 = "";
    protected String trilha3 = "";
    protected boolean rereading;
    int actionCheckEvent;
    private LeituraCartaoEnum actionLeituraCartao = LeituraCartaoEnum.EMV;
    private int idRedeAdquirente;
    private Integer indiceAID;
    private int tipoAplicacao;
    private long valorInicialTransacao;
    private Date dataTransacao;
    private String timeStamp;
    private List<Aid> idsRedeIndTab;
    private boolean habilitaContactless;
    private int atualizandoTabelas = CARGA_TABELA_OK;
    private String priorityList;
    private String notPriorityList;
    private String fullList;
    private AidListType aidListType;
    private boolean emLeitura;
    private boolean activeContactless;
    private SaidaGetCardEMV saidaCartaoMagneticoCheckEvent;
    private SaidaGetCardQualidade saidaCartaoMagneticoCheckEventQualidade;
    private int lastGetCardResult;
    private int modalidadePagamento;

    public LeitorCartao(GenericPinpadController protocolo) {
        this.protocolo = protocolo;
        this.setIdRedeAdquirente(0);
        this.setTipoAplicacao(0);
        this.setValorInicialTransacao(100L);
        GregorianCalendar calendar = new GregorianCalendar(2006, 0, 16);
        this.setDataTransacao(calendar.getTime());
        this.setTimeStamp("1602200602");
        this.setIdsRedeIndTab(null);
        this.activeContactless = false;
        logger = CTFClientCore.getAuttarLoggerFactory().getLogger(Periferico.class);
    }

    public static String descriptografaPAN(String panCripto, boolean formatarEspacos) throws Exception {
        String panAberto;
        logger = CTFClientCore.getAuttarLoggerFactory().getLogger(Periferico.class);
        int tamanhoPan = panCripto.length();
        String panCripto16 = tamanhoPan > 16 ? panCripto.substring(tamanhoPan - 16, tamanhoPan) : panCripto;
        try {
            panAberto = AuttarSecurity.decrypt3DES(ProtocoloBibliotecaCompartilhada.getWkpan(), panCripto16);
        }
        catch (Exception e) {
            logger.error("Erro ao descriptografar 3DES: " + e.getMessage());
            throw e;
        }
        if (panAberto == null) {
            logger.error("Pan nulo antes desconvert\u00ea-lo. WKPAN='" + ProtocoloBibliotecaCompartilhada.getWkpan() + "', lenght pan cripto=" + panCripto16.length());
        }
        if (formatarEspacos && panAberto != null) {
            panAberto = LeitorCartao.desconverterPan(panAberto);
        }
        return panAberto;
    }

    public static String atualizaTrilha(String trilha, String panAntigo, String panNovo) {
        int index;
        String retorno = trilha;
        if (trilha != null && trilha.trim().length() > 0 && (index = trilha.indexOf(panAntigo)) != -1) {
            retorno = trilha.substring(0, index) + panNovo + trilha.substring(index + panAntigo.length());
        }
        return retorno;
    }

    private static String desconverterPan(String pan) {
        int i;
        String panTemp = pan.replace('E', ' ');
        for (i = panTemp.length(); i > 0 && pan.startsWith("F", i - 1); --i) {
        }
        return panTemp.substring(0, i);
    }

    public LeituraCartaoEnum getActionLeituraCartao() {
        return this.actionLeituraCartao;
    }

    @Override
    public void setActionLeituraCartao(LeituraCartaoEnum actionLeituraCartao) {
        this.actionLeituraCartao = actionLeituraCartao;
    }

    public boolean isActiveContactless() {
        return this.activeContactless;
    }

    @Override
    public void setActiveContactless(boolean activeContactless) {
        this.activeContactless = activeContactless;
    }

    private int checkEventOccurredAtPin(SaidaCheckEventEMV saidaCheckEventEMV) {
        if (CardTechnologyType.MAGNETIC_STRIPE == saidaCheckEventEMV.getCardTechnology()) {
            return this.setOutputCardMagneticCheckEvent(saidaCheckEventEMV);
        }
        if (CardTechnologyType.CTLS_DETECTED == saidaCheckEventEMV.getCardTechnology()) {
            this.aidListType = AidListType.ALL_AIDS;
        } else {
            if (CardTechnologyType.CTLS_TIMEOUT == saidaCheckEventEMV.getCardTechnology()) {
                logger.info("For\u00e7ando novo ciclo de CheckEvent devido a timeout.");
                return 1;
            }
            if (CardTechnologyType.CHIP_CARD_REMOVED == saidaCheckEventEMV.getCardTechnology()) {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public void run() {
        this.emLeitura = true;
        this.setAidLists();
        if (this.activeContactless) {
            do {
                this.actionCheckEvent = 0;
                SaidaCheckEventEMV saidaCheckEventEMV = this.callCheckEvent("LEICAR_TITLE_CONTACTLESS1", 1, 1, 1, 1);
                if (null == saidaCheckEventEMV) continue;
                this.actionCheckEvent = this.checkEventOccurredAtPin(saidaCheckEventEMV);
                if (this.actionCheckEvent != 0) continue;
                this.esperaGetCard(CardTechnologyType.MAGNETIC_STRIPE == saidaCheckEventEMV.getCardTechnology());
            } while (this.actionCheckEvent == 1);
        } else {
            switch (this.actionLeituraCartao) {
                case QUALIDADE: {
                    this.esperaGetCardQualidade();
                    break;
                }
                default: {
                    this.esperaGetCard(false);
                }
            }
        }
        this.emLeitura = false;
    }

    public boolean isLeitura() {
        return this.emLeitura;
    }

    public int getIdRedeAdquirente() {
        return this.idRedeAdquirente;
    }

    public void setIdRedeAdquirente(int idRede) {
        this.idRedeAdquirente = idRede;
    }

    public Integer getIndiceAID() {
        return this.indiceAID;
    }

    public void setIndiceAID(Integer indiceAID) {
        this.indiceAID = indiceAID;
    }

    public int getTipoAplicacao() {
        return this.tipoAplicacao;
    }

    @Override
    public void setTipoAplicacao(int tipoAplicacao) {
        this.tipoAplicacao = tipoAplicacao;
    }

    public long getValorInicialTransacao() {
        return this.valorInicialTransacao;
    }

    @Override
    public void setValorInicialTransacao(long valorInicial) {
        this.valorInicialTransacao = valorInicial;
    }

    public Date getDataTransacao() {
        return this.dataTransacao;
    }

    @Override
    public void setDataTransacao(Date dt) {
        this.dataTransacao = dt;
    }

    public SaidaGetCardQualidade getSaidaCartaoMagneticoCheckEventQualidade() {
        return this.saidaCartaoMagneticoCheckEventQualidade;
    }

    public void setSaidaCartaoMagneticoCheckEventQualidade(SaidaGetCardQualidade saidaCartaoMagneticoCheckEventQualidade) {
        this.saidaCartaoMagneticoCheckEventQualidade = saidaCartaoMagneticoCheckEventQualidade;
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    public List<Aid> getIdsRedeIndTab(AidListType listType) {
        if (null == this.idsRedeIndTab || listType.equals((Object)AidListType.ALL_AIDS)) {
            return this.idsRedeIndTab;
        }
        boolean priority = listType.equals((Object)AidListType.PRIORITY_AIDS);
        ArrayList<Aid> aidList = new ArrayList<Aid>();
        for (Aid aid : this.idsRedeIndTab) {
            if (aid.isPrioritario() != priority) continue;
            aidList.add(aid);
        }
        return aidList;
    }

    public void setIdsRedeIndTab(List<Aid> ids) {
        this.idsRedeIndTab = ids;
    }

    public int getSolicitaCargaTabelas() {
        return this.atualizandoTabelas;
    }

    public void setSolicitaCargaTabelas(int atualizandoTabelas) {
        this.atualizandoTabelas = atualizandoTabelas;
    }

    public boolean isHabilitaContactless() {
        return this.habilitaContactless;
    }

    public void setHabilitaContactless(boolean habilitaContactless) {
        this.habilitaContactless = habilitaContactless;
    }

    public String getAidList() {
        switch (this.aidListType) {
            case PRIORITY_AIDS: {
                return this.priorityList;
            }
            case NOT_PRIORITY_AIDS: {
                return this.notPriorityList;
            }
            case ALL_AIDS: {
                return this.fullList;
            }
        }
        return null;
    }

    public int iniciaCargaTabelas(String timeStamp) throws ExcecaoPerifericos {
        this.protocolo.openCommunication();
        String cmdTableInit = (this.getIdRedeAdquirente() < 10 ? "0" : "") + this.getIdRedeAdquirente() + timeStamp;
        int retorno = this.protocolo.tableLoadInit(cmdTableInit.toCharArray());
        ProtocoloBibliotecaCompartilhada.validateReturn(retorno, "tableLoadInit");
        return retorno;
    }

    public int executaCargaTabelas(String tabela) throws ExcecaoPerifericos {
        int retorno = this.protocolo.tableLoadRec(tabela.toCharArray());
        ProtocoloBibliotecaCompartilhada.validateReturn(retorno, "tableLoadRec");
        return retorno;
    }

    public int finalizaCargaTabelas() throws ExcecaoPerifericos {
        int retorno = this.protocolo.tableLoadEnd();
        ProtocoloBibliotecaCompartilhada.validateReturn(retorno, "tableLoadEnd");
        return retorno;
    }

    @Override
    public void desabilita() throws ExcecaoPerifericos {
        this.setHabilitado(false);
        int ret = this.protocolo.abort();
        logger.info("desabilita leitor cartao -> abort = " + ret);
    }

    public void resetSerial() {
        this.setHabilitado(false);
        this.protocolo.resetSerial();
        this.eventoOcorrido(EventBuilder.buildCardReaderErrorEvent(this, 31));
    }

    public void desabilitaTrilha(int numTrilha) throws ExcecaoInteiroInvalido {
        switch (numTrilha) {
            case 1: {
                this.trilha1Habilitada = false;
                break;
            }
            case 2: {
                this.trilha2Habilitada = false;
                break;
            }
            case 3: {
                this.trilha3Habilitada = false;
                break;
            }
            default: {
                throw new ExcecaoInteiroInvalido("PER62");
            }
        }
    }

    @Override
    public synchronized void habilita() throws ExcecaoPerifericos {
        logger.debug("habilita leitor cart\u00e3o");
        this.protocolo.openCommunication();
        this.setHabilitado(true);
        Thread leitor = new Thread(this);
        leitor.start();
        this.notifyAll();
    }

    public void habilitaTrilha(int numTrilha) throws ExcecaoInteiroInvalido {
        switch (numTrilha) {
            case 1: {
                this.trilha1Habilitada = true;
                break;
            }
            case 2: {
                this.trilha2Habilitada = true;
                break;
            }
            case 3: {
                this.trilha3Habilitada = true;
                break;
            }
            default: {
                throw new ExcecaoInteiroInvalido("PER62");
            }
        }
    }

    private String formataIdsRedeIndTabs(AidListType listType, boolean verifyContactless) {
        List<Aid> listAID = this.getIdsRedeIndTab(listType);
        BigDecimal transactionAmount = new BigDecimal(0);
        if (null != Contexto.getContexto().getEntradaIntegracao() && null != Contexto.getContexto().getEntradaIntegracao().getValorTransacao()) {
            transactionAmount = Contexto.getContexto().getEntradaIntegracao().getValorTransacao();
        }
        if (listAID != null && listAID.size() > 0) {
            StringBuilder retorno = new StringBuilder(StringUtil.completaString("" + listAID.size(), 2, '0', 3));
            for (Aid aid : listAID) {
                if (verifyContactless && !this.activeContactless && aid.isContactless()) {
                    this.activeContactless = aid.getLimiteTransacionalContactless().compareTo(transactionAmount) > 0 || aid.getLimiteTransacionalContactlessMobile().compareTo(transactionAmount) > 0;
                }
                retorno.append(StringUtil.completaString(aid.getRede(), 2, '0', 3));
                retorno.append(StringUtil.completaString(aid.getIndice(), 2, '0', 3));
            }
            this.activeContactless = this.activeContactless && this.protocolo.getInfoEMV().isSuportaContactless() && this.isHabilitaContactless();
            return retorno.toString();
        }
        return "00";
    }

    private int setOutputCardMagneticCheckEvent(SaidaCheckEventEMV saidaCheckEventEMV) {
        this.saidaCartaoMagneticoCheckEvent = new SaidaGetCardEMV();
        if (saidaCheckEventEMV.getBufferResposta() != null) {
            this.saidaCartaoMagneticoCheckEvent.setMagneticCheckEvent(saidaCheckEventEMV.getBufferResposta());
        } else {
            this.saidaCartaoMagneticoCheckEvent.setMagneticCheckEventAbecs(saidaCheckEventEMV.getTrilha1Incompleta(), saidaCheckEventEMV.getTrilha2Incompleta(), saidaCheckEventEMV.getTrilha3Incompleta());
        }
        if (this.saidaCartaoMagneticoCheckEvent.getTamPAN() > 0) {
            return 0;
        }
        this.protocolo.display(new DisplayFisicoCSILanguage().getMessage("ERROR_MCDATA").toCharArray());
        this.eventoOcorrido(EventBuilder.buildCardReaderErrorEvent(this, 41));
        return 2;
    }

    private SaidaCheckEventEMV callCheckEvent(String iMessages, Integer checkKEY, Integer checkMAG, Integer checkICC, Integer checkCTLS) {
        SaidaCheckEventEMV saidaCheckEventEMV = null;
        try {
            this.protocolo.display(new DisplayFisicoCSILanguage().getMessage(iMessages).toCharArray());
            int response = this.protocolo.startCheckEvent(checkKEY, checkMAG, checkICC, checkCTLS);
            ProtocoloBibliotecaCompartilhada.validateReturn(response, "startCheckEvent");
            do {
                if (!this.getHabilitado()) {
                    int abort = this.protocolo.abort();
                    logger.info("retorno checkEvent: abort = " + abort);
                    return null;
                }
                saidaCheckEventEMV = this.protocolo.checkEvent();
                logger.info("Retorno da CheckEvent = " + saidaCheckEventEMV.getRetorno());
                switch (saidaCheckEventEMV.getRetorno()) {
                    case 41: {
                        this.eventoOcorrido(EventBuilder.buildCardReaderErrorEvent(this, 41));
                        return null;
                    }
                    case 31: {
                        this.resetSerial();
                        break;
                    }
                    case 0: {
                        if (saidaCheckEventEMV.getKeyboardEvent() != PinpadKeyboardEventType.KEYBOARD_CANCEL) break;
                        this.eventoOcorrido(EventBuilder.buildCardReaderErrorEvent(this, 13));
                        return null;
                    }
                }
            } while (saidaCheckEventEMV.getRetorno() == 1);
        }
        catch (Exception e) {
            logger.error("Erro no comando callCheckEvent: " + e.getMessage());
            this.setHabilitado(false);
            this.eventoOcorrido(EventBuilder.buildCardReaderErrorEvent(this, 999));
        }
        logger.debug("Finalizada a fun\u00e7\u00e3o PP_CheckEvent");
        return saidaCheckEventEMV;
    }

    private void esperaGetCardQualidade() {
        try {
            SaidaGetCardQualidade result = this.getCardSyncQualidade();
            if (null == result) {
                return;
            }
            this.setHabilitado(false);
            this.eventoOcorrido(EventBuilder.buildCardReaderEvent((Periferico)this, result, result.getRetorno() != 0, result.getRetorno()));
        }
        catch (Exception e) {
            logger.error("erro no comando esperaGetCard. Wkpan:'" + ProtocoloBibliotecaCompartilhada.getWkpan() + "', for\u00e7ando erro: 900", e);
            this.setHabilitado(false);
            this.eventoOcorrido(EventBuilder.buildCardReaderErrorEvent(this, 900));
        }
    }

    private void esperaGetCard(boolean entradaCartaoMagnetico) {
        block31: {
            try {
                SaidaGetCardEMV result;
                if (entradaCartaoMagnetico) {
                    result = this.saidaCartaoMagneticoCheckEvent;
                    result.setStatusUltLeitura(this.getLastReadingStatus());
                } else {
                    result = this.getCardSync();
                    if (result != null) {
                        this.lastGetCardResult = result.getRetorno();
                    }
                }
                if (null == result) {
                    return;
                }
                if (!this.getHabilitado()) break block31;
                if (ProtocoloBibliotecaCompartilhada.isSecureCommunication()) {
                    if (KeyFactory.isChaveLocal()) {
                        if (result.getPAN().trim().length() > 12) {
                            String panAbertoCompleto;
                            String panCripto = result.getPAN();
                            String panCriptoTrilha1 = result.getPANTrilha1();
                            String panCriptoTrilha2 = result.getPANTrilha2();
                            String panAberto = "";
                            try {
                                panAberto = LeitorCartao.descriptografaPAN(panCripto, true);
                            }
                            catch (Exception e) {
                                logger.error("Erro na descriptografia do pan");
                            }
                            String panAbertoTrilha1 = "";
                            String panAbertoTrilha2 = "";
                            if (panCriptoTrilha1 != null && !panCriptoTrilha1.equals("")) {
                                try {
                                    panAbertoTrilha1 = LeitorCartao.descriptografaPAN(panCriptoTrilha1, true);
                                }
                                catch (Exception e) {
                                    logger.error("Erro na descriptografia do pan da trilha 1");
                                }
                            }
                            if (panCriptoTrilha2 != null && !panCriptoTrilha2.equals("")) {
                                try {
                                    panAbertoTrilha2 = LeitorCartao.descriptografaPAN(panCriptoTrilha2, true);
                                }
                                catch (Exception e) {
                                    logger.error("Erro na descriptografia do pan da trilha 1");
                                }
                            }
                            if (!(panAbertoTrilha1 != null && panAbertoTrilha1.length() != 0 || panAbertoTrilha2 != null && panAbertoTrilha2.length() != 0)) {
                                logger.error(String.format("erro no comando esperaGetCard, nenhuma trilha foi descritografadas. Wkpan:'%s', for\u00e7ando erro: 68", ProtocoloBibliotecaCompartilhada.getWkpan()));
                                this.setHabilitado(false);
                                this.eventoOcorrido(EventBuilder.buildCardReaderErrorEvent(this, 68));
                            }
                            String panCripto16Trilha1 = panCriptoTrilha1 != null && panCriptoTrilha1.length() > 16 ? panCriptoTrilha1.substring(panCriptoTrilha1.length() - 16) : panCriptoTrilha1;
                            String panCripto16Trilha2 = panCriptoTrilha2 != null && panCriptoTrilha2.length() > 16 ? panCriptoTrilha2.substring(panCriptoTrilha2.length() - 16) : panCriptoTrilha2;
                            if (panCripto16Trilha1.length() > 0) {
                                result.setTrilha1(LeitorCartao.atualizaTrilha(result.getTrilha1(), panCripto16Trilha1, panAbertoTrilha1));
                            }
                            if (panCripto16Trilha2.length() > 0) {
                                result.setTrilha2(LeitorCartao.atualizaTrilha(result.getTrilha2(), panCripto16Trilha2, panAbertoTrilha2));
                            }
                            if (panCripto.length() > 16) {
                                String restantePan = panCripto.substring(0, panCripto.length() - 16);
                                logger.debug("Restante PAN: " + restantePan);
                                panAbertoCompleto = restantePan + panAberto;
                            } else {
                                panAbertoCompleto = panAberto;
                            }
                            panAbertoCompleto = this.retiraEspacosPAN(panAbertoCompleto);
                            if (result.isTrilhasSemDelimitadores()) {
                                logger.info("Delimitadores das trilhas n\u00e3o encontrados, capturando o PAN do inicio da trilha...");
                                StringBuilder bufferPAN = new StringBuilder();
                                for (int i = 0; i < result.getTrilha2().length(); ++i) {
                                    if (Character.isDigit(result.getTrilha2().charAt(i))) {
                                        bufferPAN.append(result.getTrilha2().charAt(i));
                                    }
                                    if (bufferPAN.length() == 19) break;
                                }
                                panAbertoCompleto = bufferPAN.toString();
                                logger.info(String.format("Foram capturados os %d primeiros d\u00edgitos da trilha 2 para constituir o PAN", panAbertoCompleto.length()));
                            }
                            String panAbertoParaReverter = panAbertoCompleto.length() < 16 ? StringUtil.completaString(panAbertoCompleto, 16, 'F', 4) : (panAbertoCompleto.length() > 16 ? panAbertoCompleto.substring(0, 16) : panAbertoCompleto);
                            String pan3DESReverso = LeitorCartao.descriptografaPAN(panAbertoParaReverter, false);
                            if (panAbertoCompleto.length() > 16) {
                                String restantePan = panAbertoCompleto.substring(16);
                                logger.debug("Restante PAN: " + restantePan);
                                pan3DESReverso = pan3DESReverso + restantePan;
                                logger.debug("Pan 3Des reverso: " + pan3DESReverso);
                            }
                            result.setPANCripto(pan3DESReverso);
                            result.setPAN(panAbertoCompleto);
                            logger.debug("PAN do cart\u00e3o descriptografado.");
                        } else if (result.getRetorno() == 0) {
                            logger.debug("PAN do cart\u00e3o menor que 13 d\u00edgitos, as trilhas n\u00e3o ser\u00e3o descriptografadas.");
                        }
                    }
                } else {
                    result.setPAN(this.retiraEspacosPAN(result.getPAN()));
                }
                this.setHabilitado(false);
                if (this.protocolo.isPinpadAbecs() && result.getRetorno() == 0 && result.getTipoCartao() == 0 && result.getTamTrilha1() == 0 && result.getTamTrilha2() == 0 && result.getTamTrilha3() == 0) {
                    this.protocolo.display(new DisplayFisicoCSILanguage().getMessage("ERROR_MCDATA").toCharArray());
                    this.eventoOcorrido(EventBuilder.buildCardReaderErrorEvent(this, 41));
                    return;
                }
                this.eventoOcorrido(EventBuilder.buildCardReaderEvent((Periferico)this, result, result.getRetorno() != 0 && result.getRetorno() != 13, result.getRetorno()));
            }
            catch (ExcecaoPerifericos e) {
                logger.error("Erro no comando esperaGetCard: " + e.getMessage());
                this.setHabilitado(false);
                this.eventoOcorrido(EventBuilder.buildCardReaderErrorEvent(this, 999));
            }
            catch (Exception e) {
                logger.error(String.format("Erro no comando esperaGetCard. Wkpan:'%s', for\u00e7ando erro: 900. Erro: %s", ProtocoloBibliotecaCompartilhada.getWkpan(), e.getMessage()));
                this.setHabilitado(false);
                this.eventoOcorrido(EventBuilder.buildCardReaderErrorEvent(this, 900));
            }
        }
    }

    private synchronized SaidaGetCardQualidade getCardSyncQualidade() throws ExcecaoPerifericos {
        if (!this.getHabilitado()) {
            return null;
        }
        SaidaGetCardQualidade retorno = this.callStartGetCardQualidade();
        if (!this.getHabilitado()) {
            this.protocolo.abort();
            logger.debug("desabilita leitor cart\u00e3o -> abort");
            logger.info("retorno GetCardQualidade = abort");
            return null;
        }
        logger.info("Retorno da GetCardQualidade = " + retorno.getRetorno());
        logger.debug("Fim da fun\u00e7\u00e3o PP_GetCardQualidade");
        return retorno;
    }

    private synchronized SaidaGetCardEMV getCardSync() throws ExcecaoPerifericos {
        boolean doAgain;
        SaidaGetCardEMV retorno;
        if (!this.getHabilitado()) {
            return null;
        }
        this.callStartGetCard();
        do {
            doAgain = false;
            if (!this.getHabilitado()) {
                int abort = this.protocolo.abort();
                logger.info("retorno GetCard: abort = " + abort);
                return null;
            }
            retorno = this.protocolo.getCard();
            logger.info("Retorno da GetCard = " + retorno.getRetorno());
            switch (retorno.getRetorno()) {
                case 2: {
                    this.eventoOcorrido(EventBuilder.buildMessageEvent(this, retorno.getMsgNotify()));
                    break;
                }
                case 20: {
                    this.setSolicitaCargaTabelas(CARGA_TABELA_TABEXP);
                    break;
                }
                case 31: {
                    this.resetSerial();
                    break;
                }
                case 70: {
                    if (this.aidListType != AidListType.PRIORITY_AIDS) break;
                    this.aidListType = AidListType.NOT_PRIORITY_AIDS;
                    this.callStartGetCard();
                    doAgain = true;
                    break;
                }
                case 0: {
                    if (this.protocolo.isPinpadAbecs()) break;
                    this.setSelectedAidByTag84(retorno);
                }
            }
        } while (retorno.getRetorno() == 1 || retorno.getRetorno() == 2 || doAgain);
        logger.debug("Fim da fun\u00e7\u00e3o PP_GetCard");
        return retorno;
    }

    private void setSelectedAidByTag84(SaidaGetCardEMV saidaGetCardEMV) {
        SaidaGenericCmdEMV saidaGenericCmdEMV;
        logger.debug("Iniciada a fun\u00e7\u00e3o PP_GenericCmd, para encontrar AID selecionado");
        int idRede = saidaGetCardEMV.getIdRedeAdquirente();
        char[] genericCmd = this.protocolo.buildStartGenericCommandTag84Parameters(saidaGetCardEMV);
        if (genericCmd == null) {
            return;
        }
        int startGenericCmdResponse = this.protocolo.startGenericCmd(genericCmd);
        if (0 == startGenericCmdResponse && null != (saidaGenericCmdEMV = this.protocolo.genericCmd()) && saidaGenericCmdEMV.getRetorno() == 0 && null != saidaGenericCmdEMV.getBufferResposta()) {
            String selectedAID = this.getEnvdatValue(idRede, saidaGenericCmdEMV.getBufferResposta());
            saidaGetCardEMV.setAidSelecionado(selectedAID);
            logger.info("AID selecionado = ".concat(null == selectedAID ? "" : selectedAID));
        }
        logger.debug("Fim da fun\u00e7\u00e3o PP_GenericCmd");
    }

    private String getEnvdatValue(int rede, String envdat) {
        try {
            int index;
            int n = index = rede == 4 ? 10 : 7;
            if (envdat.length() > index) {
                String envdatTag = envdat.substring(index - 4, index - 2);
                int envdatLength = Integer.valueOf(envdat.substring(index - 2, index), 16) * 2;
                if ("84".equals(envdatTag) && envdatLength > 0 && envdatLength == envdat.length() - index) {
                    return envdat.substring(index, index + envdatLength);
                }
            }
        }
        catch (Exception e) {
            logger.error(String.format("Houve um erro ao pegar o ENVDAT da TAG 84 com a rede %d. ERRO: %s", rede, e.getMessage()));
        }
        return null;
    }

    private void callStartGetCard() throws ExcecaoPerifericos {
        int retorno;
        if (this.getSolicitaCargaTabelas() == CARGA_TABELA_OK) {
            logger.info("Lista AIDs selecionada (" + this.aidListType.toString() + "): " + this.getAidList());
            retorno = this.protocolo.startGetCard(this.protocolo.buildStartGetCardParameters(this));
            if (retorno == 31) {
                this.resetSerial();
            }
        } else {
            retorno = 999;
        }
        ProtocoloBibliotecaCompartilhada.validateReturn(retorno, "startGetCard");
    }

    private SaidaGetCardQualidade callStartGetCardQualidade() throws ExcecaoPerifericos {
        SaidaCheckEventEMV saidaCheckEventEMV = this.callCheckEvent("LEICAR_TITLE2", 1, 0, 1, 0);
        if (!Objects.isNull(saidaCheckEventEMV) && saidaCheckEventEMV.getCardTechnology() == CardTechnologyType.CHIP_CARD_INSERTED) {
            return this.protocolo.getCardQualidade();
        }
        return null;
    }

    private String retiraEspacosPAN(String pan) {
        if (pan != null) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < pan.length(); ++i) {
                if (pan.charAt(i) == ' ') continue;
                buffer.append(pan.charAt(i));
            }
            return buffer.toString();
        }
        return pan;
    }

    private void setAidLists() {
        logger.debug("Iniciando o processo de cria\u00e7\u00e3o das listas AID's");
        this.fullList = this.formataIdsRedeIndTabs(AidListType.ALL_AIDS, true);
        logger.debug("Lista de AID's Completa = ".concat(this.fullList));
        if (this.isRereading()) {
            this.aidListType = AidListType.ALL_AIDS;
        } else {
            this.priorityList = this.formataIdsRedeIndTabs(AidListType.PRIORITY_AIDS, false);
            logger.debug("Lista de AID's Priorit\u00e1ria = ".concat(this.priorityList));
            this.notPriorityList = this.formataIdsRedeIndTabs(AidListType.NOT_PRIORITY_AIDS, false);
            logger.debug("Lista de AID's Secund\u00e1ria = ".concat(this.notPriorityList));
            this.aidListType = AidListType.PRIORITY_AIDS;
        }
        logger.debug("Fim do processo de cria\u00e7\u00e3o das listas AID's");
    }

    private int getLastReadingStatus() {
        switch (this.lastGetCardResult) {
            case 50: 
            case 60: 
            case 61: 
            case 76: {
                return 1;
            }
            case 70: {
                return 2;
            }
        }
        return 0;
    }

    public synchronized void erroOcorrido(int erro) {
        if (!this.getHabilitado()) {
            return;
        }
        EventoLeitorCartao evt = new EventoLeitorCartao(this, this.trilha1, this.trilha2, this.trilha3, true, erro);
        this.eventoOcorrido(evt);
    }

    @Override
    public long getTipoPeriferico() {
        return 8L;
    }

    public synchronized void cartaoLido(String trilha1, String trilha2, String trilha3, String dadosEspTr1, String flags, String nomePortCart, String numExtCart, int pix, int tipoCartao) {
        if (!this.getHabilitado()) {
            return;
        }
        EventoLeitorCartao evt = new EventoLeitorCartao(this, false, dadosEspTr1, 0, flags, nomePortCart, numExtCart, pix, tipoCartao, trilha1, trilha2, trilha3);
        this.eventoOcorrido(evt);
    }

    public synchronized void mensagemLida(String mensagem) {
    }

    public int getModalidadePagamento() {
        return this.modalidadePagamento;
    }

    public synchronized void setModalidadePagamento(int newModalidadePagamento) {
        this.modalidadePagamento = newModalidadePagamento;
    }

    public boolean isRereading() {
        return this.rereading;
    }

    public void setRereading(boolean rereading) {
        this.rereading = rereading;
    }
}

