/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.emv;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.devices.emv.ConstantesAbecs;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloAbecs;

public class SaidaGetInfoEMV {
    private static final String IDENTIFICADOR_SUPORTE_CONTACTLESS = "C";
    private AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(Periferico.class);
    private String fabricante;
    private String modeloHardware;
    private String numSeriePinpad;
    private String versaoFirmware;
    private String versaoAplBasica;
    private String versaoEspecificacao;
    private boolean suportaContactless;
    private int retorno;
    private Integer graphicDisplayColumnsNum;
    private Integer graphicDisplayLinesNum;
    private String multimediaFilesSupport;
    private String pinpadCapacity;
    private int textDisplayColumnsNum;
    private int textDisplayLinesNum;
    private String keyMapMKTripleDESData;
    private String keyMapMKTripleDESPin;
    private String keyMapDUKPTTripleDESData;
    private String keyMapDUKPTripleDESPin;
    private String tableVersion;

    public SaidaGetInfoEMV() {
    }

    public SaidaGetInfoEMV(int retorno, char[] resposta) {
        this.logger.debug("Retorno da SaidaGetInfoEMV: " + retorno);
        this.logger.debug("Dados retornados da SaidaGetInfoEMV: ".concat(new String(resposta)));
        this.setRetorno(retorno);
        this.setRespostaDLL(new String(resposta));
    }

    public SaidaGetInfoEMV(int retorno, String fabricante, String modeloHardware, String versaoFirmware, String versaoEspecificacao, String versaoAplBasica, String numSeriePinpad) {
        this.retorno = retorno;
        this.fabricante = fabricante;
        this.modeloHardware = modeloHardware;
        this.numSeriePinpad = numSeriePinpad;
        this.versaoEspecificacao = versaoEspecificacao;
        this.versaoFirmware = versaoFirmware;
        this.versaoAplBasica = versaoAplBasica;
    }

    public String getFabricante() {
        return this.fabricante;
    }

    public String getModeloHardware() {
        return this.modeloHardware;
    }

    public boolean isSuportaContactless() {
        return this.suportaContactless;
    }

    public String getVersaoFirmware() {
        return this.versaoFirmware;
    }

    public String getVersaoEspecificacao() {
        return this.versaoEspecificacao;
    }

    public String getVersaoAplBasica() {
        return this.versaoAplBasica;
    }

    public String getNumSeriePinpad() {
        return this.numSeriePinpad;
    }

    public Integer getGraphicDisplayColumnsNum() {
        return this.graphicDisplayColumnsNum;
    }

    public Integer getGraphicDisplayLinesNum() {
        return this.graphicDisplayLinesNum;
    }

    public int getTextDisplayColumnsNum() {
        return this.textDisplayColumnsNum;
    }

    public int getTextDisplayLinesNum() {
        return this.textDisplayLinesNum;
    }

    public String getKeyMapMKTripleDESData() {
        return this.keyMapMKTripleDESData;
    }

    public String getKeyMapMKTripleDESPin() {
        return this.keyMapMKTripleDESPin;
    }

    public String getKeyMapDUKPTTripleDESData() {
        return this.keyMapDUKPTTripleDESData;
    }

    public String getKeyMapDUKPTripleDESPin() {
        return this.keyMapDUKPTripleDESPin;
    }

    public String getMultimediaFilesSupport() {
        return this.multimediaFilesSupport;
    }

    public String getPinpadCapacity() {
        return this.pinpadCapacity;
    }

    public String getTableVersion() {
        return this.tableVersion;
    }

    public int getRetorno() {
        return this.retorno;
    }

    public void setRetorno(int retorno) {
        this.retorno = retorno;
    }

    public int strResposta2Int(String array, int posIni, int tam) {
        String tmp = array.substring(posIni, tam);
        return Integer.parseInt(tmp);
    }

    public void setRespostaDLL(String strResp) {
        try {
            if (strResp.length() != 0) {
                this.fabricante = strResp.substring(0, 20);
                this.modeloHardware = strResp.substring(20, 39);
                this.suportaContactless = strResp.substring(39, 40).equals(IDENTIFICADOR_SUPORTE_CONTACTLESS);
                this.versaoFirmware = strResp.substring(40, 60);
                this.versaoEspecificacao = strResp.substring(60, 64);
                this.versaoAplBasica = strResp.substring(64, 80);
                this.numSeriePinpad = strResp.substring(80, 100);
            } else {
                this.logger.warn("Buffer GetInfoEMV em branco");
            }
        }
        catch (Throwable t) {
            this.logger.error("Nao foi possivel montar SaidaGetInfoEMV BC: " + t.getMessage());
        }
    }

    public void setRespostaDLLAbecs(byte[] resp) {
        try {
            if (resp.length != 0) {
                this.fabricante = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_MNNAME, resp);
                this.modeloHardware = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_MODEL, resp);
                this.versaoFirmware = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_SOVER, resp);
                this.versaoEspecificacao = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_SPECVER, resp);
                this.versaoAplBasica = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_MANVERS, resp);
                this.numSeriePinpad = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_SERNUM, resp);
                this.parseGraphicDisplayTags(resp);
                this.multimediaFilesSupport = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_MFSUP, resp);
                this.pinpadCapacity = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_CAPAB, resp);
                this.suportaContactless = this.pinpadCapacity != null ? this.pinpadCapacity.startsWith("1") : false;
                this.textDisplayColumnsNum = Integer.valueOf(ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_DSPTXTSZ, resp).substring(2));
                this.textDisplayLinesNum = Integer.valueOf(ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_DSPTXTSZ, resp).substring(0, 2));
                this.keyMapMKTripleDESData = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_MKTDESP, resp);
                this.keyMapMKTripleDESPin = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_MKTDESD, resp);
                this.keyMapDUKPTTripleDESData = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_DKPTTDESP, resp);
                this.keyMapDUKPTripleDESPin = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_DKPTTDESD, resp);
                this.tableVersion = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_TABVER00, resp);
            } else {
                this.logger.warn("Buffer 'SaidaGetInfoEMV' em branco!");
            }
        }
        catch (Throwable t) {
            this.logger.error("Nao foi possivel montar SaidaGetInfoEMV ABECS: " + t.getMessage());
        }
    }

    private void parseGraphicDisplayTags(byte[] resp) {
        String graphicDisplayTag = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_DSPGRSZ, resp);
        if (graphicDisplayTag == null) {
            return;
        }
        try {
            this.graphicDisplayColumnsNum = Integer.parseInt(graphicDisplayTag.substring(0, 4));
            this.graphicDisplayLinesNum = Integer.parseInt(graphicDisplayTag.substring(4));
        }
        catch (NumberFormatException e) {
            this.logger.info("Nao foi possivel ler o valor do tag PP_DSPGRSZ: " + e.getMessage());
        }
    }

    public String toString() {
        return String.format("retorno=%d, fabricante=%s, modeloHardware=%s, versaoFirmware=%s, versaoEspecificacao=%s, versaoAplBasica=%s, numSeriePinpad=%s versaoEspecificacao=%s, suportaContactless=%b, graphicDisplayColumnsNum=%d, graphicDisplayLinesNum=%d, multimediaFilesSupport=%s, pinpadCapacity=%s, textDisplayColumnsNum=%d, textDisplayLinesNum=%d, keyMapMKTripleDESData=%s, keyMapMKTripleDESPin=%s, keyMapDUKPTTripleDESData=%s, keyMapDUKPTripleDESPin=%s, tableVersion=%s", this.retorno, this.fabricante, this.modeloHardware, this.versaoFirmware, this.versaoEspecificacao, this.versaoAplBasica, this.numSeriePinpad, this.versaoEspecificacao, this.suportaContactless, this.graphicDisplayColumnsNum, this.graphicDisplayLinesNum, this.multimediaFilesSupport, this.pinpadCapacity, this.textDisplayColumnsNum, this.textDisplayLinesNum, this.keyMapMKTripleDESData, this.keyMapMKTripleDESPin, this.keyMapDUKPTTripleDESData, this.keyMapDUKPTripleDESPin, this.tableVersion);
    }
}

