/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.emv;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.devices.emv.ConstantesAbecs;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloAbecs;
import com.csi.ctfclient.tools.util.ByteUtil;
import com.csi.ctfclient.tools.util.StringUtil;

public class SaidaGoOnChipEMV {
    private AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(Periferico.class);
    private int retorno;
    private char statusAprovacaoTransacao;
    private boolean requerAssinaturaPapel;
    private boolean pinVerificadoOffline;
    private int numApresentacoesInvalidasPinOff;
    private boolean pinOfflineBloqueado;
    private boolean pinCapturadoVerificacaoOnline;
    private String pinCapturado;
    private String keySerialNumberKeyCounter;
    private int tamCampo55;
    private String campo55;
    private int tamDadosRestantes;
    private String dadosRestantes;
    private String msgNotify;

    public SaidaGoOnChipEMV() {
    }

    public SaidaGoOnChipEMV(int retorno, char[] resposta, char[] msgNotify) {
        this.setRetorno(retorno);
        this.setRespostaDLL(new String(resposta));
        this.setMsgNotify(new String(msgNotify));
    }

    public SaidaGoOnChipEMV(int retorno, char decisao, boolean requerAssinaturaPapel, boolean pinVerificadoOffline, int numApresentacoesInvalidasPinOff, boolean pinOfflineBloqueado, boolean pinCapturadoVerificacaoOnline, String pinCapturado, String keySerialNumberKeyCounter, int tamCampo55, String campo55, int tamDadosRestantes, String dadosRestantes) {
        this.retorno = retorno;
        this.statusAprovacaoTransacao = decisao;
        this.requerAssinaturaPapel = requerAssinaturaPapel;
        this.pinVerificadoOffline = pinVerificadoOffline;
        this.numApresentacoesInvalidasPinOff = numApresentacoesInvalidasPinOff;
        this.pinOfflineBloqueado = pinOfflineBloqueado;
        this.pinCapturadoVerificacaoOnline = pinCapturadoVerificacaoOnline;
        this.pinCapturado = pinCapturado;
        this.keySerialNumberKeyCounter = keySerialNumberKeyCounter;
        this.tamCampo55 = tamCampo55;
        this.campo55 = campo55;
        this.tamDadosRestantes = tamDadosRestantes;
        this.dadosRestantes = dadosRestantes;
    }

    public char getStatusAprovacaoTransacao() {
        return this.statusAprovacaoTransacao;
    }

    public boolean getRequerAssinaturaPapel() {
        return this.requerAssinaturaPapel;
    }

    public boolean getPinVerificadoOffline() {
        return this.pinVerificadoOffline;
    }

    public int getNumApresentacoesInvalidasPinOff() {
        return this.numApresentacoesInvalidasPinOff;
    }

    public boolean getPinOfflineBloqueado() {
        return this.pinOfflineBloqueado;
    }

    public boolean getPinCapturadoVerificacaoOnline() {
        return this.pinCapturadoVerificacaoOnline;
    }

    public String getKeySerialNumberKeyCounter() {
        return this.keySerialNumberKeyCounter;
    }

    public int getTamCampo55() {
        return this.tamCampo55;
    }

    public String getCampo55() {
        return this.campo55;
    }

    public String getPinCapturado() {
        return this.pinCapturado;
    }

    public String getDadosRestantes() {
        return this.dadosRestantes;
    }

    public int getTamDadosRestantes() {
        return this.tamDadosRestantes;
    }

    public String getMsgNotify() {
        return this.msgNotify;
    }

    public void setMsgNotify(String msgNotify) {
        this.msgNotify = msgNotify;
    }

    public int getRetorno() {
        return this.retorno;
    }

    public void setRetorno(int retorno) {
        this.retorno = retorno;
    }

    public int strResposta2Int(String array, int posIni, int tam) {
        String tmp = array.substring(posIni, tam);
        return Integer.parseInt(tmp);
    }

    public void setRespostaDLL(String resposta) {
        try {
            if (resposta.length() != 0) {
                this.statusAprovacaoTransacao = resposta.charAt(0);
                this.requerAssinaturaPapel = resposta.charAt(1) == '1';
                this.pinVerificadoOffline = resposta.charAt(2) == '1';
                this.numApresentacoesInvalidasPinOff = resposta.charAt(3) - 48;
                this.pinOfflineBloqueado = resposta.charAt(4) == '1';
                this.pinCapturadoVerificacaoOnline = resposta.charAt(5) == '1';
                this.pinCapturado = resposta.substring(6, 22);
                this.keySerialNumberKeyCounter = resposta.substring(22, 42);
                this.tamCampo55 = Integer.parseInt(resposta.substring(42, 45));
                this.campo55 = resposta.substring(45, 45 + this.tamCampo55 * 2);
                this.tamDadosRestantes = Integer.parseInt(resposta.substring(45 + this.tamCampo55 * 2, 48 + this.tamCampo55 * 2));
                this.dadosRestantes = resposta.substring(48 + this.tamCampo55 * 2);
            }
        }
        catch (Throwable t) {
            this.logger.error("Nao foi possivel montar SaidaGoOnChipEMV BC: " + t.getMessage());
        }
    }

    public void setRespostaDLLAbecs(byte[] resp) {
        try {
            if (resp.length != 0) {
                this.logger.debug("Buffer SaidaGoOnChipEMV: " + StringUtil.byteArrayToSpacedHexStr(resp));
                String goxRes = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_GOXRES, resp);
                if (null == goxRes) {
                    throw new Throwable("ProtocoloAbecs.getValorParam() retornou nulo");
                }
                this.statusAprovacaoTransacao = goxRes.charAt(0);
                this.requerAssinaturaPapel = goxRes.charAt(1) == '1';
                this.pinVerificadoOffline = goxRes.charAt(2) == '1';
                this.pinCapturadoVerificacaoOnline = goxRes.charAt(2) == '2';
                this.numApresentacoesInvalidasPinOff = 0;
                this.pinOfflineBloqueado = false;
                this.pinCapturado = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_PINBLK, resp);
                if (this.pinCapturado != null) {
                    this.pinCapturado = StringUtil.byteArrayToHexString(StringUtil.stringToByteArray(this.pinCapturado));
                }
                this.keySerialNumberKeyCounter = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_KSN, resp);
                if (this.keySerialNumberKeyCounter != null) {
                    this.keySerialNumberKeyCounter = StringUtil.byteArrayToHexString(StringUtil.stringToByteArray(this.keySerialNumberKeyCounter));
                }
                this.campo55 = ProtocoloAbecs.getValorParam(ConstantesAbecs.PP_EMVDATA, resp);
                if (this.campo55 != null) {
                    this.campo55 = ByteUtil.byteArrayToHex(StringUtil.stringToByteArray(this.campo55));
                    this.tamCampo55 = this.campo55.length() / 2;
                } else {
                    this.tamCampo55 = 0;
                }
                this.tamDadosRestantes = 0;
            } else {
                this.logger.warn("Buffer 'SaidaGoOnChipEMV' em branco!");
            }
        }
        catch (Throwable t) {
            this.logger.error("Nao foi possivel montar SaidaGoOnChipEMV ABECS: " + t.getMessage());
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder(String.format("retorno=%s, statusAprovacaoTransacao=%s, requerAssinaturaPapel=%s, pinVerificadoOffline=%s, numApresentacoesInvalidasPinOff=%s, pinOfflineBloqueado=%s, pinCapturadoVerificacaoOnline=%s, tamCampo55=%s, tamDadosRestantes=%s, msgNotify=%s", this.retorno, Character.valueOf(this.statusAprovacaoTransacao), this.requerAssinaturaPapel, this.pinVerificadoOffline, this.numApresentacoesInvalidasPinOff, this.pinOfflineBloqueado, this.pinCapturadoVerificacaoOnline, this.tamCampo55, this.tamDadosRestantes, this.msgNotify));
        if (this.keySerialNumberKeyCounter != null) {
            result.append(", keySerialNumberKeyCounter.length=").append(this.keySerialNumberKeyCounter.length());
        }
        return result.toString();
    }
}

