/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.emvfull;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.InvalidDataException;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.ConstantesEMV;
import com.csi.ctfclient.tools.devices.emv.DadoSolicitaPin;
import com.csi.ctfclient.tools.devices.emv.DadosGetInfoRedeEMV;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaCheckEventEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaEncryptBufferEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaFinishChipEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGenericCmdEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetClearData;
import com.csi.ctfclient.tools.devices.emv.SaidaGetDUKPTEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoRedecardEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoVisanetEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetPinEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetTracks;
import com.csi.ctfclient.tools.devices.emv.SaidaGoOnChipEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaRemoveCardEMV;
import com.csi.ctfclient.tools.devices.emvfull.GenericPinpadController;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloAbecs;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.devices.events.EventBuilder;
import com.csi.ctfclient.tools.util.StringUtil;
import java.util.Vector;

public class BibliotecaPinpad
extends PinEMV
implements Runnable,
ConstantesEMV {
    public static final int BIBLIOTECA_EMV = 1;
    public static final int BIBLIOTECA_AUTTAR_EMV = 2;
    private final GenericPinpadController protocolo;
    Thread pinThread;
    private boolean emLeitura;

    public BibliotecaPinpad(String serial, String msgPrompt, String msgSenha, String msgAguardo) throws ExcecaoPerifericos {
        this.setMsgPrompt(msgPrompt);
        this.setMsgAguardo(msgAguardo);
        this.protocolo = GenericPinpadController.getInstance(serial);
    }

    public BibliotecaPinpad(String serial, String msgPrompt) throws ExcecaoPerifericos {
        this.setMsgPrompt(msgPrompt);
        this.protocolo = GenericPinpadController.getInstance(serial);
    }

    public static String formatReadTagCommand(int network, int function, String cardTag) throws ExcecaoApiAc {
        if (network != 4 && network != 3) {
            throw new ExcecaoApiAc("BP01", "Apenas \u00e9 poss\u00edvel ler as tags para as redes 3 e 4", "rede = " + network);
        }
        StringBuilder command = new StringBuilder();
        command.append(String.format("%02d", network));
        String commandData = network == 4 ? String.format("%02d%03d%s", function, cardTag.length() / 2, cardTag) : String.format("%02d%s", function, cardTag);
        command.append(String.format("%03d%s", commandData.length(), commandData));
        return command.toString();
    }

    @Override
    public boolean isLeitura() {
        return this.emLeitura;
    }

    @Override
    public void setMsgDisplay(String msg) throws ExcecaoPerifericos {
        if (!this.getHabilitado()) {
            this.protocolo.openCommunication();
        }
        this.protocolo.display(msg.toCharArray());
    }

    @Override
    public String getKey() {
        return this.getWorkingKey();
    }

    @Override
    public void desabilita() throws ExcecaoPerifericos {
        this.setHabilitado(false);
    }

    public synchronized void desabilita(boolean liberaBBComp) throws ExcecaoPerifericos {
        this.logger.debug("desabilita periferico");
        this.setHabilitado(false);
        this.protocolo.closeConnection(liberaBBComp, this.getMsgPrompt().toCharArray());
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            this.logger.info("Espera para desabilitar o pinpad interrompido: " + e.getMessage());
        }
        this.notifyAll();
    }

    @Override
    public synchronized void habilita() throws ExcecaoPerifericos {
        this.logger.debug(this.getClass().getName() + " -> Habilitando periferico...");
        this.protocolo.openCommunication();
        this.setHabilitado(true);
        this.logger.debug(this.getClass().getName() + " -> Periferico habilitado!");
        this.pinThread = new Thread(this);
        this.pinThread.start();
        this.notifyAll();
    }

    @Override
    public synchronized void liberaRecursos() throws ExcecaoPerifericos {
        if (this.protocolo != null && this.protocolo.isCommunicationOpened()) {
            this.desabilita(true);
        }
    }

    public synchronized void liberaRecursos(boolean liberaBBComp) throws ExcecaoPerifericos {
        if (this.protocolo != null && (this.protocolo.isCommunicationOpened() || this.protocolo.isBcOpened())) {
            this.desabilita(liberaBBComp);
        }
    }

    @Override
    public String getDUKPT(int modoCriptografia, int indMKey) throws ExcecaoPerifericos {
        this.protocolo.openCommunication();
        String cmdGetDUKPT = StringUtil.sprintf("%d%02d", new Object[]{modoCriptografia, indMKey});
        SaidaGetDUKPTEMV result = this.protocolo.getDUKPT(cmdGetDUKPT.toCharArray());
        ProtocoloBibliotecaCompartilhada.validateReturn(result.getRetorno(), "getDUKPT");
        return result.getKeySerialNumber();
    }

    @Override
    public String getTimeStampTabelas() throws ExcecaoPerifericos {
        this.protocolo.openCommunication();
        return this.protocolo.getTableVersionPinpad();
    }

    public String encryptBuffer(int tipoCriptografia, int indiceMasterKey, String workingKey, String dados) throws ExcecaoPerifericos {
        this.protocolo.openCommunication();
        SaidaEncryptBufferEMV saida = this.protocolo.encryptBuffer(tipoCriptografia, indiceMasterKey, workingKey, dados);
        ProtocoloBibliotecaCompartilhada.validateReturn(saida.getRetorno(), "encryptBuffer");
        return saida.getDadosCriptografados();
    }

    private void executaLeitura() {
        this.emLeitura = true;
        switch (this.cmdLeitura) {
            case 1: {
                this.esperaGoOnChip();
                break;
            }
            case 3: {
                this.esperaGetKey();
                break;
            }
            case 4: {
                this.esperaGenericCommand();
                break;
            }
            default: {
                this.esperaGetPin();
            }
        }
        this.emLeitura = false;
    }

    @Override
    public void run() {
        this.executaLeitura();
    }

    private char[] parmsGetPin() {
        Vector<Object> v = this.getParmsPedido();
        StringBuilder dados = new StringBuilder("" + v.size());
        for (int i = 0; i < v.size(); ++i) {
            dados.append(StringUtil.sprintf("%02d%02d%-32s", new Object[]{((DadoSolicitaPin)v.elementAt(i)).getTamMin(), ((DadoSolicitaPin)v.elementAt(i)).getTamMax(), ((DadoSolicitaPin)v.elementAt(i)).getMensagemSolicitacao()}));
        }
        this.resetParms();
        String numeroCartao = this.getNumeroCartaoCripto() != null && this.getNumeroCartaoCripto().trim().length() > 0 ? this.getNumeroCartaoCripto() : this.getNumeroCartao();
        String cmdGetPin = StringUtil.sprintf("%d%02d%-32s%02d%-19s%s", new Object[]{this.getTipoCriptografia(), this.getIndiceMasterKey(), this.getWorkingKey(), numeroCartao.trim().length(), numeroCartao, dados.toString()});
        return cmdGetPin.toCharArray();
    }

    private char[] parmsGetGenericCommand() throws ExcecaoApiAc {
        String cmdGetGenericCommand = this.hasReadTagData() ? BibliotecaPinpad.formatReadTagCommand(this.getTagNetwork(), this.getTagFunction(), this.getTagIndex()) : this.getBufferGenericCommand();
        return cmdGetGenericCommand.toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeCard(String msg) throws ExcecaoPerifericos {
        SaidaRemoveCardEMV result;
        try {
            this.protocolo.openCommunication();
            int retorno = this.protocolo.startRemoveCard(StringUtil.completaString(msg, 32, ' ', false).toCharArray());
            ProtocoloBibliotecaCompartilhada.validateReturn(retorno, "startRemoveCard");
            do {
                result = this.protocolo.removeCard();
                ProtocoloBibliotecaCompartilhada.validateReturn(result.getRetorno(), "removeCard");
                if (result.getRetorno() != 2 || result.getMsgNotify() == null || result.getMsgNotify().trim().length() <= 0) continue;
                this.eventoOcorrido(EventBuilder.buildMessageEvent(this, result.getMsgNotify()));
            } while (result.getRetorno() == 1 || result.getRetorno() == 2);
        }
        finally {
            int abort = this.protocolo.abort();
            this.logger.debug("Chamando abort na removeCard = " + abort);
        }
        ProtocoloBibliotecaCompartilhada.validateReturn(result.getRetorno(), "removeCard");
    }

    private synchronized void esperaGetPin() {
        try {
            SaidaGetPinEMV result;
            String functionName;
            int retorno;
            ProtocoloAbecs abecsProtocol;
            if (!this.getHabilitado()) {
                return;
            }
            if (this.protocolo instanceof ProtocoloAbecs && !this.isCapturaSenha()) {
                abecsProtocol = (ProtocoloAbecs)this.protocolo;
                DadoSolicitaPin dado = (DadoSolicitaPin)this.getParmsPedido().get(0);
                retorno = abecsProtocol.startGetClearData(ProtocoloAbecs.buildGetClearDataParameters(dado));
                ProtocoloBibliotecaCompartilhada.validateReturn(retorno, "startGetClearData");
                functionName = "getClearData";
            } else {
                retorno = this.protocolo.startGetPIN(this.parmsGetPin());
                ProtocoloBibliotecaCompartilhada.validateReturn(retorno, "startGetPin");
                functionName = "getPin";
            }
            do {
                if (!this.getHabilitado()) {
                    int abort = this.protocolo.abort();
                    this.logger.info("retorno " + functionName + ": abort = " + abort);
                    return;
                }
                if (this.protocolo instanceof ProtocoloAbecs && !this.isCapturaSenha()) {
                    abecsProtocol = (ProtocoloAbecs)this.protocolo;
                    SaidaGetClearData saidaGCD = abecsProtocol.getClearData();
                    String keySN = "                    ";
                    result = new SaidaGetPinEMV(saidaGCD.getRetorno(), saidaGCD.getValor(), keySN);
                    result.setRetorno(saidaGCD.getRetorno());
                    this.logger.info("Retorno 'getClearData()': " + result.getRetorno());
                } else {
                    result = this.protocolo.getPin();
                    this.logger.info("Retorno 'getPin()': " + result.getRetorno());
                }
                if (!this.emLeitura) {
                    this.logger.debug("ABORT 'esperaGetPin()'!");
                    result = new SaidaGetPinEMV();
                    result.setRetorno(13);
                    break;
                }
                this.logger.info("retorno " + functionName + " = " + result.getRetorno());
                if (result.getRetorno() != 2) continue;
                this.eventoOcorrido(EventBuilder.buildMessageEvent(this, result.getMsgNotify()));
            } while ((result.getRetorno() == 1 || result.getRetorno() == 2) && this.getHabilitado());
            if (this.getHabilitado()) {
                this.setHabilitado(false);
                this.eventoOcorrido(EventBuilder.buildPinEvent(this, result.getRetorno() == 13, result.getRetorno() != 13 && result.getRetorno() != 0, result.getRetorno(), this.getTipoCriptografia(), result));
            }
        }
        catch (InvalidDataException | ExcecaoPerifericos e) {
            this.setHabilitado(false);
            this.logger.error("Erro em 'esperaGetPin()': " + e.getMessage());
            this.eventoOcorrido(EventBuilder.buildPinEvent(this, false, true, 999, this.getTipoCriptografia(), null));
        }
    }

    private synchronized void esperaGetKey() {
        try {
            int result;
            if (!this.getHabilitado()) {
                return;
            }
            if (this.protocolo.isPinpadAbecs()) {
                int retorno = this.startCheckEvent();
                ProtocoloBibliotecaCompartilhada.validateReturn(retorno, "startCheckEvent");
            } else {
                int retorno = this.protocolo.startGetKey();
                ProtocoloBibliotecaCompartilhada.validateReturn(retorno, "startGetKey");
            }
            do {
                if (!this.getHabilitado()) {
                    int abort = this.protocolo.abort();
                    this.logger.info("retorno getKey: abort = " + abort);
                    return;
                }
                if (this.protocolo.isPinpadAbecs()) {
                    SaidaCheckEventEMV saidaCEX = this.protocolo.checkEvent();
                    result = saidaCEX.getRetorno();
                    if (result == 0) {
                        result = Integer.parseInt(saidaCEX.getKeyboardEvent().getKey());
                    }
                } else {
                    result = this.protocolo.getKey();
                }
                this.logger.debug("Em 'esperaGetKey()'.");
                if (!this.emLeitura) {
                    this.logger.debug("Abort 'esperaGetKey()'!");
                    result = 13;
                    break;
                }
                this.logger.info("retorno getKey = " + result);
            } while ((result == 1 || result == 2) && this.getHabilitado());
            if (this.getHabilitado()) {
                this.setHabilitado(false);
                this.eventoOcorrido(EventBuilder.buildKeyEvent(this, result == 13, result != 13 && result != 0 && result != 4 && result != 5 && result != 6 && result != 7 && result != 8, result, this.getTipoCriptografia()));
            }
        }
        catch (ExcecaoPerifericos e) {
            this.setHabilitado(false);
            this.eventoOcorrido(EventBuilder.buildPinEvent(this, false, true, 999, this.getTipoCriptografia(), null));
        }
        finally {
            this.setHabilitado(false);
        }
    }

    private synchronized void esperaGenericCommand() {
        try {
            SaidaGenericCmdEMV result;
            if (!this.getHabilitado()) {
                return;
            }
            int retorno = this.protocolo.startGenericCmd(this.parmsGetGenericCommand());
            ProtocoloBibliotecaCompartilhada.validateReturn(retorno, "startGetGenericCommand");
            do {
                if (!this.getHabilitado()) {
                    int abort = this.protocolo.abort();
                    this.logger.info("retorno genericCommand: abort = " + abort);
                    return;
                }
                result = this.protocolo.genericCmd();
                if (!this.emLeitura) {
                    this.logger.debug("Abort 'esperaGenericCommand()'!");
                    result = new SaidaGenericCmdEMV();
                    result.setRetorno(13);
                    break;
                }
                this.logger.info("Retorno 'genericCommand()': " + result.getRetorno());
                if (result.getRetorno() != 2) continue;
                this.eventoOcorrido(EventBuilder.buildMessageEvent(this, result.getMsgNotify()));
            } while ((result.getRetorno() == 1 || result.getRetorno() == 2) && this.getHabilitado());
            if (this.getHabilitado()) {
                this.setHabilitado(false);
                this.eventoOcorrido(EventBuilder.buildGenericCommandEvent(this, result.getRetorno() == 13, result.getRetorno() != 13 && result.getRetorno() != 0, result.getRetorno(), result));
            }
        }
        catch (ExcecaoApiAc e) {
            this.setHabilitado(false);
            this.logger.error("Erro em 'esperaGenericCommand': " + e.getMessage());
            this.eventoOcorrido(EventBuilder.buildPinEvent(this, false, true, 999, this.getTipoCriptografia(), null));
        }
    }

    private synchronized void esperaGoOnChip() {
        try {
            SaidaGoOnChipEMV result;
            if (!this.getHabilitado()) {
                return;
            }
            int retorno = this.protocolo.startGoOnChip(this);
            ProtocoloBibliotecaCompartilhada.validateReturn(retorno, "startGoOnChip");
            do {
                if (!this.getHabilitado()) {
                    int abort = this.protocolo.abort();
                    this.logger.info("retorno goOnChip: abort = " + abort);
                    return;
                }
                result = this.protocolo.goOnChip();
                this.logger.debug("Em 'esperaGoOnChip()'...");
                if (!this.emLeitura) {
                    this.logger.debug("ABORT 'esperaGoOnChip()'!!!");
                    result = new SaidaGoOnChipEMV();
                    result.setRetorno(13);
                    break;
                }
                this.logger.info("retorno goOnChip = " + result.getRetorno());
                if (result.getRetorno() != 2) continue;
                this.logger.debug("Notify 'GoOnChip': " + result.getRetorno() + " - " + result.getMsgNotify() + ".");
                this.eventoOcorrido(EventBuilder.buildMessageEvent(this, result.getMsgNotify()));
            } while ((result.getRetorno() == 1 || result.getRetorno() == 2) && this.getHabilitado());
            if (this.getHabilitado()) {
                this.setHabilitado(false);
                this.eventoOcorrido(EventBuilder.buildReadChipEvent(this, result.getRetorno() == 13, result.getRetorno() != 13 && result.getRetorno() != 0, result.getRetorno(), this.getTipoCriptografia(), result));
            }
        }
        catch (ExcecaoPerifericos e) {
            this.logger.error("Erro em 'esperaGoOnChip()': " + e.getMessage());
            this.setHabilitado(false);
            this.eventoOcorrido(EventBuilder.buildReadChipEvent(this, false, true, 999, this.getTipoCriptografia(), null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SaidaFinishChipEMV finishChip() {
        SaidaFinishChipEMV result;
        try {
            this.emLeitura = true;
            this.setHabilitado(true);
            BibliotecaPinpad bibliotecaPinpad = this;
            synchronized (bibliotecaPinpad) {
                if (!this.getHabilitado()) {
                    throw new ExcecaoPerifericos("BP03", "Pinpad nao habilitado na finish chip.");
                }
                int retorno = this.protocolo.startFinishChip(this);
                ProtocoloBibliotecaCompartilhada.validateReturn(retorno, "startFinishChip");
            }
            do {
                bibliotecaPinpad = this;
                synchronized (bibliotecaPinpad) {
                    if (!this.getHabilitado()) {
                        this.protocolo.abort();
                        this.logger.info("retorno startFinishChip = abort");
                        throw new ExcecaoPerifericos("BP04", "Pinpad nao habilitado na finish chip.");
                    }
                    result = this.protocolo.finishChip();
                    this.logger.debug("Em 'esperafinishChip()'...");
                    if (!this.emLeitura) {
                        this.logger.debug("ABORT 'esperafinishChip()'!!!");
                        result = new SaidaFinishChipEMV();
                        result.setRetorno(13);
                        break;
                    }
                }
                ProtocoloBibliotecaCompartilhada.validateReturn(result.getRetorno(), "finishChip");
                if (result.getRetorno() != 2) continue;
                this.logger.debug("Notify 'finishChip': " + result.getRetorno() + " - " + result.getMsgNotify() + ".");
                this.eventoOcorrido(EventBuilder.buildMessageEvent(this, result.getMsgNotify()));
            } while ((result.getRetorno() == 1 || result.getRetorno() == 2) && this.getHabilitado());
        }
        catch (ExcecaoPerifericos e) {
            this.logger.error("Erro em 'esperafinishChip()'!", e);
            result = new SaidaFinishChipEMV();
            result.setRetorno(900);
        }
        finally {
            this.emLeitura = false;
            this.setHabilitado(false);
        }
        return result;
    }

    @Override
    public SaidaGetInfoEMV getInfo() throws ExcecaoPerifericos {
        this.protocolo.openCommunication();
        SaidaGetInfoEMV result = this.protocolo.getInfoEMV();
        ProtocoloBibliotecaCompartilhada.validateReturn(result.getRetorno(), "getInfoEMV");
        return result;
    }

    @Override
    public SaidaGetInfoVisanetEMV getInfoVisanet() {
        SaidaGetInfoVisanetEMV result;
        try {
            this.protocolo.openCommunication();
            result = this.protocolo.getInfoCieloEMV();
            ProtocoloBibliotecaCompartilhada.validateReturn(result.getRetorno(), "getInfoCieloEMV");
        }
        catch (Exception e) {
            this.logger.warn("Erro em getInfoVisanet: " + e.getMessage());
            result = null;
        }
        return result;
    }

    @Override
    public SaidaGetInfoRedecardEMV getInfoRedecard() throws ExcecaoPerifericos {
        SaidaGetInfoRedecardEMV result;
        try {
            this.protocolo.openCommunication();
            result = this.protocolo.getInfoRedecardEMV();
            ProtocoloBibliotecaCompartilhada.validateReturn(result.getRetorno(), "getInfoRedecardEMV");
            this.protocolo.display(this.getMsgPrompt().toCharArray());
        }
        catch (Exception e) {
            this.logger.warn("Erro em getInfoRedecard: " + e.getMessage());
            result = null;
        }
        return result;
    }

    @Override
    public DadosGetInfoRedeEMV getInfoRedeEMV(int rede) {
        DadosGetInfoRedeEMV result;
        try {
            this.protocolo.openCommunication();
            result = this.protocolo.getInfoAcquire(rede);
            String function = String.format("getInfoRedeEMV(%d)", rede);
            ProtocoloBibliotecaCompartilhada.validateReturn(result.getRetorno(), function);
        }
        catch (Exception e) {
            this.logger.warn("Erro em getInfoRedeEMV: " + e.getMessage());
            result = null;
        }
        return result;
    }

    @Override
    public int changeParameter(String parametrosTLV) throws ExcecaoPerifericos {
        this.protocolo.openCommunication();
        int retorno = this.protocolo.changeParameter(parametrosTLV.toCharArray());
        ProtocoloBibliotecaCompartilhada.validateReturn(retorno, "changeParameter");
        return retorno;
    }

    @Override
    public SaidaGetTracks getTracks(String tracks, String cryptoType, Integer keyIndex, String workingKey) {
        if (!(this.protocolo instanceof ProtocoloAbecs)) {
            return null;
        }
        return ((ProtocoloAbecs)this.protocolo).getTracks(tracks, cryptoType, keyIndex, workingKey);
    }

    @Override
    public SaidaGetClearData getClearData() {
        try {
            if (!(this.protocolo instanceof ProtocoloAbecs)) {
                return null;
            }
            this.protocolo.openCommunication();
            SaidaGetClearData result = ((ProtocoloAbecs)this.protocolo).getClearData();
            ProtocoloBibliotecaCompartilhada.validateReturn(result.getRetorno(), "getClearData");
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public int startCheckEvent() {
        try {
            this.protocolo.openCommunication();
            int result = this.protocolo.startCheckEvent(1, 0, 0, 0);
            this.logger.info("Retorno 'startCheckEvent()': " + result);
            return result;
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    public SaidaCheckEventEMV checkEvent() {
        try {
            this.protocolo.openCommunication();
            SaidaCheckEventEMV result = this.protocolo.checkEvent();
            this.logger.info("Retorno 'checkEvent()': " + result);
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isPinpadAbecs() {
        return this.protocolo.isPinpadAbecs();
    }
}

