/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.emvfull;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.EMVResponseCode;
import br.com.auttar.util.exceptions.PinpadOpenException;
import br.com.auttar.util.factories.PinpadDriverFactory;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.DadosGetInfoRedeEMV;
import com.csi.ctfclient.tools.devices.emv.LeitorCartao;
import com.csi.ctfclient.tools.devices.emv.SaidaCheckEventEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaEncryptBufferEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaFinishChipEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGenericCmdEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetCardEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetCardQualidade;
import com.csi.ctfclient.tools.devices.emv.SaidaGetDUKPTEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoRedecardEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoVisanetEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetPinEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetTimeStampEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGoOnChipEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaRemoveCardEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaCompartilhadaHandler;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.devices.emvfull.KeyFactory;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public abstract class GenericPinpadController {
    protected static final char[] BC_VERSION = "0100".toCharArray();
    protected static final char[] ABECS_VERSION = "0200".toCharArray();
    private static final String HANDLER_DEFAULT = "com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhadaC";
    private static GenericPinpadController instance = null;
    private static boolean secureCommunication = false;
    private static int bcType = 1;
    private static int timeoutPinDefault = 0;
    private static int timeoutPinBlocking = 0;
    private static int timeoutPinNoblocking = 0;
    private static String handler = null;
    private static String wkpan;
    protected final BibliotecaCompartilhadaHandler pinpad;
    private final String serialPort;
    private final Map<Integer, DadosGetInfoRedeEMV> mapGetInfoRedeEMV = new HashMap<Integer, DadosGetInfoRedeEMV>();
    protected AuttarLogger logger;
    protected SaidaGetInfoEMV saidaGetInfoEMV = null;
    private boolean serialOpened = false;
    private boolean bcOpened;
    private String tableVersionPinpad;
    private boolean communicationOpened = false;
    private SaidaGetInfoVisanetEMV saidaGetInfoCielo = null;
    private SaidaGetInfoRedecardEMV saidaGetInfoRedecard = null;

    protected GenericPinpadController(String serialPort, String handler, AuttarLogger logger) throws ExcecaoPerifericos {
        this.serialPort = serialPort;
        try {
            this.pinpad = (BibliotecaCompartilhadaHandler)Class.forName(handler).newInstance();
        }
        catch (Exception e) {
            throw new ExcecaoPerifericos("GPC05", "Erro na construcao do driver do pinpad", e);
        }
        this.logger = logger;
    }

    protected GenericPinpadController(GenericPinpadController other) {
        this.pinpad = other.pinpad;
        this.serialPort = other.serialPort;
        this.saidaGetInfoEMV = other.saidaGetInfoEMV;
        this.serialOpened = other.serialOpened;
        this.bcOpened = other.bcOpened;
        this.tableVersionPinpad = other.tableVersionPinpad;
        this.communicationOpened = other.communicationOpened;
        this.saidaGetInfoCielo = other.saidaGetInfoCielo;
        this.saidaGetInfoRedecard = other.saidaGetInfoRedecard;
        this.logger = other.logger;
    }

    public static GenericPinpadController getInstance(String port, boolean openCommunication) throws ExcecaoPerifericos {
        if (instance != null && GenericPinpadController.instance.serialPort != null) {
            return instance;
        }
        if (handler == null) {
            handler = HANDLER_DEFAULT;
        }
        instance = PinpadDriverFactory.buildDriver(port, handler, openCommunication);
        return instance;
    }

    protected static AuttarLogger getLogger(Class c) {
        return CTFClientCore.getAuttarLoggerFactory().getLogger(c);
    }

    public static GenericPinpadController getInstance(String port) throws ExcecaoPerifericos {
        return GenericPinpadController.getInstance(port, true);
    }

    public static void setHandler(String handler) {
        GenericPinpadController.handler = handler;
    }

    public static int getBcType() {
        return bcType;
    }

    public static void setBcType(int bcType) {
        AuttarLogger logger = GenericPinpadController.getLogger(GenericPinpadController.class);
        if (bcType == 1) {
            logger.info("CTFClient configurado para biblioteca de pinpad EMV");
        } else if (bcType == 2) {
            logger.info("CTFClient configurado para biblioteca de pinpad Auttar");
        }
        GenericPinpadController.bcType = bcType;
    }

    public static boolean isSecureCommunication() {
        return secureCommunication;
    }

    public static void setSecureCommunication(boolean secureCommunication) {
        AuttarLogger logger = GenericPinpadController.getLogger(GenericPinpadController.class);
        if (secureCommunication) {
            logger.info("Criptografia do PAN habilitada na comunica\u00e7\u00e3o com o PINPAD (BC)");
        } else {
            logger.info("Criptografia do PAN n\u00e3o habilitada na comunica\u00e7\u00e3o com o PINPAD (BC)");
        }
        GenericPinpadController.secureCommunication = secureCommunication;
    }

    public static void setTimeoutPin(int timeoutPinDefault, int timeoutPinBlocking, int timeoutPinNoblocking) {
        AuttarLogger logger = GenericPinpadController.getLogger(GenericPinpadController.class);
        logger.info("Timeout default do pin configurado para " + timeoutPinDefault);
        GenericPinpadController.timeoutPinDefault = timeoutPinDefault;
        logger.info("Timeout blocking do pin configurado para " + timeoutPinBlocking);
        GenericPinpadController.timeoutPinBlocking = timeoutPinBlocking;
        logger.info("Timeout noblocking do pin configurado para " + timeoutPinNoblocking);
        GenericPinpadController.timeoutPinNoblocking = timeoutPinNoblocking;
    }

    public static String getWkpan() {
        return wkpan;
    }

    protected static void setWkpan(String wkpan) {
        GenericPinpadController.wkpan = wkpan;
    }

    public static String getErrorString(int emvResponseCode) {
        EMVResponseCode enumByKey = EMVResponseCode.getEnumByKey(emvResponseCode);
        if (enumByKey == null) {
            return "Erro indefinido";
        }
        return enumByKey.getCode();
    }

    public static void terminateInstance() {
        instance = null;
    }

    public static void validateReturn(int emvResponseCode, String function) throws ExcecaoPerifericos {
        if (emvResponseCode != EMVResponseCode.PP_OK.getId() && emvResponseCode != EMVResponseCode.PP_PROCESSING.getId() && emvResponseCode != EMVResponseCode.PP_NOTIFY.getId() && emvResponseCode != EMVResponseCode.PP_CANCEL.getId() && emvResponseCode != EMVResponseCode.PP_TABEXP.getId()) {
            AuttarLogger logger = GenericPinpadController.getLogger(GenericPinpadController.class);
            logger.error(String.format("Retorno de %s = %d", function, emvResponseCode));
            throw new ExcecaoPerifericos("GPC00", String.format("Retorno inesperado para %s: %d", function, emvResponseCode), GenericPinpadController.getErrorString(emvResponseCode), emvResponseCode);
        }
    }

    public boolean isBcOpened() {
        return this.bcOpened;
    }

    public String getTableVersionPinpad() {
        return this.tableVersionPinpad;
    }

    public void setTableVersionPinpad(String tableVersionPinpad) {
        this.tableVersionPinpad = tableVersionPinpad;
    }

    public abstract String getTableVersion();

    public abstract char[] getVersion();

    public abstract boolean isPinpadAbecs();

    protected abstract char[] buildGetInfoParameters();

    protected abstract char[] buildStartCheckEventParameters(Integer var1, Integer var2, Integer var3, Integer var4);

    public abstract char[] buildStartGetCardParameters(LeitorCartao var1);

    public abstract char[] buildGoOnChipParameters(BibliotecaPinpad var1);

    public abstract char[] buildMandatoryTags(BibliotecaPinpad var1);

    public abstract char[] buildOptionalTags(BibliotecaPinpad var1);

    public abstract char[] buildFinishChipParameters(BibliotecaPinpad var1);

    public abstract char[] buildStartGenericCommandTag84Parameters(SaidaGetCardEMV var1);

    public abstract char[] buildEncryptBufferParameters(int var1, int var2, String var3, String var4);

    public abstract char[] prepareClosePrompt(char[] var1);

    public boolean isCommunicationOpened() {
        return this.communicationOpened;
    }

    public void setTimeout() {
        this.setPPTimeout(timeoutPinDefault, timeoutPinBlocking, timeoutPinNoblocking);
    }

    public void resetSerial() {
        this.serialOpened = false;
        this.communicationOpened = false;
        this.bcOpened = false;
    }

    public void openCommunication() throws ExcecaoPerifericos {
        if (this.communicationOpened) {
            this.logger.warn("Comunica\u00e7\u00e3o com pinpad j\u00e1 estabelecida");
            return;
        }
        this.setTimeout();
        this.openPinpadSerialConnection();
        this.openPinpadConnection(false);
        if (this.bcOpened) {
            this.loadGetInfoCache();
            this.tableVersionPinpad = this.getTableVersion();
            this.logger.info("Retorno 'getInfo()': " + this.saidaGetInfoEMV.getRetorno());
            this.logger.info("Versao da especificacao no pinpad: '" + this.saidaGetInfoEMV.getVersaoEspecificacao() + "'");
            this.logger.info("Versao das tabelas de AID no pinpad: '" + this.tableVersionPinpad + "'");
            this.logger.info("Comunicacao segura: " + secureCommunication);
            if (secureCommunication) {
                try {
                    BigDecimal versao = new BigDecimal(this.saidaGetInfoEMV.getVersaoEspecificacao());
                    if (versao.compareTo(new BigDecimal("1.07")) >= 0) {
                        secureCommunication = true;
                    }
                    if (versao.compareTo(new BigDecimal("2.00")) > 0) {
                        this.logger.info("Usando comunicacao segura padrao do protocolo ABECS.");
                        secureCommunication = false;
                    }
                }
                catch (Exception e) {
                    this.logger.info("N\u00e3o foi poss\u00edvel identificar a vers\u00e3o. Erro: " + e.getMessage());
                }
            }
            if (!GenericPinpadController.isSecureCommunication()) {
                if (!KeyFactory.isChaveLocal()) {
                    KeyFactory.reset();
                }
            } else {
                this.setupSecureCommunication();
            }
        }
        this.communicationOpened = true;
    }

    public void closeConnection() {
        this.closeConnection(true, "Auttar".toCharArray());
    }

    public void closeConnection(char[] msgPrompt) {
        this.closeConnection(true, msgPrompt);
    }

    public void closeConnection(boolean liberaBBComp, char[] msgPrompt) {
        int retorno;
        msgPrompt = this.prepareClosePrompt(msgPrompt);
        if (liberaBBComp) {
            if (this.isBcOpened() && !this.isCommunicationOpened()) {
                retorno = this.openSerial(this.serialPort.toCharArray());
                this.logger.warn("openSerial necessario. retorno = " + retorno);
            }
            retorno = this.close(msgPrompt);
            this.logger.info("Retorno 'close': " + retorno);
            this.bcOpened = false;
        }
        retorno = this.closeSerial();
        this.logger.info("Retorno 'closeSerial': " + retorno);
        this.communicationOpened = false;
        this.logger.debug("Comunica\u00e7\u00e3o com pinpad finalizada!");
    }

    public void testCommunication() throws ExcecaoPerifericos {
        if (this.communicationOpened) {
            this.logger.warn("comunica\u00e7\u00e3o com pin j\u00e1 estabelecida");
            return;
        }
        this.setTimeout();
        this.openPinpadSerialConnection();
        this.openPinpadConnection(true);
        this.communicationOpened = true;
    }

    public int openSerial(char[] port) {
        return this.openSerial(bcType, port);
    }

    public SaidaGetInfoEMV getInfoEMV() {
        if (this.saidaGetInfoEMV == null) {
            this.saidaGetInfoEMV = this.getInfo(this.buildGetInfoParameters());
        }
        return this.saidaGetInfoEMV;
    }

    public SaidaGetInfoVisanetEMV getInfoCieloEMV() {
        if (this.saidaGetInfoCielo == null) {
            this.saidaGetInfoCielo = this.getInfoVisanet();
        }
        return this.saidaGetInfoCielo;
    }

    public SaidaGetInfoRedecardEMV getInfoRedecardEMV() {
        if (this.saidaGetInfoRedecard == null) {
            this.saidaGetInfoRedecard = this.getInfoRedecard();
        }
        return this.saidaGetInfoRedecard;
    }

    public DadosGetInfoRedeEMV getInfoAcquire(int acquire) {
        Integer acquireInteger = acquire;
        DadosGetInfoRedeEMV saidaGetInfoRedeEMV = this.mapGetInfoRedeEMV.get(acquireInteger);
        if (saidaGetInfoRedeEMV == null) {
            saidaGetInfoRedeEMV = this.getInfoRedeEMV(acquire);
            this.mapGetInfoRedeEMV.put(acquireInteger, saidaGetInfoRedeEMV);
        }
        return saidaGetInfoRedeEMV;
    }

    public int abort() {
        int result = this.pinpad.abort(BC_VERSION);
        this.logger.debug("abort = " + result);
        return result;
    }

    public int display(char[] message) {
        int result = this.pinpad.display(this.getVersion(), message);
        this.logger.debug("display = " + result);
        return result;
    }

    public int startGetCard(char[] input) {
        int result = this.pinpad.startGetCard(this.getVersion(), input);
        this.logger.debug("startGetCard = " + result);
        return result;
    }

    public SaidaGetCardEMV getCard() {
        SaidaGetCardEMV result = this.pinpad.getCard(this.getVersion());
        this.logger.debug("getCard = " + result);
        return result;
    }

    public int tableLoadInit(char[] input) {
        int result = this.pinpad.tableLoadInit(this.getVersion(), input);
        this.logger.debug("tableLoadInit = " + result);
        return result;
    }

    public int tableLoadEnd() {
        int result = this.pinpad.tableLoadEnd(this.getVersion());
        this.logger.debug("tableLoadEnd = " + result);
        return result;
    }

    public int tableLoadRec(char[] input) {
        int result = this.pinpad.tableLoadRec(this.getVersion(), input);
        this.logger.debug("tableLoadRec = " + result);
        return result;
    }

    public int startGenericCmd(char[] input) {
        int result = this.pinpad.startGenericCmd(BC_VERSION, input);
        this.logger.debug("startGenericCmd = " + result);
        return result;
    }

    public SaidaGenericCmdEMV genericCmd() {
        SaidaGenericCmdEMV result = this.pinpad.genericCmd(BC_VERSION);
        this.logger.debug("genericCmd = " + result);
        return result;
    }

    public int startCheckEvent(Integer checkKEY, Integer checkMAG, Integer checkICC, Integer checkCTLS) {
        int result = this.pinpad.startCheckEvent(this.getVersion(), this.buildStartCheckEventParameters(checkKEY, checkMAG, checkICC, checkCTLS));
        this.logger.debug("startCheckEvent = " + result);
        return result;
    }

    public SaidaCheckEventEMV checkEvent() {
        SaidaCheckEventEMV saidaCheckEventEMV = this.pinpad.checkEvent(this.getVersion());
        this.logger.debug("checkEvent = " + saidaCheckEventEMV);
        return saidaCheckEventEMV;
    }

    protected void loadGetInfoCache() {
        this.saidaGetInfoEMV = this.getInfoEMV();
        this.saidaGetInfoCielo = this.getInfoCieloEMV();
        this.saidaGetInfoRedecard = this.getInfoRedecardEMV();
        this.mapGetInfoRedeEMV.put(4, this.getInfoRedeEMV(4));
    }

    protected void clearOutputCache() {
        this.saidaGetInfoEMV = null;
        this.saidaGetInfoCielo = null;
        this.saidaGetInfoRedecard = null;
        this.mapGetInfoRedeEMV.clear();
    }

    protected String getSerialPort() {
        return this.serialPort;
    }

    protected void setupSecureCommunication() throws ExcecaoPerifericos {
    }

    private void openPinpadSerialConnection() throws ExcecaoPerifericos {
        if (this.serialOpened) {
            this.logger.warn("Comunica\u00e7\u00e3o serial com pinpad j\u00e1 estabelecida");
            return;
        }
        int response = this.openSerial(bcType, this.serialPort.toCharArray());
        if (response != 0) {
            throw new ExcecaoPerifericos("GPC01", "Erro ao abrir comunicacao serial com o PINPAD", "response = " + response);
        }
        this.logger.info("Comunicacao serial com o pinpad aberta com sucesso");
        this.serialOpened = true;
    }

    private void openPinpadConnection(boolean isTestConnection) throws ExcecaoPerifericos {
        int response;
        if (!this.serialOpened) {
            this.logger.error("N\u00e3o foi poss\u00edvel abrir comunica\u00e7\u00e3o com pinpad. Comunica\u00e7\u00e3o serial com pinpad n\u00e3o estabelecida");
            throw new ExcecaoPerifericos("GPC03", "Erro comunica\u00e7\u00e3o serial com pinpad n\u00e3o estabelecida");
        }
        if (this.bcOpened) {
            return;
        }
        if (!isTestConnection) {
            this.clearOutputCache();
        }
        if (0 != (response = this.open()) && 3 != response && 14 != response) {
            throw new PinpadOpenException("GPC02", "Erro ao abrir comunica\u00e7\u00e3o com o PINPAD", response);
        }
        this.bcOpened = true;
        if (3 == response && !isTestConnection) {
            throw new PinpadOpenException("GPC04", "Pinpad nao suporta comunicacao segura", response);
        }
        if (14 == response) {
            this.logger.warn("Comunicacao com o pinpad ja foi estabelecida");
        }
        this.logger.info("Comunicacao com o protocolo do pinpad aberta com sucesso");
    }

    protected int openSerial(int tipoBibliotecaPinpad, char[] port) {
        char[] version = this.getVersion();
        int result = this.pinpad.openSerial(version, tipoBibliotecaPinpad, port);
        this.logger.debug(String.format("openSerial(%s, %s, %s) = %s", Arrays.toString(version), tipoBibliotecaPinpad, Arrays.toString(port), result));
        return result;
    }

    protected int open() {
        char[] version = this.getVersion();
        int result = this.pinpad.open(version);
        this.logger.debug(String.format("open(%s) = %s", Arrays.toString(version), result));
        return result;
    }

    protected int close(char[] input) {
        char[] version = this.getVersion();
        int result = this.pinpad.close(version, input);
        this.logger.debug(String.format("close(%s, %s) = %s", Arrays.toString(version), result, Arrays.toString(input)));
        return result;
    }

    protected int closeSerial() {
        char[] version = this.getVersion();
        int response = this.pinpad.closeSerial(version);
        this.logger.debug(String.format("closeSerial(%s) = %s", Arrays.toString(version), response));
        if (response == 0) {
            this.serialOpened = false;
        }
        return response;
    }

    protected int startGetPIN(char[] input) {
        int result = this.pinpad.startGetPIN(this.getVersion(), input);
        this.logger.debug(String.format("startGetPIN = %s", result));
        return result;
    }

    protected int startGoOnChip(BibliotecaPinpad pinpadLibrary) {
        int result = this.pinpad.startGoOnChip(this.getVersion(), this.buildGoOnChipParameters(pinpadLibrary), this.buildMandatoryTags(pinpadLibrary), this.buildOptionalTags(pinpadLibrary));
        this.logger.debug("startGoOnChip = " + result);
        return result;
    }

    protected int startRemoveCard(char[] message) {
        int result = this.pinpad.startRemoveCard(this.getVersion(), message);
        this.logger.debug("startRemoveCard = " + result);
        return result;
    }

    protected int startGetKey() {
        int result = this.pinpad.startGetKey(this.getVersion());
        this.logger.debug("startGetKey = " + result);
        return result;
    }

    protected int getKey() {
        int result = this.pinpad.getKey(this.getVersion());
        this.logger.debug("getKey = " + result);
        return result;
    }

    protected SaidaGoOnChipEMV goOnChip() {
        SaidaGoOnChipEMV result = this.pinpad.goOnChip(this.getVersion());
        this.logger.debug("goOnChip = " + result);
        return result;
    }

    protected int startFinishChip(BibliotecaPinpad pinpadLibrary) {
        int result = this.pinpad.startFinishChip(this.getVersion(), this.buildFinishChipParameters(pinpadLibrary), this.buildMandatoryTags(pinpadLibrary));
        this.logger.debug("startFinishChip = " + result);
        return result;
    }

    protected SaidaFinishChipEMV finishChip() {
        SaidaFinishChipEMV result = this.pinpad.finishChip(this.getVersion());
        this.logger.debug("finishChip = " + result);
        return result;
    }

    protected SaidaGetPinEMV getPin() {
        SaidaGetPinEMV result = this.pinpad.getPin(this.getVersion());
        this.logger.debug("getPin = " + result);
        return result;
    }

    protected SaidaGetDUKPTEMV getDUKPT(char[] input) {
        SaidaGetDUKPTEMV result = this.pinpad.getDUKPT(BC_VERSION, input);
        this.logger.debug("getDUKPT = " + result);
        return result;
    }

    public SaidaEncryptBufferEMV encryptBuffer(int encryptationType, int masterKeyIndex, String workingKey, String data) {
        if (this.isPinpadAbecs()) {
            return this.encryptBuffer(this.buildEncryptBufferParameters(encryptationType, masterKeyIndex, workingKey, data));
        }
        return this.encryptBuffer2(encryptationType, masterKeyIndex, workingKey.toCharArray(), data.toCharArray());
    }

    protected SaidaEncryptBufferEMV encryptBuffer(char[] input) {
        SaidaEncryptBufferEMV result = this.pinpad.encryptBuffer(this.getVersion(), input);
        this.logger.debug("encryptBuffer = " + result);
        return result;
    }

    protected SaidaEncryptBufferEMV encryptBuffer2(int encryptationType, int masterKeyIndex, char[] workingKey, char[] data) {
        SaidaEncryptBufferEMV result = this.pinpad.encryptBuffer2(this.getVersion(), encryptationType, masterKeyIndex, workingKey, data);
        this.logger.debug("encryptBuffer2 = " + result);
        return result;
    }

    protected SaidaGetInfoEMV getInfo(char[] input) {
        SaidaGetInfoEMV result = this.pinpad.getInfo(this.getVersion(), input);
        this.logger.debug("getInfo = " + result);
        return result;
    }

    protected SaidaGetInfoVisanetEMV getInfoVisanet() {
        SaidaGetInfoVisanetEMV result = this.pinpad.getInfoVisanet(BC_VERSION);
        this.logger.debug("getInfoVisanet = " + result);
        return result;
    }

    protected SaidaGetInfoRedecardEMV getInfoRedecard() {
        SaidaGetInfoRedecardEMV result = this.pinpad.getInfoRedecard(BC_VERSION);
        this.logger.debug("getInfoRedecard = " + result);
        return result;
    }

    protected DadosGetInfoRedeEMV getInfoRedeEMV(int rede) {
        DadosGetInfoRedeEMV result = this.pinpad.getInfoRedeEMV(rede, BC_VERSION);
        this.logger.debug(String.format("getInfoRedeEMV(%s) = %s", rede, result));
        return result;
    }

    protected SaidaRemoveCardEMV removeCard() {
        SaidaRemoveCardEMV result = this.pinpad.removeCard(this.getVersion());
        this.logger.debug("removeCard = " + result);
        return result;
    }

    protected SaidaGetTimeStampEMV getTimeStamp(char[] input) {
        SaidaGetTimeStampEMV result = this.pinpad.getTimeStamp(this.getVersion(), input);
        this.logger.debug("getTimeStamp = " + result);
        return result;
    }

    protected void setPPTimeout(int defaultTimeout, int blockingTimeout, int noBlockingTimeout) {
        this.pinpad.setPPTimeout(this.getVersion(), defaultTimeout, blockingTimeout, noBlockingTimeout);
        this.logger.debug(String.format("setPPTimeout(%s, %s, %s)", defaultTimeout, blockingTimeout, noBlockingTimeout));
    }

    protected int changeParameter(char[] psInput) {
        int result = this.pinpad.changeParameter(this.getVersion(), psInput);
        this.logger.debug("changeParameter = " + result);
        return result;
    }

    public SaidaGetCardQualidade getCardQualidade() {
        SaidaGetCardQualidade result = this.pinpad.getCardQualidade(this.getVersion());
        this.logger.debug("getCardQualidade = " + result);
        return result;
    }
}

