/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.emvfull;

import br.com.auttar.AuttarLogger;
import br.com.auttar.pinpad.service.GetTracksService;
import com.csi.ctfclient.excecoes.ExcecaoDadoInvalido;
import com.csi.ctfclient.excecoes.ExcecaoHexaInvalido;
import com.csi.ctfclient.excecoes.InvalidDataException;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.ConstantesAbecs;
import com.csi.ctfclient.tools.devices.emv.DadoSolicitaPin;
import com.csi.ctfclient.tools.devices.emv.LeitorCartao;
import com.csi.ctfclient.tools.devices.emv.ParamAbecs;
import com.csi.ctfclient.tools.devices.emv.SaidaGetCardEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetClearData;
import com.csi.ctfclient.tools.devices.emv.SaidaGetTracks;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.devices.emvfull.GenericPinpadController;
import com.csi.ctfclient.tools.util.ByteUtil;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.DisplayFisicoCSILanguage;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ProtocoloAbecs
extends GenericPinpadController {
    public ProtocoloAbecs(String port, String handler) throws ExcecaoPerifericos {
        super(port, handler, ProtocoloAbecs.getLogger(ProtocoloAbecs.class));
    }

    public ProtocoloAbecs(GenericPinpadController other) {
        super(other);
        this.logger = ProtocoloAbecs.getLogger(ProtocoloAbecs.class);
    }

    public static char[] montaCmdBlk(ParamAbecs ... params) {
        StringBuilder sb = new StringBuilder();
        for (ParamAbecs par : params) {
            Object[] dado;
            if (par == null) continue;
            Object k = par.getId();
            if (!(k instanceof char[])) {
                return null;
            }
            sb.append((char[])k);
            Object dados = par.getDados();
            if (dados instanceof String) {
                sb.appendCodePoint(((String)dados).length() / 256);
                sb.appendCodePoint(((String)dados).length() % 256);
                sb.append(dados);
                continue;
            }
            if (dados instanceof byte[]) {
                dado = (byte[])dados;
                sb.appendCodePoint(dado.length / 256);
                sb.appendCodePoint(dado.length % 256);
                sb.append(StringUtil.byteArrayToCharArray(dado));
                continue;
            }
            if (dados instanceof char[]) {
                dado = (char[])dados;
                sb.appendCodePoint(dado.length / 256);
                sb.appendCodePoint(dado.length % 256);
                sb.append((char[])dado);
                continue;
            }
            if (dados instanceof char[][]) {
                char[][] arrDados = (char[][])dados;
                sb.appendCodePoint(arrDados.length * 2 / 256);
                sb.appendCodePoint(arrDados.length * 2 % 256);
                for (char[] dado2 : arrDados) {
                    sb.append(dado2);
                }
                continue;
            }
            return null;
        }
        return sb.toString().toCharArray();
    }

    public static String getValorParam(char[] id, byte[] bloco) {
        AuttarLogger logger = ProtocoloAbecs.getLogger(ProtocoloAbecs.class);
        try {
            byte[] byteTag = ProtocoloAbecs.getByteTag(id, bloco);
            if (byteTag != null) {
                return new String(byteTag, StandardCharsets.ISO_8859_1);
            }
        }
        catch (Exception e) {
            logger.warn(String.format("N\u00e3o foi poss\u00edvel ler o tag %s: %s", StringUtil.charArrayToHexString(id), e.getMessage()));
        }
        return null;
    }

    public static byte[] getByteTag(char[] id, byte[] block) {
        AuttarLogger logger = ProtocoloAbecs.getLogger(ProtocoloAbecs.class);
        String blockString = new String(block, StandardCharsets.ISO_8859_1);
        String idString = StringUtil.charArrayToHexString(id);
        int pos = blockString.indexOf(new String(id));
        if (pos == -1) {
            logger.info(String.format("Tag %s n\u00e3o foi enviado pelo pinpad", idString));
            return null;
        }
        int tam = block[pos + 2] << 8 & 0xFF;
        int initialPosition = pos + 4;
        int finalPosition = pos + 4 + (tam += block[pos + 3] % 256 & 0xFF);
        logger.debug(String.format("Lendo tag ABECS %s no bloco entre [%d, %d)", idString, initialPosition, finalPosition));
        try {
            return ByteUtil.copyRange(block, initialPosition, tam);
        }
        catch (Exception e) {
            logger.warn("N\u00e3o foi poss\u00edvel ler o tag " + idString, e);
            return null;
        }
    }

    public static char[] buildGetClearDataParameters(DadoSolicitaPin data) throws InvalidDataException {
        char[] index;
        int tamMin = data.getTamMin();
        int tamMax = data.getTamMax();
        int indMsg = data.getIndiceMensagem();
        switch (indMsg) {
            case 1: {
                index = ConstantesAbecs.SPE_MSGIDX_TYPE_DDD;
                break;
            }
            case 2: {
                index = ConstantesAbecs.SPE_MSGIDX_RETYPE_DDD;
                break;
            }
            case 3: {
                index = ConstantesAbecs.SPE_MSGIDX_TYPE_TELEPHONE;
                break;
            }
            case 4: {
                index = ConstantesAbecs.SPE_MSGIDX_RETYPE_TELEPHONE;
                break;
            }
            case 5: {
                index = ConstantesAbecs.SPE_MSGIDX_TYPE_DDD_TELEPHONE;
                break;
            }
            case 6: {
                index = ConstantesAbecs.SPE_MSGIDX_RETYPE_DDD_TELEPHONE;
                break;
            }
            case 7: {
                index = ConstantesAbecs.SPE_MSGIDX_TYPE_CPF;
                break;
            }
            case 8: {
                index = ConstantesAbecs.SPE_MSGIDX_RETYPE_CPF;
                break;
            }
            case 9: {
                index = ConstantesAbecs.SPE_MSGIDX_TYPE_RG;
                break;
            }
            case 10: {
                index = ConstantesAbecs.SPE_MSGIDX_RETYPE_RG;
                break;
            }
            case 11: {
                index = ConstantesAbecs.SPE_MSGIDX_TYPE_LAST_4_DIG;
                break;
            }
            case 12: {
                index = ConstantesAbecs.SPE_MSGIDX_TYPE_SEC_CODE;
                break;
            }
            default: {
                throw new InvalidDataException("PA02", "Valor inv\u00e1lido para o parametro SPE_MSGIDX", Integer.toString(indMsg));
            }
        }
        ParamAbecs<char[], char[]> par1 = new ParamAbecs<char[], char[]>(ConstantesAbecs.SPE_MSGIDX, index);
        ParamAbecs<char[], char[]> par2 = new ParamAbecs<char[], char[]>(ConstantesAbecs.SPE_MINDIG, new char[]{(char)tamMin});
        ParamAbecs<char[], char[]> par3 = new ParamAbecs<char[], char[]>(ConstantesAbecs.SPE_MAXDIG, new char[]{(char)tamMax});
        return ProtocoloAbecs.montaCmdBlk(par1, par2, par3);
    }

    @Override
    public String getTableVersion() {
        return this.getInfoEMV().getTableVersion();
    }

    @Override
    public boolean isPinpadAbecs() {
        return true;
    }

    @Override
    public char[] getVersion() {
        return ABECS_VERSION;
    }

    @Override
    public char[] prepareClosePrompt(char[] promptMessage) {
        StringBuilder sb = new StringBuilder();
        sb.append('\r');
        sb.append('\r');
        if (promptMessage.length > 16) {
            sb.append(String.valueOf(promptMessage), 0, 16);
            sb.append('\r');
            sb.append(String.valueOf(promptMessage).substring(16));
        } else {
            sb.append(promptMessage);
        }
        ParamAbecs<char[], String> par = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_DSPMSG, sb.toString());
        return ProtocoloAbecs.montaCmdBlk(par);
    }

    public void displayImage(char[] imageName, char[] imageExtension, byte[] imageBuffer) {
        int result = this.pinpad.displayImage(ABECS_VERSION, imageName, imageExtension, imageBuffer, imageBuffer.length);
        this.logger.info("Retorno 'displayImage' = " + result);
    }

    public void removeImage(char[] imageName) {
        int result = this.pinpad.removeImage(ABECS_VERSION, imageName);
        this.logger.info("Retorno 'removeImage' = " + result);
    }

    public SaidaGetTracks getTracks(String tracks, String cryptoType, Integer keyIndex, String workingKey) {
        char[] input = this.buildGetTracksParameters(tracks, cryptoType, keyIndex, workingKey);
        return this.pinpad.getTracks(ABECS_VERSION, input, input.length);
    }

    public int startGetClearData(char[] input) {
        return this.pinpad.startGetClearData(ABECS_VERSION, input, input.length);
    }

    public SaidaGetClearData getClearData() {
        return this.pinpad.getClearData(ABECS_VERSION);
    }

    @Override
    public char[] buildGoOnChipParameters(BibliotecaPinpad pinpadLibrary) {
        DecimalFormat numFmt = new DecimalFormat("00");
        char[] goxOpt = new char[]{'0', '0', '0', '0', '0'};
        String workingKey = pinpadLibrary.getWorkingKey();
        ParamAbecs<char[], String> acquirerIdTag = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_ACQREF, numFmt.format(pinpadLibrary.getIdRedeAdquirente()));
        numFmt.applyPattern("000000000000");
        ParamAbecs<char[], String> amountTag = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_AMOUNT, numFmt.format(pinpadLibrary.getNovoValorTransacao()));
        ParamAbecs<char[], String> cashbackTag = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_CASHBACK, numFmt.format(pinpadLibrary.getParcelaValorTransacao()));
        if (pinpadLibrary.getConstaListaNegra()) {
            goxOpt[0] = 49;
        }
        if (pinpadLibrary.getObrigaTransacaoOnline()) {
            goxOpt[1] = 49;
        }
        if (pinpadLibrary.getReqPINTabelasServTEF()) {
            goxOpt[2] = 49;
        }
        ParamAbecs<char[], String> optionalTag = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_GOXOPT, String.valueOf(goxOpt));
        ParamAbecs<char[], String> pinEncryptionMethodTag = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_MTHDPIN, String.valueOf(pinpadLibrary.getTipoCriptografia()));
        numFmt.applyPattern("00");
        ParamAbecs<char[], String> keyIndexTag = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_KEYIDX, numFmt.format(pinpadLibrary.getIndiceMasterKey()));
        if (workingKey.length() < 16) {
            workingKey = StringUtil.completaString(pinpadLibrary.getWorkingKey(), 16, '0', false);
        } else if (workingKey.length() > 16) {
            workingKey = StringUtil.completaString(pinpadLibrary.getWorkingKey(), 32, '0', false);
        }
        byte[] bytesWK = null;
        try {
            bytesWK = ByteUtil.hexToByteArray(workingKey);
        }
        catch (Exception e) {
            this.logger.error("Erro ao converter working key em array de bytes!");
        }
        ParamAbecs<char[], char[]> workingKeyTag = new ParamAbecs<char[], char[]>(ConstantesAbecs.SPE_WKENC, StringUtil.byteArrayToCharArray(bytesWK));
        byte[] termFloorLimit = new byte[4];
        try {
            termFloorLimit = ByteUtil.hexToByteArray(pinpadLibrary.getTermFloorLimit());
        }
        catch (Exception e) {
            this.logger.error("Erro ao converter 'term floor limit' em array de bytes!");
        }
        byte[] thrsValBiasedRndSel = new byte[4];
        try {
            thrsValBiasedRndSel = ByteUtil.hexToByteArray(pinpadLibrary.getThresholdValueBiasedRandomSelection());
        }
        catch (Exception e) {
            this.logger.error("Erro ao converter 'threshold value for biased random selection' em array de bytes!");
        }
        byte[] arrData = new byte[10];
        System.arraycopy(termFloorLimit, 0, arrData, 0, 4);
        arrData[4] = (byte)pinpadLibrary.getTargetPercBiasedRandomSelection();
        System.arraycopy(thrsValBiasedRndSel, 0, arrData, 5, 4);
        arrData[9] = (byte)pinpadLibrary.getMaxTargetPerc();
        ParamAbecs<char[], char[]> terminalParametersTag = new ParamAbecs<char[], char[]>(ConstantesAbecs.SPE_TRMPAR, StringUtil.byteArrayToCharArray(arrData));
        String tags = pinpadLibrary.getTags();
        ParamAbecs<char[], byte[]> tagList = null;
        if (tags != null && tags.trim().length() > 0) {
            String tagsOpt = pinpadLibrary.getTagsOpt();
            if (tagsOpt != null) {
                tags = tags + tagsOpt;
            }
            try {
                byte[] byteTags = ByteUtil.hexToByteArray(tags);
                tagList = new ParamAbecs<char[], byte[]>(ConstantesAbecs.SPE_TAGLIST, byteTags);
            }
            catch (Exception e) {
                this.logger.error("Erro ao converter string hexa em um array de bytes!");
            }
        }
        this.logger.debug(String.format("Par\u00e2metros ABECS para GoOnChip: idRedeAdquirente=%s, novoValorTransacao=%s, parcelaValorTransacao=%s, tagsOpcionais=%s, tipoCriptografia=%s, indiceMasterKey=%s, parametrosTerminal=%s, tags=%s", pinpadLibrary.getIdRedeAdquirente(), pinpadLibrary.getNovoValorTransacao(), pinpadLibrary.getParcelaValorTransacao(), String.valueOf(goxOpt), pinpadLibrary.getTipoCriptografia(), pinpadLibrary.getIndiceMasterKey(), StringUtil.byteArrayToCharArray(arrData), pinpadLibrary.getTags()));
        return ProtocoloAbecs.montaCmdBlk(acquirerIdTag, amountTag, cashbackTag, optionalTag, pinEncryptionMethodTag, keyIndexTag, workingKeyTag, terminalParametersTag, tagList);
    }

    @Override
    public char[] buildMandatoryTags(BibliotecaPinpad pinpadLibrary) {
        return null;
    }

    @Override
    public char[] buildOptionalTags(BibliotecaPinpad pinpadLibrary) {
        return null;
    }

    @Override
    public char[] buildFinishChipParameters(BibliotecaPinpad pinpadLibrary) {
        char[] fcxOpt = new char[]{'0', '0', '0', '0'};
        String responseCode = pinpadLibrary.getAuthRespCode();
        if (pinpadLibrary.getComunicacaoHost() != 0) {
            fcxOpt[0] = 50;
        } else if (!responseCode.equals("00") && !responseCode.equals("000")) {
            fcxOpt[0] = 49;
        }
        ParamAbecs<char[], String> tagFcxOpt = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_FCXOPT, String.valueOf(fcxOpt));
        if (responseCode.length() == 3) {
            responseCode = responseCode.substring(1);
        }
        ParamAbecs<char[], String> tagArc = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_ARC, responseCode);
        String finishChipEmvData = pinpadLibrary.getCampo55();
        ParamAbecs<char[], byte[]> tagEmvData = null;
        if (finishChipEmvData != null) {
            try {
                tagEmvData = new ParamAbecs<char[], byte[]>(ConstantesAbecs.SPE_EMVDATA, ByteUtil.hexToByteArray(finishChipEmvData));
            }
            catch (ExcecaoHexaInvalido e) {
                this.logger.warn("N\u00e3o foi poss\u00edvel montar tag SPE_EMVDATA: " + e.getMessage());
                this.logger.warn("Dados que seriam enviados para FCX = " + finishChipEmvData);
            }
        }
        String finishChipTags = pinpadLibrary.getTags();
        ParamAbecs<char[], byte[]> tagList = null;
        if (finishChipTags != null) {
            try {
                tagList = new ParamAbecs<char[], byte[]>(ConstantesAbecs.SPE_TAGLIST, ByteUtil.hexToByteArray(finishChipTags));
            }
            catch (ExcecaoHexaInvalido e) {
                this.logger.warn("N\u00e3o foi poss\u00edvel montar tag SPE_TAGLIST: " + e.getMessage());
                this.logger.warn("Dados que seriam enviados para FCX = " + finishChipTags);
            }
        }
        return ProtocoloAbecs.montaCmdBlk(tagFcxOpt, tagArc, tagEmvData, tagList);
    }

    @Override
    public char[] buildGetInfoParameters() {
        String sb = String.valueOf(ConstantesAbecs.PP_MNNAME) + String.valueOf(ConstantesAbecs.PP_MODEL) + String.valueOf(ConstantesAbecs.PP_SOVER) + String.valueOf(ConstantesAbecs.PP_SPECVER) + String.valueOf(ConstantesAbecs.PP_MANVERS) + String.valueOf(ConstantesAbecs.PP_SERNUM) + String.valueOf(ConstantesAbecs.PP_DSPGRSZ) + String.valueOf(ConstantesAbecs.PP_MFSUP) + String.valueOf(ConstantesAbecs.PP_CAPAB) + String.valueOf(ConstantesAbecs.PP_DSPTXTSZ) + String.valueOf(ConstantesAbecs.PP_MKTDESP) + String.valueOf(ConstantesAbecs.PP_MKTDESD) + String.valueOf(ConstantesAbecs.PP_DKPTTDESP) + String.valueOf(ConstantesAbecs.PP_DKPTTDESD) + String.valueOf(ConstantesAbecs.PP_TABVER00);
        ParamAbecs<char[], String> param = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_IDLIST, sb);
        return ProtocoloAbecs.montaCmdBlk(param);
    }

    @Override
    public char[] buildEncryptBufferParameters(int tipoCriptografia, int indiceMasterKey, String workingKey, String dados) {
        DecimalFormat numFmt = new DecimalFormat("00");
        int tamDado = dados.length();
        tamDado = tamDado % 8 == 0 ? tamDado : tamDado + (8 - tamDado % 8);
        byte[] bytesDados = new byte[tamDado];
        try {
            byte[] bytesTmp = ByteUtil.hexToByteArray(dados);
            System.arraycopy(bytesTmp, 0, bytesDados, 0, bytesTmp.length);
        }
        catch (Exception e) {
            this.logger.error("Erro ao converter dados de entrada em array de bytes!");
        }
        ParamAbecs<char[], byte[]> par1 = new ParamAbecs<char[], byte[]>(ConstantesAbecs.SPE_DATAIN, bytesDados);
        ParamAbecs<char[], String> par2 = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_MTHDDAT, tipoCriptografia + "0");
        ParamAbecs<char[], String> par3 = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_KEYIDX, numFmt.format(indiceMasterKey));
        byte[] bytesWK = null;
        try {
            bytesWK = ByteUtil.hexToByteArray(workingKey);
        }
        catch (Exception e) {
            this.logger.error("Erro ao converter working key em array de bytes!");
        }
        ParamAbecs<char[], byte[]> par4 = new ParamAbecs<char[], byte[]>(ConstantesAbecs.SPE_WKENC, bytesWK);
        return ProtocoloAbecs.montaCmdBlk(par1, par2, par3, par4);
    }

    @Override
    public char[] buildStartGetCardParameters(LeitorCartao cardReader) {
        String displayMessage;
        String getCardOptions;
        SimpleDateFormat dtFmt = new SimpleDateFormat("yyMMdd");
        DecimalFormat numFmt = new DecimalFormat("00");
        Date dtTrans = cardReader.getDataTransacao();
        numFmt.applyPattern("000000000000");
        ParamAbecs<char[], String> speAMOUNT = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_AMOUNT, numFmt.format(cardReader.getValorInicialTransacao()));
        ParamAbecs<char[], String> speTRNDATE = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_TRNDATE, dtFmt.format(dtTrans));
        dtFmt.applyPattern("HHmmss");
        ParamAbecs<char[], String> speTRNTIME = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_TRNTIME, dtFmt.format(dtTrans));
        String idsAceitos = cardReader.getAidList();
        assert (idsAceitos != null);
        ParamAbecs<char[], String> speAIDLIST = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_AIDLIST, idsAceitos.substring(2));
        if (cardReader.isActiveContactless()) {
            getCardOptions = "11000";
            displayMessage = new DisplayFisicoCSILanguage().getMessage("LEICAR_TITLE_CONTACTLESS3");
        } else {
            getCardOptions = "01000";
            displayMessage = new DisplayFisicoCSILanguage().getMessage("LEICAR_TITLE1");
        }
        ParamAbecs<char[], String> speGCXOPT = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_GCXOPT, getCardOptions);
        ParamAbecs<char[], String> speDSPMSG = new ParamAbecs<char[], String>(ConstantesAbecs.SPE_DSPMSG, displayMessage);
        char[] emvTagList = new char[]{'\u0084', '\u009f', '\u0007'};
        ParamAbecs<char[], char[]> speTAGLIST = new ParamAbecs<char[], char[]>(ConstantesAbecs.SPE_TAGLIST, emvTagList);
        return ProtocoloAbecs.montaCmdBlk(speAMOUNT, speTRNDATE, speTRNTIME, speAIDLIST, speGCXOPT, speTAGLIST, speDSPMSG);
    }

    @Override
    public char[] buildStartCheckEventParameters(Integer checkKEY, Integer checkMAG, Integer checkICC, Integer checkCTLS) {
        String checkEventParam = checkKEY.toString();
        checkEventParam = checkEventParam + checkMAG.toString();
        checkEventParam = checkEventParam + checkICC.toString();
        checkEventParam = checkEventParam + checkCTLS.toString();
        checkEventParam = checkEventParam + "00";
        ParamAbecs<char[], char[]> par1 = new ParamAbecs<char[], char[]>(ConstantesAbecs.SPE_CEXOPT, checkEventParam.toCharArray());
        return ProtocoloAbecs.montaCmdBlk(par1);
    }

    @Override
    public char[] buildStartGenericCommandTag84Parameters(SaidaGetCardEMV getCardOut) {
        return new char[0];
    }

    public char[] buildGetTracksParameters(String tracks, String cryptoType, Integer keyIndex, String workingKey) {
        GetTracksService service = new GetTracksService();
        ParamAbecs<char[], String> speTRACKS = service.setTRACKS(tracks);
        if (null == cryptoType) {
            return ProtocoloAbecs.montaCmdBlk(speTRACKS);
        }
        ParamAbecs<char[], String> speMTHDDAT = null;
        ParamAbecs<char[], String> speOPNDIG = null;
        ParamAbecs<char[], String> speKEYIDX = null;
        ParamAbecs<char[], byte[]> speWKENC = null;
        try {
            speMTHDDAT = service.setMTHDDAT(cryptoType);
        }
        catch (ExcecaoDadoInvalido excecaoDadoInvalido) {
            this.logger.warn(excecaoDadoInvalido.getMessage());
        }
        try {
            speOPNDIG = service.setOPNDIG(2);
        }
        catch (ExcecaoDadoInvalido excecaoDadoInvalido) {
            this.logger.warn(excecaoDadoInvalido.getMessage());
        }
        try {
            speKEYIDX = service.setKEYIDX(keyIndex);
        }
        catch (ExcecaoDadoInvalido excecaoDadoInvalido) {
            this.logger.warn(excecaoDadoInvalido.getMessage());
        }
        try {
            speWKENC = service.setWKENC(workingKey.getBytes());
        }
        catch (ExcecaoDadoInvalido excecaoDadoInvalido) {
            this.logger.warn(excecaoDadoInvalido.getMessage());
        }
        return ProtocoloAbecs.montaCmdBlk(speTRACKS, speMTHDDAT, speOPNDIG, speKEYIDX, speWKENC);
    }
}

