/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.emvfull;

import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.LeitorCartao;
import com.csi.ctfclient.tools.devices.emv.SaidaDefineWKPANEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetCardEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetTimeStampEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.devices.emvfull.GenericPinpadController;
import com.csi.ctfclient.tools.devices.emvfull.KeyFactory;
import com.csi.ctfclient.tools.util.StringUtil;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ProtocoloBibliotecaCompartilhada
extends GenericPinpadController {
    public ProtocoloBibliotecaCompartilhada(String port, String handler) throws ExcecaoPerifericos {
        super(port, handler, ProtocoloBibliotecaCompartilhada.getLogger(ProtocoloBibliotecaCompartilhada.class));
    }

    public ProtocoloBibliotecaCompartilhada(GenericPinpadController other) {
        super(other);
        this.logger = ProtocoloBibliotecaCompartilhada.getLogger(ProtocoloBibliotecaCompartilhada.class);
    }

    @Override
    public String getTableVersion() {
        SaidaGetTimeStampEMV saidaGetTimeStampEMV = this.pinpad.getTimeStamp(this.getVersion(), "00".toCharArray());
        if (saidaGetTimeStampEMV != null && saidaGetTimeStampEMV.getRetorno() == 0) {
            return saidaGetTimeStampEMV.getTimeStamp();
        }
        return null;
    }

    @Override
    public boolean isPinpadAbecs() {
        return false;
    }

    @Override
    protected void setupSecureCommunication() throws ExcecaoPerifericos {
        try {
            this.logger.info("Habilitando comunica\u00e7\u00e3o segura...");
            String rsaPublicKey = KeyFactory.getRsaPublicKey();
            this.logger.debug("Definindo WKPAN...");
            SaidaDefineWKPANEMV saidaDefineWKPANEMV = this.defineWKPAN(rsaPublicKey.toCharArray());
            if (saidaDefineWKPANEMV.getRetorno() == 10) {
                this.logger.warn("Dispositivo nao suporta conexao segura, desligando");
                ProtocoloBibliotecaCompartilhada.setSecureCommunication(false);
                return;
            }
            ProtocoloBibliotecaCompartilhada.validateReturn(saidaDefineWKPANEMV.getRetorno(), "defineWKPAN");
            this.logger.debug("WKPAN definida");
            if (!KeyFactory.isChaveLocal()) {
                this.logger.info("comunicacao segura em modo remoto habilitado...");
                GenericPinpadController.setWkpan(saidaDefineWKPANEMV.getCertificado());
                return;
            }
            String certificado = saidaDefineWKPANEMV.getCertificado();
            if (!("T".equals(saidaDefineWKPANEMV.getCabecalho()) && "1".equals(saidaDefineWKPANEMV.getVersao()) && "X".equals(saidaDefineWKPANEMV.getFinalizador()))) {
                this.logger.error("Certificado gerado pelo pinpad inv\u00e1lido: ".concat(certificado));
                throw new ExcecaoPerifericos("PBC01", "Certificado gerado pelo pinpad inv\u00e1lido", "Certificado = " + certificado);
            }
            this.logger.info("O certificado gerado pelo pinpad \u00e9 v\u00e1lido!");
            ProtocoloBibliotecaCompartilhada.setWkpan(certificado.substring(11, 43));
        }
        catch (Exception e) {
            this.logger.error("Erro ao habilitar a comunica\u00e7\u00e3o segura com o pinpad, fechando a comunica\u00e7\u00e3o...");
            this.closeConnection(this.getSerialPort().toCharArray());
            throw e;
        }
    }

    @Override
    public char[] getVersion() {
        return BC_VERSION;
    }

    @Override
    public char[] prepareClosePrompt(char[] promptMessage) {
        return promptMessage;
    }

    private SaidaDefineWKPANEMV defineWKPAN(char[] input) {
        return this.pinpad.defineWKPAN(BC_VERSION, input);
    }

    private char[] formataTags(String t) {
        if (t != null) {
            String tam = StringUtil.completaString("" + t.length() / 2, 3, '0', true);
            return (tam + t).toCharArray();
        }
        return "000".toCharArray();
    }

    @Override
    public char[] buildStartGetCardParameters(LeitorCartao cardReader) {
        String idsAceitos;
        Date dt = cardReader.getDataTransacao();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMdd");
        StringBuilder stringBuffer = new StringBuilder();
        DecimalFormat numberFormat = new DecimalFormat("00");
        int redeAdquirente = cardReader.getIdRedeAdquirente();
        stringBuffer.append(numberFormat.format(redeAdquirente));
        if (redeAdquirente == 0 || redeAdquirente > 0 && cardReader.getIndiceAID() != null) {
            idsAceitos = cardReader.getAidList();
            if (null == idsAceitos) {
                idsAceitos = "00";
            }
        } else {
            idsAceitos = "00";
        }
        stringBuffer.append("00");
        numberFormat.applyPattern("000000000000");
        stringBuffer.append(numberFormat.format(cardReader.getValorInicialTransacao()));
        stringBuffer.append(dateFormat.format(dt));
        dateFormat.applyPattern("HHmmss");
        stringBuffer.append(dateFormat.format(dt));
        stringBuffer.append(cardReader.getTimeStamp());
        stringBuffer.append(idsAceitos);
        if (this.saidaGetInfoEMV.getVersaoEspecificacao().compareTo("1.08") >= 0) {
            if (cardReader.isActiveContactless()) {
                stringBuffer.append("1");
            } else {
                stringBuffer.append("0");
            }
        }
        String cmd = stringBuffer.toString();
        this.logger.debug(String.format("startGetCard(%s)", cmd));
        return cmd.toCharArray();
    }

    @Override
    public char[] buildStartCheckEventParameters(Integer checkKEY, Integer checkMAG, Integer checkICC, Integer checkCTLS) {
        String checkEventParam = checkKEY.toString();
        checkEventParam = checkEventParam + checkMAG.toString();
        checkEventParam = checkEventParam + checkICC.toString();
        checkEventParam = checkEventParam + checkCTLS.toString();
        this.logger.debug(String.format("startCheckEvent(%s)", checkEventParam));
        return checkEventParam.toCharArray();
    }

    @Override
    public char[] buildStartGenericCommandTag84Parameters(SaidaGetCardEMV getCardOut) {
        int idRede = getCardOut.getIdRedeAdquirente();
        String parameters = null;
        if (idRede == 4) {
            parameters = "040070400184";
        } else if (idRede == 3) {
            parameters = "030040284";
        }
        this.logger.debug("Par\u00e2metros startGenericCommandTag84 = " + parameters);
        if (parameters != null) {
            return parameters.toCharArray();
        }
        return null;
    }

    @Override
    public char[] buildGetInfoParameters() {
        String getInfoParameters = "00";
        this.logger.debug(String.format("getInfo(%s)", getInfoParameters));
        return getInfoParameters.toCharArray();
    }

    @Override
    public char[] buildEncryptBufferParameters(int tipoCriptografia, int indiceMasterKey, String workingKey, String dados) {
        return new char[0];
    }

    @Override
    public char[] buildGoOnChipParameters(BibliotecaPinpad reader) {
        String tmpDadosRestantes;
        if (reader.getDadosRestantes() == null) {
            tmpDadosRestantes = "000";
        } else {
            DecimalFormat decimalFormat = new DecimalFormat("000");
            tmpDadosRestantes = decimalFormat.format(reader.getDadosRestantes().length()) + reader.getDadosRestantes();
        }
        String workingKey = StringUtil.completaString(reader.getWorkingKey(), 32, '0', false);
        String cmdGoOnChip = StringUtil.sprintf("%012ld%012ld%d%d%d%d%02d%s%d%s%02d%s%02d%s", new Object[]{reader.getNovoValorTransacao(), reader.getParcelaValorTransacao(), reader.getConstaListaNegra() ? 1 : 0, reader.getObrigaTransacaoOnline() ? 1 : 0, reader.getReqPINTabelasServTEF() ? 1 : 0, reader.getTipoCriptografia(), reader.getIndiceMasterKey(), workingKey, reader.getGerencRisco() ? 1 : 0, reader.getTermFloorLimit(), reader.getTargetPercBiasedRandomSelection(), reader.getThresholdValueBiasedRandomSelection(), reader.getMaxTargetPerc(), tmpDadosRestantes});
        return cmdGoOnChip.toCharArray();
    }

    @Override
    public char[] buildMandatoryTags(BibliotecaPinpad pinpadLibrary) {
        return this.formataTags(pinpadLibrary.getTags());
    }

    @Override
    public char[] buildOptionalTags(BibliotecaPinpad pinpadLibrary) {
        return this.formataTags(pinpadLibrary.getTagsOpt());
    }

    @Override
    public char[] buildFinishChipParameters(BibliotecaPinpad pinpadLibrary) {
        String responseCode;
        String dadosRestantes = pinpadLibrary.getDadosRestantes();
        if (dadosRestantes == null) {
            dadosRestantes = "";
        }
        if ((responseCode = pinpadLibrary.getAuthRespCode()).length() == 3) {
            responseCode = responseCode.substring(1);
        }
        return StringUtil.sprintf("%d%d%s%03d%s%03d%s", new Object[]{pinpadLibrary.getComunicacaoHost(), pinpadLibrary.getTipoEmissor(), responseCode, pinpadLibrary.getCampo55().length() / 2, pinpadLibrary.getCampo55(), dadosRestantes.length() / 2, dadosRestantes}).toCharArray();
    }
}

