/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.generic;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.DisplayFisico;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.sun.jna.Library;
import com.sun.jna.Native;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbEndpoint;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbInterface;
import javax.usb.UsbIrp;
import javax.usb.UsbPipe;
import javax.usb.UsbServices;

public class DisplayFisicoAuttar
extends DisplayFisico {
    private final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(DisplayFisicoAuttar.class);
    private boolean displayVazio = false;
    private DisplayGertecTecladoUSBDLL dispDLL = null;
    private UsbInterface usbInt;
    private UsbPipe usbPipe;

    @Deprecated
    public DisplayFisicoAuttar(String a, String b, String c, String d) throws ExcecaoPerifericos {
        this("40", "20");
    }

    @Deprecated
    public DisplayFisicoAuttar(JFrame f, String a, String b, String c, String d) throws ExcecaoPerifericos {
        this("40", "20");
    }

    public DisplayFisicoAuttar(String numColunas, String numLinhas) throws ExcecaoPerifericos {
        if (System.getProperty("os.name").equalsIgnoreCase("LINUX")) {
            this.inicializa();
            this.numColunas = Integer.parseInt(numColunas);
            this.numLinhas = Integer.parseInt(numLinhas);
            this.habilita();
            this.limpa();
            this.desabilita();
        } else {
            this.dispDLL = new DisplayGertecTecladoUSBDLL(numColunas, numLinhas);
        }
    }

    private UsbDevice procuraDispUsb(UsbHub hub, short vendorId, short productId) {
        List<UsbDevice> devices = this.getUsbDevice(hub);
        for (UsbDevice device : devices) {
            UsbDeviceDescriptor desc = device.getUsbDeviceDescriptor();
            if (desc.idVendor() == vendorId && desc.idProduct() == productId) {
                return device;
            }
            if (!device.isUsbHub() || (device = this.procuraDispUsb((UsbHub)device, vendorId, productId)) == null) continue;
            return device;
        }
        return null;
    }

    private List<UsbDevice> getUsbDevice(UsbHub hub) {
        try {
            return hub.getAttachedUsbDevices();
        }
        catch (ClassCastException e) {
            this.logger.error("N\u00e3o foi poss\u00edvel realizar o cast do objeto para um List<UsbDevice>: " + e.getMessage());
            throw new ClassCastException(e.getCause().getMessage());
        }
    }

    private void abrePipe() throws Exception {
        block7: {
            try {
                this.usbPipe.open();
            }
            catch (Exception e) {
                try {
                    this.desabilita();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean usbFixed = false;
                try {
                    this.inicializa();
                    if (this.usbInt != null && this.usbInt.isClaimed()) {
                        usbFixed = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (usbFixed) break block7;
                throw new Exception("Impossivel abrir pipe com o teclado (msg = '" + e.getMessage() + "')!");
            }
        }
    }

    private void enviaComando(byte[] cmd) throws Exception {
        try {
            this.abrePipe();
            UsbIrp irp = this.usbPipe.createUsbIrp();
            byte[] rawCmd = new byte[32];
            System.arraycopy(cmd, 0, rawCmd, 0, Math.min(cmd.length, 22));
            irp.setData(rawCmd);
            irp.setLength(rawCmd.length);
            irp.setActualLength(rawCmd.length);
            irp.setAcceptShortPacket(true);
            this.usbPipe.syncSubmit(irp);
            this.fechaPipe();
        }
        catch (Exception e) {
            throw new Exception("Impossivel enviar comando (msg = '" + e.getMessage() + "')!");
        }
    }

    private void fechaPipe() {
        try {
            this.usbPipe.close();
        }
        catch (UsbException usbException) {
            // empty catch block
        }
    }

    private void inicializa() throws ExcecaoPerifericos {
        String msgDbg = "DisplayGertecTecladoUSB::inicializa() -> ";
        BufferedWriter bw = null;
        try {
            File f = new File("javax.usb.properties");
            if (f.exists() && !f.delete()) {
                this.logger.warn("N\u00e3o foi poss\u00edvel remover o arquivo " + f.getAbsolutePath());
            }
            bw = new BufferedWriter(new FileWriter(f));
            bw.write("javax.usb.services = de.ailis.usb4java.Services");
            bw.newLine();
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            UsbEndpoint endpoint;
            UsbServices services = UsbHostManager.getUsbServices();
            UsbHub rootHub = services.getRootUsbHub();
            UsbDevice usbDev = this.procuraDispUsb(rootHub, (short)5971, (short)257);
            if (usbDev == null) {
                throw new ExcecaoPerifericos("DFA01", "Teclado Gertec USB desconectado!", "rootUsb = " + rootHub.toString());
            }
            List<UsbInterface> interfaces = this.getUsbInterface(usbDev);
            this.usbInt = interfaces.get(1);
            if (this.usbInt == null) {
                throw new ExcecaoPerifericos("DFA02", "Interface USB Teclado Gertec nao encontrada!");
            }
            try {
                this.usbInt.claim();
            }
            catch (UsbException uE) {
                throw new ExcecaoPerifericos("DFA03", "Impossivel requisitar interface USB Teclado Gertec!", uE.getMessage());
            }
            List<UsbEndpoint> usbEndpoints = this.getUsbEndpoint();
            UsbEndpoint usbEndpoint = null;
            Iterator<UsbEndpoint> iterator = usbEndpoints.iterator();
            while (iterator.hasNext() && ((usbEndpoint = (endpoint = iterator.next())).getType() != 3 || usbEndpoint.getDirection() != 0)) {
                usbEndpoint = null;
            }
            if (usbEndpoint == null) {
                throw new ExcecaoPerifericos("DFA04", "A interface USB Teclado Gertec nao possui o endpoint de saida via interrupcao!");
            }
            this.usbPipe = usbEndpoint.getUsbPipe();
        }
        catch (UsbException e) {
            throw new ExcecaoPerifericos("DFA05", "Erro durante a enumeracao de dispositivos USB", e.getMessage());
        }
    }

    private List<UsbInterface> getUsbInterface(UsbDevice usbDevice) {
        try {
            return usbDevice.getActiveUsbConfiguration().getUsbInterfaces();
        }
        catch (ClassCastException e) {
            this.logger.error("Nao foi possivel realizar o cast do objeto para um List<UsbInterface>: " + e.getMessage());
            throw new ClassCastException(e.getCause().getMessage());
        }
    }

    private List<UsbEndpoint> getUsbEndpoint() {
        try {
            return this.usbInt.getUsbEndpoints();
        }
        catch (ClassCastException e) {
            this.logger.error("Nao foi possivel realizar o cast do objeto para um List<UsbEndpoint>: " + e.getMessage());
            throw new ClassCastException(e.getCause().getMessage());
        }
    }

    @Override
    public void desabilita() throws ExcecaoPerifericos {
        if (this.dispDLL != null) {
            this.dispDLL.desabilita();
            return;
        }
        try {
            this.usbInt.release();
            this.setHabilitado(false);
        }
        catch (Exception e) {
            throw new ExcecaoPerifericos("DFA06", "Erro durante a liberacao dos dispositivos USB", e.getMessage());
        }
    }

    @Override
    public void habilita() throws ExcecaoPerifericos {
        if (this.dispDLL != null) {
            this.dispDLL.habilita();
            return;
        }
        try {
            if (!this.usbInt.isClaimed()) {
                this.usbInt.claim();
            }
            this.setHabilitado(true);
            this.displayVazio = false;
        }
        catch (Exception e) {
            throw new ExcecaoPerifericos("DFA07", "Erro durante a habilitacao do display", e.getMessage());
        }
    }

    @Override
    public void imprime(String texto) throws ExcecaoPerifericos {
        if (this.dispDLL != null) {
            this.dispDLL.imprime(texto);
            return;
        }
        this.imprimeEm(this.linhaAtual, this.colunaAtual, texto);
    }

    @Override
    public void printPNG(String path) throws ExcecaoPerifericos {
    }

    @Override
    public void printPNG(String header, String footer1, String footer2, String path) throws ExcecaoPerifericos {
    }

    @Override
    public void imprimeEm(int linha, int coluna, String texto) throws ExcecaoPerifericos {
        int tamTexto = texto.length();
        if (tamTexto <= 0) {
            return;
        }
        int tamMax = (this.numLinhas - linha - 1) * this.numColunas + (this.numColunas - coluna);
        if (tamTexto > tamMax) {
            texto = texto.substring(0, tamMax);
        }
        if (this.dispDLL != null) {
            this.dispDLL.imprimeEm(linha, coluna, texto);
            return;
        }
        try {
            boolean branco = texto.trim().equals("");
            if (!this.displayVazio || !branco) {
                if (linha != this.linhaAtual || coluna != this.colunaAtual) {
                    this.posicionaCursor(linha, coluna);
                }
                int ct = 0;
                while (ct * 20 < tamMax && ct * 20 < tamTexto) {
                    int CMD_DISPLAY_STRING;
                    int curLen = texto.substring(ct * 20).length();
                    byte[] cmd = new byte[Math.min(curLen, 20) + 2];
                    cmd[0] = CMD_DISPLAY_STRING = 25;
                    cmd[1] = (byte)(cmd.length - 2);
                    System.arraycopy(texto.getBytes(), ct * 20, cmd, 2, cmd.length - 2);
                    ++ct;
                    this.enviaComando(cmd);
                }
            }
            this.linhaAtual = linha;
            this.colunaAtual = coluna;
            this.reposiciona(texto);
            if (!branco) {
                this.displayVazio = false;
            }
        }
        catch (Exception e) {
            throw new ExcecaoPerifericos("DFA08", String.format("Erro durante a impressao de informacoes em (%d, %d, %s)", linha, coluna, texto), e.getMessage());
        }
    }

    @Override
    public void liberaRecursos() throws ExcecaoPerifericos {
        if (this.dispDLL != null) {
            this.dispDLL.liberaRecursos();
            return;
        }
        if (this.getHabilitado()) {
            this.desabilita();
        }
    }

    @Override
    public void limpa() throws ExcecaoPerifericos {
        if (this.dispDLL != null) {
            this.dispDLL.limpa();
            return;
        }
        try {
            if (!this.displayVazio) {
                try {
                    byte CMD_DISPLAY_CHANGE_CURSOR = 31;
                    this.enviaComando(new byte[]{CMD_DISPLAY_CHANGE_CURSOR, 2, 0, 0});
                }
                catch (Exception e) {
                    this.logger.warn("N\u00e3o foi poss\u00edvel enviar comando de mudan\u00e7a de cursor: " + e.getMessage());
                }
                byte CMD_DISPLAY_CLEAR = 20;
                this.enviaComando(new byte[]{CMD_DISPLAY_CLEAR, 0});
            }
            this.colunaAtual = 0;
            this.linhaAtual = 0;
            this.limpaTexto();
            this.displayVazio = true;
        }
        catch (Exception e) {
            throw new ExcecaoPerifericos("DFA09", "Erro durante a limpeza do display", e.getMessage());
        }
    }

    @Override
    public void posicionaCursor(int linha, int coluna) throws ExcecaoPerifericos {
        if (this.dispDLL != null) {
            this.dispDLL.posicionaCursor(linha, coluna);
            return;
        }
        if (linha == this.linhaAtual && coluna == this.colunaAtual) {
            return;
        }
        try {
            byte CMD_DISPLAY_GOTOXY = 23;
            this.enviaComando(new byte[]{CMD_DISPLAY_GOTOXY, 2, (byte)coluna, (byte)linha});
            this.linhaAtual = linha;
            this.colunaAtual = coluna;
        }
        catch (Exception e) {
            throw new ExcecaoPerifericos("DFA10", String.format("Erro na definicao da posicao do cursor em (%d, %d)", linha, coluna), e.getMessage());
        }
    }

    class DisplayGertecTecladoUSBDLL
    extends DisplayFisico {
        private GertecLibrary gertecRef = null;

        public DisplayGertecTecladoUSBDLL(String numColunas, String numLinhas) throws ExcecaoPerifericos {
            this.habilita();
            this.inicializa();
            this.numLinhas = Integer.parseInt(numLinhas);
            this.numColunas = Integer.parseInt(numColunas);
            this.limpa();
            this.desabilita();
        }

        private void inicializa() throws ExcecaoPerifericos {
            int opened = this.gertecRef.OpenTec65();
            if (opened != 0) {
                throw new ExcecaoPerifericos("DFA11", "Erro na abertura do display", "opened = " + opened);
            }
        }

        @Override
        public void imprime(String texto) throws ExcecaoPerifericos {
            this.imprimeEm(this.linhaAtual, this.colunaAtual, texto);
        }

        @Override
        public void printPNG(String path) throws ExcecaoPerifericos {
        }

        @Override
        public void printPNG(String header, String footer1, String footer2, String path) throws ExcecaoPerifericos {
        }

        @Override
        public void imprimeEm(int linha, int coluna, String texto) throws ExcecaoPerifericos {
            boolean branco = texto.trim().equals("");
            if (!DisplayFisicoAuttar.this.displayVazio || !branco) {
                if (linha != this.linhaAtual || coluna != this.colunaAtual) {
                    this.posicionaCursor(linha, coluna);
                }
                this.gertecRef.DispStr(texto);
            }
            this.linhaAtual = linha;
            this.colunaAtual = coluna;
            this.reposiciona(texto);
            if (!branco) {
                DisplayFisicoAuttar.this.displayVazio = false;
            }
        }

        @Override
        public void limpa() throws ExcecaoPerifericos {
            if (!DisplayFisicoAuttar.this.displayVazio) {
                this.gertecRef.ModoCursor(0);
                this.gertecRef.LcdClearLine(1);
                this.gertecRef.LcdClearLine(2);
                this.gertecRef.GoToXY(1, 1);
            }
            this.colunaAtual = 0;
            this.linhaAtual = 0;
            this.limpaTexto();
            DisplayFisicoAuttar.this.displayVazio = true;
        }

        @Override
        public void posicionaCursor(int linha, int coluna) throws ExcecaoPerifericos {
            if (linha == this.linhaAtual && coluna == this.colunaAtual) {
                return;
            }
            this.gertecRef.GoToXY(linha + 1, coluna + 1);
            this.linhaAtual = linha;
            this.colunaAtual = coluna;
        }

        @Override
        public void desabilita() throws ExcecaoPerifericos {
            this.gertecRef.CloseTec65();
            this.gertecRef = null;
            System.gc();
            this.setHabilitado(false);
        }

        @Override
        public void habilita() throws ExcecaoPerifericos {
            if (this.gertecRef == null) {
                this.gertecRef = (GertecLibrary)Native.loadLibrary((String)"tec65_32", GertecLibrary.class);
            }
            this.inicializa();
            this.setHabilitado(true);
            DisplayFisicoAuttar.this.displayVazio = false;
        }

        @Override
        public void liberaRecursos() throws ExcecaoPerifericos {
            if (this.getHabilitado()) {
                this.desabilita();
            }
        }
    }

    static interface GertecLibrary
    extends Library {
        public int OpenTec65();

        public void CloseTec65();

        public void DispStr(String var1);

        public void GoToXY(int var1, int var2);

        public void LcdClearLine(int var1);

        public void ModoCursor(int var1);
    }
}

