/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.generic;

import com.csi.ctfclient.tools.devices.Display;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Arrays;
import javax.swing.JPanel;
import javax.swing.JTextPane;

public class JPanelDisplay
extends JPanel
implements Display {
    private static final long serialVersionUID = 1L;
    private final byte[] bufferedText;
    private final int numColunas;
    private int numLinhas;
    private int posAtual = 0;
    private JTextPane textArea;

    public JPanelDisplay(String linha, String coluna) {
        this(Integer.parseInt(linha.trim()), Integer.parseInt(coluna.trim()));
    }

    public JPanelDisplay(int linha, int coluna) {
        this(linha, coluna, new Color(153, 153, 153));
    }

    public JPanelDisplay(int linha, int coluna, Color background) {
        this.numLinhas = linha;
        this.numColunas = coluna;
        this.bufferedText = new byte[this.numLinhas * this.numColunas];
        Arrays.fill(this.bufferedText, (byte)32);
        this.setBackground(background);
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add(this.builtEditorPanel());
        this.textArea.setOpaque(false);
        FontMetrics fm = this.textArea.getFontMetrics(this.textArea.getFont());
        int comp = (this.numColunas + 1) * fm.charWidth('\u00c7');
        this.textArea.setPreferredSize(new Dimension(comp, fm.getHeight() * this.numLinhas));
        this.atualizaDisplay();
    }

    private void atualizaDisplay() {
        StringBuilder stringBuffer = new StringBuilder();
        for (int i = 0; i < this.numLinhas; ++i) {
            stringBuffer.append(new String(this.bufferedText, i * this.numColunas, this.numColunas)).append("\n");
        }
        this.textArea.setContentType("text");
        this.textArea.setText(stringBuffer.toString());
    }

    private JTextPane builtEditorPanel() {
        if (this.textArea == null) {
            this.textArea = new JTextPane();
            this.textArea.setFocusable(false);
            this.textArea.setEditable(false);
            this.textArea.setFont(new Font("Courier new", 0, 12));
        }
        return this.textArea;
    }

    @Override
    public void desabilita() throws ExcecaoPerifericos {
        this.textArea.setVisible(false);
    }

    @Override
    public int getColunaAtual() {
        return this.posAtual % this.numColunas;
    }

    @Override
    public int getLinhaAtual() {
        return this.posAtual / this.numColunas;
    }

    @Override
    public int getNumColunas() {
        return this.numColunas;
    }

    @Override
    public int getNumLinhas() {
        return this.numLinhas;
    }

    @Override
    public String getTexto() throws ExcecaoPerifericos {
        return new String(this.bufferedText);
    }

    @Override
    public void habilita() throws ExcecaoPerifericos {
        this.limpa();
    }

    @Override
    public void imprime(String texto) throws ExcecaoPerifericos {
        int tamStr = texto.length();
        int qtdeChrs = this.numColunas * this.numLinhas;
        if (this.posAtual > qtdeChrs) {
            return;
        }
        if (this.posAtual + tamStr > qtdeChrs) {
            tamStr = qtdeChrs - this.posAtual;
            texto = texto.substring(0, tamStr);
        }
        byte[] txtChrs = StringUtil.asciiToByteArray(texto);
        System.arraycopy(txtChrs, 0, this.bufferedText, this.posAtual, tamStr);
        this.posAtual += tamStr;
        this.atualizaDisplay();
    }

    @Override
    public void printPNG(String path) throws ExcecaoPerifericos {
        this.printPNG("", "", "", path);
    }

    @Override
    public void printPNG(String header, String footer1, String footer2, String path) throws ExcecaoPerifericos {
        String html = "<html><style>div {display: block; width: 180px;text-align: center; font-family: 'Courier New', monospace; }p { margin: 5px 0px 5px 0px; color:black ; font-size: 11px }</style><body><div><p>" + header + "</p><img src='file:///" + path + "'><p>" + footer1 + "<br>" + footer2 + "</p></div></body></html>";
        this.textArea.setContentType("text/html");
        this.textArea.setText(html);
    }

    @Override
    public void imprimeBackSpace() {
        if (this.posAtual > 0) {
            this.bufferedText[--this.posAtual] = 32;
        }
        this.atualizaDisplay();
    }

    @Override
    public void imprimeEm(int linha, int coluna, String texto) throws ExcecaoPerifericos {
        this.posicionaCursor(linha, coluna);
        this.imprime(texto);
    }

    @Override
    public void liberaRecursos() throws ExcecaoPerifericos {
    }

    @Override
    public void limpa() throws ExcecaoPerifericos {
        this.posAtual = 0;
        for (int i = 0; i < this.numLinhas * this.numColunas; ++i) {
            this.bufferedText[i] = 32;
        }
        this.atualizaDisplay();
    }

    @Override
    public void limpaEImprime(String texto) throws ExcecaoPerifericos {
        this.limpa();
        this.imprime(texto);
    }

    @Override
    public void limpaEImprimeEm(int linha, int coluna, String texto) throws ExcecaoPerifericos {
        this.limpa();
        this.imprimeEm(linha, coluna, texto);
    }

    @Override
    public void posicionaCursor(int linha, int coluna) throws ExcecaoPerifericos {
        if (linha >= 0 && linha < this.numLinhas && coluna >= 0 && coluna < this.numColunas) {
            this.posAtual = linha * this.numColunas + coluna;
        }
    }
}

