/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.generic;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.devices.Teclado;
import com.csi.ctfclient.tools.devices.config.ConfiguracaoTeclado;
import com.csi.ctfclient.tools.devices.generic.EventoSequenciaTeclado;
import com.csi.ctfclient.tools.devices.generic.ProtocoloTecladoPC;
import com.csi.ctfclient.tools.devices.generic.ProtocoloTecladoPCListener;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;

public class TecladoPC
extends Teclado
implements ProtocoloTecladoPCListener {
    private AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(Periferico.class);
    private ProtocoloTecladoPC proto;

    public TecladoPC() throws ExcecaoPerifericos {
    }

    public TecladoPC(ConfiguracaoTeclado config, Frame janela) throws ExcecaoPerifericos {
        super(config, janela);
    }

    @Override
    public void desabilita() throws ExcecaoPerifericos {
        this.setHabilitado(false);
        super.desabilita();
    }

    @Override
    public void habilita() throws ExcecaoPerifericos {
        this.setHabilitado(true);
    }

    public void keyPressed(KeyEvent evt) {
        int result = 0;
        result = evt.getKeyCode() == 0 && evt.getKeyChar() != '\u0000' ? 512 + evt.getKeyChar() : evt.getKeyCode();
        if (evt.isShiftDown()) {
            result += 256;
        }
        this.logger.debug("code = " + result);
        super.teclaRecebida(result);
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void liberaRecursos() throws ExcecaoPerifericos {
        this.desabilita();
        super.liberaRecursos();
        if (this.proto != null) {
            this.proto.removeProtocoloTecladoPCListener(this);
        }
    }

    public void windowActivated(WindowEvent evt) {
        ((Frame)evt.getSource()).requestFocus();
    }

    public void windowClosed(WindowEvent evt) {
    }

    public void windowClosing(WindowEvent evt) {
    }

    public void windowDeactivated(WindowEvent evt) {
    }

    public void windowDeiconified(WindowEvent evt) {
    }

    public void windowIconified(WindowEvent evt) {
    }

    public void windowOpened(WindowEvent evt) {
    }

    @Override
    public void codigoDigitado(EventoSequenciaTeclado ev) {
        int[] resposta = ev.getSeqLida();
        int tamResp = ev.getNumCaracteresDigitados();
        for (int i = 0; i < tamResp; ++i) {
            this.teclaRecebida(resposta[i]);
        }
    }

    @Override
    public void setFrame(Frame frame) {
        super.setFrame(frame);
        if (this.getFrame() != null) {
            try {
                this.proto = ProtocoloTecladoPC.getInstancia(frame);
                this.proto.addProtocoloTecladoPCListener(null, null, 1, null, this);
            }
            catch (ExcecaoPerifericos e) {
                this.logger.warn("Erro ao tentar ajustar o frame do Teclado PC: " + e.getMessage());
            }
        }
    }
}

