/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.javapos;

import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.Scanner;
import jpos.JposException;
import jpos.events.DataEvent;
import jpos.events.DataListener;

public class ScannerJavaPOS
extends Scanner
implements DataListener {
    private jpos.Scanner scanner;

    public ScannerJavaPOS() throws ExcecaoPerifericos {
        this("defaultScanner");
    }

    public ScannerJavaPOS(String nomeLogico) throws ExcecaoPerifericos {
        try {
            this.scanner = new jpos.Scanner();
            this.scanner.addDataListener((DataListener)this);
            this.scanner.open(nomeLogico);
            this.scanner.claim(100);
        }
        catch (JposException e) {
            throw new ExcecaoPerifericos("SJPOS01", "Erro na instanciacao do scanner " + nomeLogico, e.getMessage());
        }
    }

    public synchronized void dataOccurred(DataEvent ev) {
        try {
            byte[] aux = this.scanner.getScanData();
            String codigo = new String(aux);
            this.codigoRecebido(codigo);
            this.scanner.setDataEventEnabled(true);
        }
        catch (JposException jposException) {
            // empty catch block
        }
    }

    @Override
    public void desabilita() throws ExcecaoPerifericos {
        try {
            this.scanner.setDeviceEnabled(false);
            this.setHabilitado(false);
            super.desabilita();
        }
        catch (JposException e) {
            throw new ExcecaoPerifericos("SJPOS02", "Erro na desabilitacao do scanner", e.getMessage());
        }
    }

    @Override
    public void habilita() throws ExcecaoPerifericos {
        try {
            this.scanner.setDeviceEnabled(true);
            this.scanner.setDataEventEnabled(true);
            this.setHabilitado(true);
        }
        catch (JposException e) {
            throw new ExcecaoPerifericos("SJPOS03", "Erro na habilitacao do scanner", e.getMessage());
        }
    }

    @Override
    public void liberaRecursos() throws ExcecaoPerifericos {
        try {
            this.scanner.setDeviceEnabled(false);
            this.scanner.release();
            this.scanner.close();
            this.scanner.removeDataListener((DataListener)this);
            super.liberaRecursos();
        }
        catch (JposException e) {
            throw new ExcecaoPerifericos("SJPOS04", "Erro na liberacao de recursos", e.getMessage());
        }
    }
}

