/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.postef.wifi;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.devices.postef.ProvedorMensagemHandler;
import com.csi.ctfclient.tools.devices.postef.model.TipoMensagem;
import com.csi.ctfclient.tools.devices.postef.wifi.Protocolo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.Socket;

public class ProvedorMensagemWifi
extends ProvedorMensagemHandler<Socket> {
    private AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(Periferico.class);
    private Protocolo protocolo;

    public ProvedorMensagemWifi(TipoMensagem tipoMensagem, Socket provider) {
        super(tipoMensagem, provider);
    }

    public Protocolo getProtocolo() {
        if (this.protocolo != null) {
            return this.protocolo;
        }
        try {
            Socket socket = (Socket)this.getProvedor();
            Protocolo.Header header = Protocolo.header(socket.getInputStream());
            this.logger.info("mensagem recebida: " + header);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[header.getTamanhoMensagem()];
            int count = 0;
            for (int i = 0; i < header.getTamanhoMensagem(); i += count) {
                count = socket.getInputStream().read(data);
                buffer.write(data, 0, count);
            }
            String msg = new String(buffer.toByteArray());
            this.logger.debug("dados recebidos: " + msg);
            this.protocolo = Protocolo.build(header, msg);
            return this.protocolo;
        }
        catch (Exception e) {
            this.logger.error("Erro no processamento de protocolo: " + e.getMessage());
            return null;
        }
    }

    @Override
    public <Type extends Serializable> void enviar(Type object) {
        String buffer = (String)((Object)object);
        try {
            ((Socket)this.getProvedor()).setKeepAlive(true);
            OutputStream ous = ((Socket)this.getProvedor()).getOutputStream();
            ous.write(buffer.getBytes());
            ous.flush();
            this.closeSocket((Socket)this.getProvedor());
        }
        catch (IOException e) {
            this.logger.error("Nao foi possivel enviar mensagem: " + e.getMessage());
        }
    }

    private void closeSocket(Socket socketChannel) {
        block5: {
            try {
                if (socketChannel == null) break block5;
                this.logger.debug("socket close");
                socketChannel.shutdownOutput();
                try {
                    int read = 0;
                    byte[] shutdown = new byte[4];
                    while ((read = socketChannel.getInputStream().read(shutdown)) > 0) {
                        this.logger.debug("aguardando close: " + read);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                socketChannel.close();
                this.logger.debug("socket close ok");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

