/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.procomp;

import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.LeitorDocumento;
import com.csi.ctfclient.tools.devices.generic.ExcecaoPortaSerial;
import com.csi.ctfclient.tools.devices.generic.PortaSerial;
import java.io.IOException;
import java.io.InputStream;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.swing.JFrame;

public class LeitorDocumentoProcomp
extends LeitorDocumento
implements Runnable,
SerialPortEventListener {
    Thread leitorThread;
    private final PortaSerial serial = new PortaSerial();
    private final byte[] bufferLeitura = new byte[12600];
    private boolean comunicacaoAberta = false;
    private final String databits;
    private boolean esperandoLRC;
    private boolean fimRecepcao;
    private InputStream inputStream;
    private int numBytesLidos;
    private final String parity;
    private final String porta;
    private final String speed;
    private final String stopbits;
    private boolean leitorFinalizado = false;

    public LeitorDocumentoProcomp(JFrame frame, String porta) {
        this.porta = porta;
        this.speed = "2400";
        this.databits = "7";
        this.parity = "O";
        this.stopbits = "1";
        this.esperandoLRC = false;
        this.leitorThread = new Thread(this);
        this.leitorThread.start();
    }

    public LeitorDocumentoProcomp(JFrame frame, String porta, String speed, String databits, String parity, String stopbits) {
        this.porta = porta;
        this.speed = speed;
        this.databits = databits;
        this.parity = parity;
        this.stopbits = stopbits;
        this.esperandoLRC = false;
        this.leitorThread = new Thread(this);
        this.leitorThread.start();
    }

    @Override
    public void liberaRecursos() throws ExcecaoPerifericos {
        this.desabilita();
        this.leitorFinalizado = true;
        this.leitorThread = null;
        super.liberaRecursos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean achouErro = false;
        while (!this.leitorFinalizado) {
            while (!this.getHabilitado()) {
                LeitorDocumentoProcomp leitorDocumentoProcomp = this;
                synchronized (leitorDocumentoProcomp) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!this.leitorFinalizado) continue;
                return;
            }
            if (!this.getHabilitado() || !this.fimRecepcao) continue;
            this.fimRecepcao = false;
            byte[] resposta = new byte[this.numBytesLidos - 3];
            int tipo = 1;
            for (int cont = 0; cont < resposta.length; ++cont) {
                if (this.bufferLeitura[cont + 1] == 63) {
                    achouErro = true;
                    break;
                }
                if (this.bufferLeitura[cont + 1] < 48 || this.bufferLeitura[cont + 1] > 57) {
                    tipo = 0;
                }
                resposta[cont] = this.bufferLeitura[cont + 1];
            }
            if (!achouErro) {
                String str = new String(resposta);
                this.codigoLido(str, tipo);
            } else {
                achouErro = false;
                this.erroOcorrido("PER86", tipo);
            }
            this.numBytesLidos = 0;
            this.setHabilitado(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void serialEvent(SerialPortEvent event) {
        block15: {
            switch (event.getEventType()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    return;
                }
                case 1: {
                    try {}
                    catch (IOException e) {
                        this.esperandoLRC = false;
                        return;
                    }
                    break block15;
                }
            }
            return;
        }
        while (this.inputStream.available() > 0) {
            byte aux = (byte)this.inputStream.read();
            if (aux == 2 && !this.esperandoLRC) {
                this.numBytesLidos = 1;
                this.bufferLeitura[this.numBytesLidos - 1] = aux;
            } else if (aux == 3 && !this.esperandoLRC) {
                this.esperandoLRC = true;
                ++this.numBytesLidos;
                this.bufferLeitura[this.numBytesLidos - 1] = aux;
            } else if (this.esperandoLRC) {
                this.esperandoLRC = false;
                ++this.numBytesLidos;
                this.bufferLeitura[this.numBytesLidos - 1] = aux;
                this.fimRecepcao = true;
            } else {
                ++this.numBytesLidos;
                this.bufferLeitura[this.numBytesLidos - 1] = aux;
            }
            if (!this.fimRecepcao) continue;
            this.esperandoLRC = false;
            LeitorDocumentoProcomp leitorDocumentoProcomp = this;
            synchronized (leitorDocumentoProcomp) {
                this.notifyAll();
            }
        }
    }

    @Override
    public void desabilita() throws ExcecaoPerifericos {
        if (this.comunicacaoAberta) {
            this.serial.fecharPortaSerial();
        }
        this.comunicacaoAberta = false;
        this.setHabilitado(false);
        super.desabilita();
    }

    @Override
    public void habilita() throws ExcecaoPerifericos {
        try {
            if (this.comunicacaoAberta) {
                return;
            }
            this.serial.abrirPortaSerial(this, this.porta, this.speed, this.databits, this.parity, this.stopbits);
            try {
                this.inputStream = this.serial.port.getInputStream();
            }
            catch (IOException e) {
                this.serial.port.close();
                throw new ExcecaoPerifericos("LDP01", "Erro na obtencao do stream de entrada do leitor de documentos", e.getMessage());
            }
            this.comunicacaoAberta = true;
            this.setHabilitado(true);
        }
        catch (ExcecaoPortaSerial e) {
            throw new ExcecaoPerifericos("LDP02", "Erro na habilitacao do leitor de documentos", e.getMessage());
        }
    }
}

