/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.util;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.util.ByteUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class AuttarSecurity {
    public static final String ALGORITHM_3DES_KEY = "DESede";
    public static final String ALGORITHM_AES_KEY = "AES";
    public static final String ALGORITHM_RSA_KEY = "RSA";
    public static final String ALGORITHM_MD5_KEY = "MD5";
    public static final String ALGORITHM_SHA_1_KEY = "SHA-1";
    public static final String ALGORITHM_SHA_256_KEY = "SHA-256";
    public static final String CIPHER_AES = "AES";
    public static final String CIPHER_RSA = "RSA";
    public static final String CIPHER_RSA_ECB_PKCS = "RSA/ECB/PKCS1PADDING";
    public static final String PROVIDER_SUN_JCE = "SunJCE";
    public static final String PROVIDER_BOUNCY_CASTLE = "BC";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public static String criarSenhaAlfaNumerica(int tamanho) {
        char[] chars = new char[62];
        Random random = new Random();
        int j = 0;
        for (int i = 48; i < 123; ++i) {
            if (!Character.isLetterOrDigit(i)) continue;
            chars[j] = (char)i;
            ++j;
        }
        char[] senha = new char[tamanho];
        for (int i = 0; i < tamanho; ++i) {
            senha[i] = chars[random.nextInt(chars.length)];
        }
        return new String(senha);
    }

    public static String createKey(String algorithm) throws NoSuchAlgorithmException {
        return AuttarSecurity.createKey(128, algorithm);
    }

    public static String createKey(int size, String algorithm) throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm);
        keyGenerator.init(size);
        SecretKey secretKey = keyGenerator.generateKey();
        byte[] raw = secretKey.getEncoded();
        return ByteUtil.byteArrayToHex(raw);
    }

    public static KeyPair createRSAKey(int size) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(size, new SecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return keyPair;
    }

    private static String encrypt(String buffer, Key key, String algorithm) throws Exception {
        byte[] cipheredText = null;
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            if (algorithm.equals("AES")) {
                cipher.init(1, key);
            } else if (algorithm.equals(CIPHER_RSA_ECB_PKCS)) {
                cipher.init(1, key);
            } else if (algorithm.equals("RSA")) {
                cipher.init(1, key);
            }
            cipheredText = cipher.doFinal(buffer.getBytes());
        }
        catch (InvalidKeyException e) {
            throw new Exception("Chave invalida!");
        }
        catch (BadPaddingException e) {
            throw new Exception("Padding de cipher nao encontrado!");
        }
        catch (Exception e) {
            throw new Exception("Erro desconhecido ao cifrar dados!", e);
        }
        return ByteUtil.byteArrayToHex(cipheredText);
    }

    public static String encrypt(String buffer, String key, String algorithm) throws Exception {
        if (algorithm.equals(ALGORITHM_3DES_KEY)) {
            return AuttarSecurity.encrypt3DES(key, buffer);
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(ByteUtil.hexToByteArray(key), algorithm);
        return AuttarSecurity.encrypt(buffer, secretKeySpec, algorithm);
    }

    private static String decrypt(String buffer, Key key, String algorithm) throws Exception {
        byte[] plainText = null;
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            byte[] decifrar = ByteUtil.hexToByteArray(buffer);
            if (algorithm.equals("AES")) {
                cipher.init(2, key);
            } else if (algorithm.equals(CIPHER_RSA_ECB_PKCS)) {
                cipher.init(2, key);
            } else if (algorithm.equals("RSA")) {
                cipher.init(2, key);
            }
            plainText = cipher.doFinal(decifrar);
        }
        catch (InvalidKeyException e) {
            throw new Exception("Chave invalida!");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("Algoritmo de cipher nao encontrado!");
        }
        catch (NoSuchPaddingException e) {
            throw new Exception("Padding de cipher nao encontrado!");
        }
        catch (Exception e) {
            throw new Exception("Erro desconhecido ao decifrar dados!", e);
        }
        return new String(plainText);
    }

    public static String decrypt(String buffer, String key, String algorithm) throws Exception {
        if (algorithm.equals(ALGORITHM_3DES_KEY)) {
            return AuttarSecurity.decrypt3DES(key, buffer);
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(ByteUtil.hexToByteArray(key), algorithm);
        return AuttarSecurity.decrypt(buffer, secretKeySpec, algorithm);
    }

    public static String decrypt3DES(String key, String buffer) throws Exception {
        byte[] keyBytes = null;
        if (key.length() == 32) {
            keyBytes = Arrays.copyOf(ByteUtil.hexToByteArray(key), 24);
            int j = 0;
            int k = 16;
            while (j < 8) {
                keyBytes[k++] = keyBytes[j++];
            }
        } else if (key.length() == 48) {
            keyBytes = ByteUtil.hexToByteArray(key);
        } else {
            throw new IllegalArgumentException("tamanho de chave invalida (" + key.length() + ")");
        }
        DESedeKeySpec deSedeKeySpec = new DESedeKeySpec(keyBytes);
        SecretKey secretKey = SecretKeyFactory.getInstance(ALGORITHM_3DES_KEY).generateSecret(deSedeKeySpec);
        Cipher dcipher = Cipher.getInstance("DESede/ECB/NoPadding");
        dcipher.init(2, secretKey);
        byte[] data = dcipher.doFinal(ByteUtil.hexToByteArray(buffer));
        return ByteUtil.byteArrayToHex(data);
    }

    public static String encrypt3DES(String key, String buffer) throws Exception {
        byte[] keyBytes = null;
        if (key.length() == 32) {
            keyBytes = Arrays.copyOf(ByteUtil.hexToByteArray(key), 24);
            int j = 0;
            int k = 16;
            while (j < 8) {
                keyBytes[k++] = keyBytes[j++];
            }
        } else if (key.length() == 48) {
            keyBytes = ByteUtil.hexToByteArray(key);
        } else {
            throw new IllegalArgumentException("tamanho de chave invalida (" + key.length() + ")");
        }
        DESedeKeySpec deSedeKeySpec = new DESedeKeySpec(keyBytes);
        SecretKey secretKey = SecretKeyFactory.getInstance(ALGORITHM_3DES_KEY).generateSecret(deSedeKeySpec);
        Cipher dcipher = Cipher.getInstance("DESede/ECB/NoPadding");
        dcipher.init(1, secretKey);
        buffer = ByteUtil.byteArrayToHex(dcipher.doFinal(buffer.getBytes()));
        return buffer;
    }

    public static PublicKey getPublicKey(InputStream is, String ksPwd, String ksAlias) throws Exception {
        PublicKey publicKey = null;
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(is, ksPwd.toCharArray());
            is.close();
            X509Certificate cert = (X509Certificate)ks.getCertificate(ksAlias);
            publicKey = cert.getPublicKey();
        }
        catch (KeyStoreException e) {
            throw new Exception("Impossivel instanciar um KeyStore!");
        }
        catch (FileNotFoundException e) {
            throw new Exception("Nao foi possivel encontrar o arquivo do KeyStore!");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("Algoritmo de checagem do KeyStore nao encontrado!");
        }
        catch (IOException e) {
            throw new Exception("Erro de I/O na manipulacao do arquivo do KeyStore!");
        }
        return publicKey;
    }

    public static PrivateKey getPrivateKey(InputStream is, String ksPwd, String ksPrivatePwd, String ksAlias) throws Exception {
        PrivateKey privateKey = null;
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(is, ksPwd.toCharArray());
            is.close();
            privateKey = (PrivateKey)ks.getKey(ksAlias, ksPrivatePwd.toCharArray());
        }
        catch (KeyStoreException e) {
            throw new Exception("Impossivel instanciar um KeyStore!");
        }
        catch (FileNotFoundException e) {
            throw new Exception("Nao foi possivel encontrar o arquivo do KeyStore!");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("Algoritmo de checagem do KeyStore nao encontrado!");
        }
        catch (IOException e) {
            throw new Exception("Erro de I/O na manipulacao do arquivo do KeyStore!");
        }
        catch (UnrecoverableKeyException e) {
            throw new Exception("Nao foi possivel recuperar a chave do KeyStore!");
        }
        return privateKey;
    }

    public static String getHash(String buffer, String algorithm) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(buffer.getBytes());
            return ByteUtil.byteArrayToHex(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn(String.format("Algoritmo de hash %s nao encontrado: %s", algorithm, e.getMessage()));
            return null;
        }
    }
}

