/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.util;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.servicos.CTFClientCore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class KeyStoreUtil {
    private static final String KEYSTORE = "keystore.jks";
    private static final String STOREPASSWORD = "@ctfclient3.0auttar";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public static KeyStore getDefaultKeyStory() {
        logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);
        try {
            return KeyStoreUtil.createKeyStore(KEYSTORE, STOREPASSWORD);
        }
        catch (Exception e) {
            logger.error("Nao foi possivel carregar keystore: " + e.getMessage());
            return null;
        }
    }

    public static KeyStore createKeyStore(String fileName, String pw) throws Exception {
        File file = new File(fileName);
        KeyStore keyStore = KeyStore.getInstance("JCEKS");
        if (file.exists()) {
            keyStore.load(new FileInputStream(file), pw.toCharArray());
        } else {
            keyStore.load(null, null);
            keyStore.store(new FileOutputStream(fileName), pw.toCharArray());
        }
        return keyStore;
    }

    public static void store(KeyStore keyStore) throws Exception {
        File kf = new File(KEYSTORE);
        try {
            keyStore.store(new FileOutputStream(kf), STOREPASSWORD.toCharArray());
        }
        catch (KeyStoreException e) {
            logger.error("Erro de keystore no armazenamento: " + e.getMessage());
            throw new Exception(e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Erro de algoritmo no armazenamento: " + e.getMessage());
            throw new Exception(e);
        }
        catch (CertificateException e) {
            logger.error("Erro de certificado no armazenamento: " + e.getMessage());
            throw new Exception(e);
        }
        catch (FileNotFoundException e) {
            logger.error("Erro de arquivo nao encontrado no armazenamento: " + e.getMessage());
            throw new Exception(e);
        }
        catch (IOException e) {
            logger.error("Erro de IO no armazenamento: " + e.getMessage());
            throw new Exception(e);
        }
    }
}

